/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BookIcon {
    private final ItemStack itemStack;
    private final ResourceLocation texture;

    public BookIcon(ItemStack stack) {
        this.itemStack = stack;
        this.texture = null;
    }

    public BookIcon(ResourceLocation texture) {
        this.texture = texture;
        this.itemStack = ItemStack.f_41583_;
    }

    public static BookIcon fromString(ResourceLocation value) {
        if (value.m_135815_().endsWith(".png")) {
            return new BookIcon(value);
        }
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(value);
        return new BookIcon(new ItemStack((ItemLike)item));
    }

    public static BookIcon fromNetwork(FriendlyByteBuf buffer) {
        ResourceLocation rl = buffer.m_130281_();
        if (rl.m_135815_().endsWith(".png")) {
            return new BookIcon(rl);
        }
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(rl);
        return new BookIcon(new ItemStack((ItemLike)item));
    }

    public void render(GuiGraphics guiGraphics, int x, int y) {
        if (this.texture != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280398_(this.texture, x, y, 0, 0.0f, 0.0f, 16, 16, 16, 16);
        } else {
            guiGraphics.m_280480_(this.itemStack, x, y);
        }
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        if (this.texture != null) {
            buffer.m_130085_(this.texture);
        } else {
            buffer.m_130085_(BuiltInRegistries.f_257033_.m_7981_((Object)this.itemStack.m_41720_()));
        }
    }
}

