/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen.book;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookCommandModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryParentModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;

public class BookEntryModel {
    protected ResourceLocation id;
    protected BookCategoryModel category;
    protected List<BookEntryParentModel> parents = new ArrayList<BookEntryParentModel>();
    protected String name;
    protected String description = "";
    protected String icon;
    protected int x;
    protected int y;
    protected int entryBackgroundUIndex = 0;
    protected int entryBackgroundVIndex = 0;
    protected boolean hideWhileLocked;
    protected List<BookPageModel> pages = new ArrayList<BookPageModel>();
    protected BookConditionModel condition;
    protected ResourceLocation categoryToOpen;
    protected ResourceLocation commandToRunOnFirstRead;

    protected BookEntryModel(ResourceLocation id, String name) {
        this.id = id;
        this.name = name;
    }

    public static BookEntryModel create(ResourceLocation id, String name) {
        return new BookEntryModel(id, name);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("category", this.category.id.toString());
        json.addProperty("name", this.name);
        json.addProperty("description", this.description);
        json.addProperty("icon", this.icon);
        json.addProperty("x", (Number)this.x);
        json.addProperty("y", (Number)this.y);
        json.addProperty("background_u_index", (Number)this.entryBackgroundUIndex);
        json.addProperty("background_v_index", (Number)this.entryBackgroundVIndex);
        json.addProperty("hide_while_locked", Boolean.valueOf(this.hideWhileLocked));
        if (!this.parents.isEmpty()) {
            JsonArray parentsArray = new JsonArray();
            for (BookEntryParentModel parent : this.parents) {
                parentsArray.add((JsonElement)parent.toJson());
            }
            json.add("parents", (JsonElement)parentsArray);
        }
        if (!this.pages.isEmpty()) {
            JsonArray pagesArray = new JsonArray();
            for (BookPageModel page : this.pages) {
                pagesArray.add((JsonElement)page.toJson());
            }
            json.add("pages", (JsonElement)pagesArray);
        }
        if (this.condition != null) {
            json.add("condition", (JsonElement)this.condition.toJson());
        }
        if (this.categoryToOpen != null) {
            json.addProperty("category_to_open", this.categoryToOpen.toString());
        }
        if (this.commandToRunOnFirstRead != null) {
            json.addProperty("command_to_run_on_first_read", this.commandToRunOnFirstRead.toString());
        }
        return json;
    }

    public int getEntryBackgroundUIndex() {
        return this.entryBackgroundUIndex;
    }

    public int getEntryBackgroundVIndex() {
        return this.entryBackgroundVIndex;
    }

    public BookConditionModel getCondition() {
        return this.condition;
    }

    public ResourceLocation getCategoryToOpen() {
        return this.categoryToOpen;
    }

    public ResourceLocation getCommandToRunOnFirstRead() {
        return this.commandToRunOnFirstRead;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public BookCategoryModel getCategory() {
        return this.category;
    }

    public List<BookEntryParentModel> getParents() {
        return this.parents;
    }

    public void addParent(BookEntryParentModel parent) {
        this.parents.add(parent);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIcon() {
        return this.icon;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isHideWhileLocked() {
        return this.hideWhileLocked;
    }

    public List<BookPageModel> getPages() {
        return this.pages;
    }

    public BookEntryModel withId(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public BookEntryModel withCategory(BookCategoryModel category) {
        this.category = category;
        return this;
    }

    public BookEntryModel withParents(List<BookEntryParentModel> parents) {
        this.parents = parents;
        return this;
    }

    public BookEntryModel withParents(BookEntryParentModel ... parents) {
        this.parents.addAll(List.of(parents));
        return this;
    }

    public BookEntryModel withParent(BookEntryParentModel parent) {
        this.parents.add(parent);
        return this;
    }

    public BookEntryModel withParent(BookEntryModel parent) {
        this.parents.add(BookEntryParentModel.create(parent.id));
        return this;
    }

    public BookEntryModel withName(String name) {
        this.name = name;
        return this;
    }

    public BookEntryModel withDescription(String description) {
        this.description = description;
        return this;
    }

    public BookEntryModel withIcon(String icon) {
        this.icon = icon;
        return this;
    }

    public BookEntryModel withIcon(ResourceLocation icon) {
        this.icon = icon.toString();
        return this;
    }

    public BookEntryModel withIcon(ItemLike item) {
        this.icon = BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_()).toString();
        return this;
    }

    public BookEntryModel withLocation(Vec2 location) {
        return this.withX((int)location.f_82470_).withY((int)location.f_82471_);
    }

    public BookEntryModel withLocation(int x, int y) {
        return this.withX(x).withY(y);
    }

    public BookEntryModel withX(int x) {
        this.x = x;
        return this;
    }

    public BookEntryModel withY(int y) {
        this.y = y;
        return this;
    }

    public BookEntryModel withEntryBackground(int u, int v) {
        this.entryBackgroundUIndex = u;
        this.entryBackgroundVIndex = v;
        return this;
    }

    public BookEntryModel withEntryBackground(Pair<Integer, Integer> uv) {
        this.entryBackgroundUIndex = (Integer)uv.getFirst();
        this.entryBackgroundVIndex = (Integer)uv.getSecond();
        return this;
    }

    public BookEntryModel hideWhileLocked(boolean hideWhileLocked) {
        this.hideWhileLocked = hideWhileLocked;
        return this;
    }

    public BookEntryModel withPages(List<BookPageModel> pages) {
        this.pages = pages;
        return this;
    }

    public BookEntryModel withPages(BookPageModel ... pages) {
        this.pages.addAll(List.of(pages));
        return this;
    }

    public BookEntryModel withPage(BookPageModel page) {
        this.pages.add(page);
        return this;
    }

    public BookEntryModel withCondition(BookConditionModel condition) {
        this.condition = condition;
        return this;
    }

    public BookEntryModel withCategoryToOpen(ResourceLocation categoryToOpen) {
        this.categoryToOpen = categoryToOpen;
        return this;
    }

    public BookEntryModel withCommandToRunOnFirstRead(BookCommandModel bookCommandModel) {
        return this.withCommandToRunOnFirstRead(bookCommandModel.getId());
    }

    public BookEntryModel withCommandToRunOnFirstRead(ResourceLocation bookCommandModel) {
        this.commandToRunOnFirstRead = bookCommandModel;
        return this;
    }
}

