/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.klikli_dev.modonomicon.api.datagen.BookContextHelper;
import com.klikli_dev.modonomicon.api.datagen.BookProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryEntryMap;
import com.klikli_dev.modonomicon.api.datagen.ConditionHelper;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryParentModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookAndConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookOrConditionModel;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class CategoryProvider {
    protected BookProvider parent;
    protected String categoryId;
    protected CategoryEntryMap entryMap;
    protected Map<String, String> macros;
    protected ConditionHelper conditionHelper;
    protected BookCategoryModel category;

    public CategoryProvider(BookProvider parent, String categoryId) {
        this.parent = parent;
        this.categoryId = categoryId;
        this.entryMap = new CategoryEntryMap();
        this.macros = new HashMap<String, String>();
        this.conditionHelper = new ConditionHelper();
        this.category = null;
    }

    public String categoryId() {
        return this.categoryId;
    }

    protected LanguageProvider lang() {
        return this.parent.lang();
    }

    protected LanguageProvider lang(String locale) {
        return this.parent.lang();
    }

    protected ResourceLocation modLoc(String name) {
        return this.parent.modLoc(name);
    }

    protected BookContextHelper context() {
        return this.parent.context();
    }

    protected ConditionHelper condition() {
        return this.parent.condition();
    }

    protected CategoryEntryMap entryMap() {
        return this.entryMap;
    }

    protected void registerMacro(String macro, String value) {
        this.macros.put(macro, value);
    }

    protected Map<String, String> macros() {
        return this.macros;
    }

    protected String macro(String input) {
        for (Map.Entry<String, String> entry : this.macros.entrySet()) {
            input = input.replace(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.parent.defaultMacros().entrySet()) {
            input = input.replace(entry.getKey(), entry.getValue());
        }
        return input;
    }

    protected String format(String pattern, Object ... arguments) {
        return MessageFormat.format(pattern, arguments);
    }

    protected String entryLink(String text, String category, String entry) {
        return this.format("[{0}](entry://{1}/{2})", text, category, entry);
    }

    protected String categoryLink(String text, String category) {
        return this.format("[{0}](category://{1})", text, category);
    }

    protected String itemLink(ItemLike item) {
        return this.itemLink("", item);
    }

    protected String itemLink(String text, ItemLike item) {
        ResourceLocation rl = ForgeRegistries.ITEMS.getKey((Object)item.m_5456_());
        return this.format("[{0}](item://{1})", text, rl);
    }

    protected String commandLink(String text, String commandId) {
        return this.format("[{0}](command://{1})", text, commandId);
    }

    protected String entryLinkDummy(String text, String category, String entry) {
        return this.format("[{0}]()", text, category, entry);
    }

    protected String categoryLinkDummy(String text, String category) {
        return this.format("[{0}]()", text, category);
    }

    protected BookEntryModel entry(String location, String icon) {
        return this.entry(location).withIcon(icon);
    }

    protected BookEntryModel entry(String location, ItemLike icon) {
        return this.entry(location).withIcon(icon);
    }

    protected BookEntryModel entry(char location, String icon) {
        return this.entry(location).withIcon(icon);
    }

    protected BookEntryModel entry(char location, ItemLike icon) {
        return this.entry(location).withIcon(icon);
    }

    protected BookEntryModel entry(char location) {
        return this.entry().withLocation(this.entryMap().get(Character.valueOf(location)));
    }

    protected BookEntryModel entry(String location) {
        return this.entry().withLocation(this.entryMap().get(location));
    }

    protected BookEntryModel entry() {
        return BookEntryModel.create(this.modLoc(this.context().categoryId() + "/" + this.context().entryId()), this.context().entryName()).withDescription(this.context().entryDescription());
    }

    protected BookEntryParentModel parent(BookEntryModel parentEntry) {
        return BookEntryParentModel.create(parentEntry.getId());
    }

    public BookAndConditionModel and(BookConditionModel ... children) {
        return this.condition().and(children);
    }

    public BookOrConditionModel or(BookConditionModel ... children) {
        return this.condition().or(children);
    }

    protected void add(String key, String value) {
        this.lang().add(key, this.macro(value));
    }

    protected void add(LanguageProvider translation, String key, String value) {
        translation.add(key, this.macro(value));
    }

    protected void add(String key, String pattern, Object ... args) {
        this.add(key, this.format(pattern, args));
    }

    protected void add(LanguageProvider translation, String key, String pattern, Object ... args) {
        this.add(translation, key, this.format(pattern, args));
    }

    protected BookEntryModel add(BookEntryModel entry) {
        this.category.withEntry(entry);
        return entry;
    }

    protected List<BookEntryModel> add(List<BookEntryModel> entries) {
        this.category.withEntries(entries);
        return entries;
    }

    public BookCategoryModel generate() {
        this.context().category(this.categoryId);
        this.entryMap().setMap(this.generateEntryMap());
        this.category = this.generateCategory();
        this.generateEntries();
        return this.category;
    }

    protected abstract String[] generateEntryMap();

    protected abstract void generateEntries();

    protected abstract BookCategoryModel generateCategory();
}

