/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.jmi.jmoverlay.ftbchunks;

import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManagerImpl;
import java.util.Date;
import java.util.UUID;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.model.TextProperties;
import journeymap.client.api.util.PolygonHelper;
import me.frankv.jmi.JMI;

public class FTBClaimedChunkData {
    private final SendChunkPacket.SingleChunk chunk;
    private final ChunkDimPos chunkDimPos;
    private final boolean forceLoaded;
    private final UUID teamId;
    private ClientTeam team;
    private PolygonOverlay overlay;

    public FTBClaimedChunkData(MapDimension dim, SendChunkPacket.SingleChunk chunk, UUID teamId) {
        long now = new Date().getTime();
        this.chunk = chunk;
        this.chunkDimPos = new ChunkDimPos(dim.dimension, chunk.getX(), chunk.getZ());
        this.forceLoaded = chunk.getDateInfo(true, now).forceLoaded() != null;
        this.teamId = teamId;
        ClientTeamManagerImpl.getInstance().getTeam(teamId).ifPresent(team -> {
            this.team = team;
            this.overlay = this.makeOverlay();
        });
    }

    private PolygonOverlay makeOverlay() {
        int color = this.team.getColor();
        String displayId = "claimed_" + this.chunkDimPos.x() + "," + this.chunkDimPos.z();
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(0.0f).setFillColor(color).setFillOpacity(JMI.clientConfig.getClaimedChunkOverlayOpacity().floatValue());
        TextProperties textProps = new TextProperties().setColor(color).setOpacity(1.0f).setFontShadow(true);
        MapPolygon polygon = PolygonHelper.createChunkPolygon((int)this.chunkDimPos.x(), (int)1, (int)this.chunkDimPos.z());
        PolygonOverlay overlay = new PolygonOverlay("jmi", displayId, this.chunkDimPos.dimension(), shapeProps, polygon);
        overlay.setOverlayGroupName("Claimed Chunks").setTitle(this.team.getDisplayName()).setTextProperties(textProps);
        return overlay;
    }

    void updateOverlayProps() {
        int color = this.team.getColor();
        this.overlay.getTextProperties().setColor(color);
        this.overlay.getShapeProperties().setFillColor(color);
    }

    public SendChunkPacket.SingleChunk getChunk() {
        return this.chunk;
    }

    public ChunkDimPos getChunkDimPos() {
        return this.chunkDimPos;
    }

    public boolean isForceLoaded() {
        return this.forceLoaded;
    }

    public UUID getTeamId() {
        return this.teamId;
    }

    public ClientTeam getTeam() {
        return this.team;
    }

    public PolygonOverlay getOverlay() {
        return this.overlay;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FTBClaimedChunkData)) {
            return false;
        }
        FTBClaimedChunkData other = (FTBClaimedChunkData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isForceLoaded() != other.isForceLoaded()) {
            return false;
        }
        SendChunkPacket.SingleChunk this$chunk = this.getChunk();
        SendChunkPacket.SingleChunk other$chunk = other.getChunk();
        if (this$chunk == null ? other$chunk != null : !this$chunk.equals(other$chunk)) {
            return false;
        }
        ChunkDimPos this$chunkDimPos = this.getChunkDimPos();
        ChunkDimPos other$chunkDimPos = other.getChunkDimPos();
        if (this$chunkDimPos == null ? other$chunkDimPos != null : !this$chunkDimPos.equals(other$chunkDimPos)) {
            return false;
        }
        UUID this$teamId = this.getTeamId();
        UUID other$teamId = other.getTeamId();
        return !(this$teamId == null ? other$teamId != null : !((Object)this$teamId).equals(other$teamId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FTBClaimedChunkData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForceLoaded() ? 79 : 97);
        SendChunkPacket.SingleChunk $chunk = this.getChunk();
        result = result * 59 + ($chunk == null ? 43 : $chunk.hashCode());
        ChunkDimPos $chunkDimPos = this.getChunkDimPos();
        result = result * 59 + ($chunkDimPos == null ? 43 : $chunkDimPos.hashCode());
        UUID $teamId = this.getTeamId();
        result = result * 59 + ($teamId == null ? 43 : ((Object)$teamId).hashCode());
        return result;
    }
}

