/*
 * Decompiled with CFR 0.152.
 */
package com.shmeggels.niftyblocks.datagen;

import com.shmeggels.niftyblocks.init.BlockInit;
import com.shmeggels.niftyblocks.init.ItemInit;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "nifty", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(ItemInit.GUMBALL);
        this.simpleItem(ItemInit.DOOM_DISC);
        this.saplingItem(BlockInit.REDOAK_SAPLING);
        this.saplingItem(BlockInit.RUBBER_SAPLING);
        this.saplingItem(BlockInit.MAPLE_SAPLING);
        this.complexBlock((Block)BlockInit.CRASH_BARRIER.get());
        this.complexBlock((Block)BlockInit.CRASH_BARRIER_WOOD.get());
        this.complexBlock((Block)BlockInit.CRASH_BARRIER_CORNER.get());
        this.complexBlock((Block)BlockInit.CRASH_BARRIER_CORNER_WOOD.get());
        this.complexBlock((Block)BlockInit.CRASH_BARRIER_CORNER_ALT.get());
        this.complexBlock((Block)BlockInit.HYDRANT.get());
        this.complexBlock((Block)BlockInit.SCAFFOLDING_METAL.get());
        this.complexBlock((Block)BlockInit.SCAFFOLDING_WOOD.get());
        this.simpleItem(ItemInit.REDOAK_SIGN);
        this.simpleItem(ItemInit.REDOAK_HANGING_SIGN);
        this.buttonItem(BlockInit.REDOAK_BUTTON, BlockInit.REDOAK_PLANKS);
        this.fenceItem(BlockInit.REDOAK_FENCE, BlockInit.REDOAK_PLANKS);
        this.simpleBlockItem(BlockInit.REDOAK_DOOR);
        this.simpleItem(ItemInit.MAPLE_SIGN);
        this.simpleItem(ItemInit.MAPLE_HANGING_SIGN);
        this.buttonItem(BlockInit.MAPLE_BUTTON, BlockInit.MAPLE_PLANKS);
        this.fenceItem(BlockInit.MAPLE_FENCE, BlockInit.MAPLE_PLANKS);
        this.simpleBlockItem(BlockInit.MAPLE_DOOR);
    }

    private ItemModelBuilder saplingItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("nifty", "block/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder complexBlock(Block block) {
        return (ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_(), new ResourceLocation("nifty", "block/" + ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_()));
    }

    public void fenceItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/fence_inventory"))).texture("texture", new ResourceLocation("nifty", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    public void wallItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/wall_inventory"))).texture("wall", new ResourceLocation("nifty", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    public void buttonItem(RegistryObject<Block> block, RegistryObject<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.get())).m_135815_(), this.mcLoc("block/button_inventory"))).texture("texture", new ResourceLocation("nifty", "block/" + ForgeRegistries.BLOCKS.getKey((Object)((Block)baseBlock.get())).m_135815_()));
    }

    private ItemModelBuilder simpleBlockItem(RegistryObject<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("nifty", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder simpleItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("nifty", "item/" + item.getId().m_135815_()));
    }

    private ItemModelBuilder handheldItem(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), new ResourceLocation("item/handheld"))).texture("layer0", new ResourceLocation("nifty", "item/" + item.getId().m_135815_()));
    }
}

