/*
 * Decompiled with CFR 0.152.
 */
package com.shmeggels.niftyblocks.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class ModMultiFaceBlock
extends Block {
    private static final float AABB_OFFSET = 1.0f;
    private static final VoxelShape UP_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.f_55154_;
    private static final Map<Direction, VoxelShape> SHAPE_BY_DIRECTION = (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), p_153923_ -> {
        p_153923_.put(Direction.NORTH, NORTH_AABB);
        p_153923_.put(Direction.EAST, EAST_AABB);
        p_153923_.put(Direction.SOUTH, SOUTH_AABB);
        p_153923_.put(Direction.WEST, WEST_AABB);
        p_153923_.put(Direction.UP, UP_AABB);
        p_153923_.put(Direction.DOWN, DOWN_AABB);
    });
    protected static final Direction[] DIRECTIONS = Direction.values();
    private final ImmutableMap<BlockState, VoxelShape> shapesCache;
    private final boolean canRotate;
    private final boolean canMirrorX;
    private final boolean canMirrorZ;

    public ModMultiFaceBlock(BlockBehaviour.Properties p_153822_) {
        super(p_153822_);
        this.m_49959_(ModMultiFaceBlock.getDefaultMultifaceState((StateDefinition<Block, BlockState>)this.f_49792_));
        this.shapesCache = this.m_152458_(ModMultiFaceBlock::calculateMultifaceShape);
        this.canRotate = Direction.Plane.HORIZONTAL.m_122557_().allMatch(this::isFaceSupported);
        this.canMirrorX = Direction.Plane.HORIZONTAL.m_122557_().filter(Direction.Axis.X).filter(this::isFaceSupported).count() % 2L == 0L;
        this.canMirrorZ = Direction.Plane.HORIZONTAL.m_122557_().filter(Direction.Axis.Z).filter(this::isFaceSupported).count() % 2L == 0L;
    }

    public static Set<Direction> availableFaces(BlockState p_221585_) {
        if (!(p_221585_.m_60734_() instanceof ModMultiFaceBlock)) {
            return Set.of();
        }
        EnumSet<Direction> set = EnumSet.noneOf(Direction.class);
        for (Direction direction : Direction.values()) {
            if (!ModMultiFaceBlock.hasFace(p_221585_, direction)) continue;
            set.add(direction);
        }
        return set;
    }

    public static Set<Direction> unpack(byte p_221570_) {
        EnumSet<Direction> set = EnumSet.noneOf(Direction.class);
        for (Direction direction : Direction.values()) {
            if ((p_221570_ & (byte)(1 << direction.ordinal())) <= 0) continue;
            set.add(direction);
        }
        return set;
    }

    public static byte pack(Collection<Direction> p_221577_) {
        byte b0 = 0;
        for (Direction direction : p_221577_) {
            b0 = (byte)(b0 | 1 << direction.ordinal());
        }
        return b0;
    }

    protected boolean isFaceSupported(Direction p_153921_) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_153917_) {
        for (Direction direction : DIRECTIONS) {
            if (!this.isFaceSupported(direction)) continue;
            p_153917_.m_61104_(new Property[]{ModMultiFaceBlock.getFaceProperty(direction)});
        }
    }

    public BlockState m_7417_(BlockState p_153904_, Direction p_153905_, BlockState p_153906_, LevelAccessor p_153907_, BlockPos p_153908_, BlockPos p_153909_) {
        if (!ModMultiFaceBlock.hasAnyFace(p_153904_)) {
            return Blocks.f_50016_.m_49966_();
        }
        return ModMultiFaceBlock.hasFace(p_153904_, p_153905_) && !ModMultiFaceBlock.canAttachTo((BlockGetter)p_153907_, p_153905_, p_153909_, p_153906_) ? ModMultiFaceBlock.removeFace(p_153904_, ModMultiFaceBlock.getFaceProperty(p_153905_)) : p_153904_;
    }

    public VoxelShape m_5940_(BlockState p_153851_, BlockGetter p_153852_, BlockPos p_153853_, CollisionContext p_153854_) {
        return (VoxelShape)this.shapesCache.get((Object)p_153851_);
    }

    public boolean m_7898_(BlockState p_153888_, LevelReader p_153889_, BlockPos p_153890_) {
        boolean flag = false;
        for (Direction direction : DIRECTIONS) {
            if (!ModMultiFaceBlock.hasFace(p_153888_, direction)) continue;
            BlockPos blockpos = p_153890_.m_121945_(direction);
            if (!ModMultiFaceBlock.canAttachTo((BlockGetter)p_153889_, direction, blockpos, p_153889_.m_8055_(blockpos))) {
                return false;
            }
            flag = true;
        }
        return flag;
    }

    public boolean m_6864_(BlockState p_153848_, BlockPlaceContext p_153849_) {
        return ModMultiFaceBlock.hasAnyVacantFace(p_153848_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_153824_) {
        Level level = p_153824_.m_43725_();
        BlockPos blockpos = p_153824_.m_8083_();
        BlockState blockstate = level.m_8055_(blockpos);
        return Arrays.stream(p_153824_.m_6232_()).map(p_153865_ -> this.getStateForPlacement(blockstate, (BlockGetter)level, blockpos, (Direction)p_153865_)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public boolean isValidStateForPlacement(BlockGetter p_221572_, BlockState p_221573_, BlockPos p_221574_, Direction p_221575_) {
        if (!(!this.isFaceSupported(p_221575_) || p_221573_.m_60713_((Block)this) && ModMultiFaceBlock.hasFace(p_221573_, p_221575_))) {
            BlockPos blockpos = p_221574_.m_121945_(p_221575_);
            return ModMultiFaceBlock.canAttachTo(p_221572_, p_221575_, blockpos, p_221572_.m_8055_(blockpos));
        }
        return false;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockState p_153941_, BlockGetter p_153942_, BlockPos p_153943_, Direction p_153944_) {
        if (!this.isValidStateForPlacement(p_153942_, p_153941_, p_153943_, p_153944_)) {
            return null;
        }
        BlockState blockstate = p_153941_.m_60713_((Block)this) ? p_153941_ : (this.isWaterloggable() && p_153941_.m_60819_().m_164512_((Fluid)Fluids.f_76193_) ? (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)) : this.m_49966_());
        return (BlockState)blockstate.m_61124_((Property)ModMultiFaceBlock.getFaceProperty(p_153944_), (Comparable)Boolean.valueOf(true));
    }

    public BlockState m_6843_(BlockState p_153895_, Rotation p_153896_) {
        return !this.canRotate ? p_153895_ : this.mapDirections(p_153895_, arg_0 -> ((Rotation)p_153896_).m_55954_(arg_0));
    }

    public BlockState m_6943_(BlockState p_153892_, Mirror p_153893_) {
        if (p_153893_ == Mirror.FRONT_BACK && !this.canMirrorX) {
            return p_153892_;
        }
        return p_153893_ == Mirror.LEFT_RIGHT && !this.canMirrorZ ? p_153892_ : this.mapDirections(p_153892_, arg_0 -> ((Mirror)p_153893_).m_54848_(arg_0));
    }

    private BlockState mapDirections(BlockState p_153911_, Function<Direction, Direction> p_153912_) {
        BlockState blockstate = p_153911_;
        for (Direction direction : DIRECTIONS) {
            if (!this.isFaceSupported(direction)) continue;
            blockstate = (BlockState)blockstate.m_61124_((Property)ModMultiFaceBlock.getFaceProperty(p_153912_.apply(direction)), (Comparable)((Boolean)p_153911_.m_61143_((Property)ModMultiFaceBlock.getFaceProperty(direction))));
        }
        return blockstate;
    }

    public static boolean hasFace(BlockState p_153901_, Direction p_153902_) {
        BooleanProperty booleanproperty = ModMultiFaceBlock.getFaceProperty(p_153902_);
        return p_153901_.m_61138_((Property)booleanproperty) && (Boolean)p_153901_.m_61143_((Property)booleanproperty) != false;
    }

    public static boolean canAttachTo(BlockGetter p_153830_, Direction p_153831_, BlockPos p_153832_, BlockState p_153833_) {
        return Block.m_49918_((VoxelShape)p_153833_.m_60816_(p_153830_, p_153832_), (Direction)p_153831_.m_122424_()) || Block.m_49918_((VoxelShape)p_153833_.m_60812_(p_153830_, p_153832_), (Direction)p_153831_.m_122424_());
    }

    private boolean isWaterloggable() {
        return this.f_49792_.m_61092_().contains(BlockStateProperties.f_61362_);
    }

    private static BlockState removeFace(BlockState p_153898_, BooleanProperty p_153899_) {
        BlockState blockstate = (BlockState)p_153898_.m_61124_((Property)p_153899_, (Comparable)Boolean.valueOf(false));
        return ModMultiFaceBlock.hasAnyFace(blockstate) ? blockstate : Blocks.f_50016_.m_49966_();
    }

    public static BooleanProperty getFaceProperty(Direction p_153934_) {
        return PROPERTY_BY_DIRECTION.get(p_153934_);
    }

    private static BlockState getDefaultMultifaceState(StateDefinition<Block, BlockState> p_153919_) {
        BlockState blockstate = (BlockState)p_153919_.m_61090_();
        for (BooleanProperty booleanproperty : PROPERTY_BY_DIRECTION.values()) {
            if (!blockstate.m_61138_((Property)booleanproperty)) continue;
            blockstate = (BlockState)blockstate.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(false));
        }
        return blockstate;
    }

    private static VoxelShape calculateMultifaceShape(BlockState p_153959_) {
        VoxelShape voxelshape = Shapes.m_83040_();
        for (Direction direction : DIRECTIONS) {
            if (!ModMultiFaceBlock.hasFace(p_153959_, direction)) continue;
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SHAPE_BY_DIRECTION.get(direction));
        }
        return voxelshape.m_83281_() ? Shapes.m_83144_() : voxelshape;
    }

    protected static boolean hasAnyFace(BlockState p_153961_) {
        return Arrays.stream(DIRECTIONS).anyMatch(p_221583_ -> ModMultiFaceBlock.hasFace(p_153961_, p_221583_));
    }

    private static boolean hasAnyVacantFace(BlockState p_153963_) {
        return Arrays.stream(DIRECTIONS).anyMatch(p_221580_ -> !ModMultiFaceBlock.hasFace(p_153963_, p_221580_));
    }

    public abstract MultifaceSpreader getSpreader();
}

