/*
 * Decompiled with CFR 0.152.
 */
package com.shmeggels.niftyblocks.block;

import com.shmeggels.niftyblocks.init.BlockInit;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockScaffoldingWood
extends Block
implements SimpleWaterloggedBlock {
    private static final int TICK_DELAY = 1;
    private static final VoxelShape STABLE_SHAPE;
    private static final VoxelShape UNSTABLE_SHAPE;
    private static final VoxelShape UNSTABLE_SHAPE_BOTTOM;
    private static final VoxelShape BELOW_BLOCK;
    public static final int STABILITY_MAX_DISTANCE = 7;
    public static final IntegerProperty DISTANCE;
    public static final BooleanProperty WATERLOGGED;
    public static final BooleanProperty BOTTOM;

    public BlockScaffoldingWood(BlockBehaviour.Properties p_56021_) {
        super(p_56021_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(7))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_56051_) {
        p_56051_.m_61104_(new Property[]{DISTANCE, WATERLOGGED, BOTTOM});
    }

    public VoxelShape m_5940_(BlockState p_56057_, BlockGetter p_56058_, BlockPos p_56059_, CollisionContext p_56060_) {
        if (!p_56060_.m_7142_(p_56057_.m_60734_().m_5456_())) {
            return (Boolean)p_56057_.m_61143_((Property)BOTTOM) != false ? UNSTABLE_SHAPE : STABLE_SHAPE;
        }
        return Shapes.m_83144_();
    }

    public VoxelShape m_6079_(BlockState p_56053_, BlockGetter p_56054_, BlockPos p_56055_) {
        return Shapes.m_83144_();
    }

    public boolean m_6864_(BlockState p_56037_, BlockPlaceContext p_56038_) {
        return p_56038_.m_43722_().m_150930_(this.m_5456_());
    }

    public BlockState m_5573_(BlockPlaceContext p_56023_) {
        BlockPos blockpos = p_56023_.m_8083_();
        Level level = p_56023_.m_43725_();
        int i = BlockScaffoldingWood.getDistance((BlockGetter)level, blockpos);
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(blockpos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBottom((BlockGetter)level, blockpos, i)));
    }

    public void m_6807_(BlockState p_56062_, Level p_56063_, BlockPos p_56064_, BlockState p_56065_, boolean p_56066_) {
        if (!p_56063_.f_46443_) {
            p_56063_.m_186460_(p_56064_, (Block)this, 1);
        }
    }

    public BlockState m_7417_(BlockState p_56044_, Direction p_56045_, BlockState p_56046_, LevelAccessor p_56047_, BlockPos p_56048_, BlockPos p_56049_) {
        if (((Boolean)p_56044_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_56047_.m_186469_(p_56048_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_56047_));
        }
        if (!p_56047_.m_5776_()) {
            p_56047_.m_186460_(p_56048_, (Block)this, 1);
        }
        return p_56044_;
    }

    public void m_213897_(BlockState p_222019_, ServerLevel p_222020_, BlockPos p_222021_, RandomSource p_222022_) {
        int i = BlockScaffoldingWood.getDistance((BlockGetter)p_222020_, p_222021_);
        BlockState blockstate = (BlockState)((BlockState)p_222019_.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBottom((BlockGetter)p_222020_, p_222021_, i)));
        if ((Integer)blockstate.m_61143_((Property)DISTANCE) == 7) {
            if ((Integer)p_222019_.m_61143_((Property)DISTANCE) == 7) {
                FallingBlockEntity.m_201971_((Level)p_222020_, (BlockPos)p_222021_, (BlockState)blockstate);
            } else {
                p_222020_.m_46961_(p_222021_, true);
            }
        } else if (p_222019_ != blockstate) {
            p_222020_.m_7731_(p_222021_, blockstate, 3);
        }
    }

    public boolean m_7898_(BlockState p_56040_, LevelReader p_56041_, BlockPos p_56042_) {
        return BlockScaffoldingWood.getDistance((BlockGetter)p_56041_, p_56042_) < 7;
    }

    public VoxelShape m_5939_(BlockState p_56068_, BlockGetter p_56069_, BlockPos p_56070_, CollisionContext p_56071_) {
        if (p_56071_.m_6513_(Shapes.m_83144_(), p_56070_, true) && !p_56071_.m_6226_()) {
            return STABLE_SHAPE;
        }
        return (Integer)p_56068_.m_61143_((Property)DISTANCE) != 0 && (Boolean)p_56068_.m_61143_((Property)BOTTOM) != false && p_56071_.m_6513_(BELOW_BLOCK, p_56070_, true) ? UNSTABLE_SHAPE_BOTTOM : Shapes.m_83040_();
    }

    public FluidState m_5888_(BlockState p_56073_) {
        return (Boolean)p_56073_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_56073_);
    }

    private boolean isBottom(BlockGetter p_56028_, BlockPos p_56029_, int p_56030_) {
        return p_56030_ > 0 && !p_56028_.m_8055_(p_56029_.m_7495_()).m_60713_((Block)this);
    }

    public static int getDistance(BlockGetter p_56025_, BlockPos p_56026_) {
        Direction direction;
        BlockState blockstate1;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_56026_.m_122032_().m_122173_(Direction.DOWN);
        BlockState blockstate = p_56025_.m_8055_((BlockPos)blockpos$mutableblockpos);
        int i = 7;
        if (blockstate.m_60713_((Block)BlockInit.SCAFFOLDING_WOOD.get())) {
            i = (Integer)blockstate.m_61143_((Property)DISTANCE);
        } else if (blockstate.m_60783_(p_56025_, (BlockPos)blockpos$mutableblockpos, Direction.UP)) {
            return 0;
        }
        Iterator iterator = Direction.Plane.HORIZONTAL.iterator();
        while (iterator.hasNext() && (!(blockstate1 = p_56025_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122159_((Vec3i)p_56026_, direction = (Direction)iterator.next()))).m_60713_((Block)BlockInit.SCAFFOLDING_WOOD.get()) || (i = Math.min(i, (Integer)blockstate1.m_61143_((Property)DISTANCE) + 1)) != 1)) {
        }
        return i;
    }

    static {
        UNSTABLE_SHAPE_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
        BELOW_BLOCK = Shapes.m_83144_().m_83216_(0.0, -1.0, 0.0);
        DISTANCE = BlockStateProperties.f_61388_;
        WATERLOGGED = BlockStateProperties.f_61362_;
        BOTTOM = BlockStateProperties.f_61427_;
        VoxelShape voxelshape = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape voxelshape1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0);
        VoxelShape voxelshape2 = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0);
        VoxelShape voxelshape4 = Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        STABLE_SHAPE = Shapes.m_83124_((VoxelShape)voxelshape, (VoxelShape[])new VoxelShape[]{voxelshape1, voxelshape2, voxelshape3, voxelshape4});
        VoxelShape voxelshape5 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)16.0);
        VoxelShape voxelshape6 = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
        VoxelShape voxelshape7 = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0, (double)16.0);
        VoxelShape voxelshape8 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)2.0);
        UNSTABLE_SHAPE = Shapes.m_83124_((VoxelShape)UNSTABLE_SHAPE_BOTTOM, (VoxelShape[])new VoxelShape[]{STABLE_SHAPE, voxelshape6, voxelshape5, voxelshape8, voxelshape7});
    }
}

