/*
 * Decompiled with CFR 0.152.
 */
package com.shmeggels.niftyblocks.block;

import com.shmeggels.niftyblocks.init.ItemInit;
import com.shmeggels.niftyblocks.util.ModTags;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class BlockRubberTap
extends HorizontalDirectionalBlock {
    public static final int MAX_AGE = 2;
    public static final IntegerProperty AGE = BlockStateProperties.f_61406_;
    protected static final VoxelShape[] EAST_AABB = new VoxelShape[]{Block.m_49796_((double)8.5, (double)0.0, (double)5.0, (double)16.5, (double)12.0, (double)11.0), Block.m_49796_((double)8.5, (double)0.0, (double)5.0, (double)16.5, (double)12.0, (double)11.0), Block.m_49796_((double)8.5, (double)0.0, (double)5.0, (double)16.5, (double)12.0, (double)11.0)};
    protected static final VoxelShape[] WEST_AABB = new VoxelShape[]{Block.m_49796_((double)-0.5, (double)0.0, (double)5.0, (double)7.5, (double)12.0, (double)11.0), Block.m_49796_((double)-0.5, (double)0.0, (double)5.0, (double)7.5, (double)12.0, (double)11.0), Block.m_49796_((double)-0.5, (double)0.0, (double)5.0, (double)7.5, (double)12.0, (double)11.0)};
    protected static final VoxelShape[] NORTH_AABB = new VoxelShape[]{Block.m_49796_((double)5.0, (double)0.0, (double)-0.5, (double)11.0, (double)12.0, (double)7.5), Block.m_49796_((double)5.0, (double)0.0, (double)-0.5, (double)11.0, (double)12.0, (double)7.5), Block.m_49796_((double)5.0, (double)0.0, (double)-0.5, (double)11.0, (double)12.0, (double)7.5)};
    protected static final VoxelShape[] SOUTH_AABB = new VoxelShape[]{Block.m_49796_((double)5.0, (double)0.0, (double)8.5, (double)11.0, (double)12.0, (double)16.5), Block.m_49796_((double)5.0, (double)0.0, (double)8.5, (double)11.0, (double)12.0, (double)16.5), Block.m_49796_((double)5.0, (double)0.0, (double)8.5, (double)11.0, (double)12.0, (double)16.5)};

    public BlockRubberTap(BlockBehaviour.Properties p_51743_) {
        super(p_51743_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_6724_(BlockState p_51780_) {
        return (Integer)p_51780_.m_61143_((Property)AGE) < 2;
    }

    public void m_213898_(BlockState p_221000_, ServerLevel p_221001_, BlockPos p_221002_, RandomSource p_221003_) {
        int i = (Integer)p_221000_.m_61143_((Property)AGE);
        if (i < 2 && ForgeHooks.onCropsGrowPre((Level)p_221001_, (BlockPos)p_221002_, (BlockState)p_221000_, (p_221001_.f_46441_.m_188503_(5) == 0 ? 1 : 0) != 0)) {
            p_221001_.m_7731_(p_221002_, (BlockState)p_221000_.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)p_221001_, (BlockPos)p_221002_, (BlockState)p_221000_);
        }
    }

    public boolean m_7898_(BlockState p_51767_, LevelReader p_51768_, BlockPos p_51769_) {
        BlockState blockstate = p_51768_.m_8055_(p_51769_.m_121945_((Direction)p_51767_.m_61143_((Property)f_54117_)));
        return blockstate.m_204336_(ModTags.Blocks.TREE_TAP);
    }

    public VoxelShape m_5940_(BlockState p_51787_, BlockGetter p_51788_, BlockPos p_51789_, CollisionContext p_51790_) {
        int i = (Integer)p_51787_.m_61143_((Property)AGE);
        switch ((Direction)p_51787_.m_61143_((Property)f_54117_)) {
            case SOUTH: {
                return SOUTH_AABB[i];
            }
            default: {
                return NORTH_AABB[i];
            }
            case WEST: {
                return WEST_AABB[i];
            }
            case EAST: 
        }
        return EAST_AABB[i];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext p_51750_) {
        BlockState blockstate = this.m_49966_();
        Level levelreader = p_51750_.m_43725_();
        BlockPos blockpos = p_51750_.m_8083_();
        for (Direction direction : p_51750_.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(blockstate = (BlockState)blockstate.m_61124_((Property)f_54117_, (Comparable)direction)).m_60710_((LevelReader)levelreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    public BlockState m_7417_(BlockState p_51771_, Direction p_51772_, BlockState p_51773_, LevelAccessor p_51774_, BlockPos p_51775_, BlockPos p_51776_) {
        return p_51772_ == p_51771_.m_61143_((Property)f_54117_) && !p_51771_.m_60710_((LevelReader)p_51774_, p_51775_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(p_51771_, p_51772_, p_51773_, p_51774_, p_51775_, p_51776_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_51778_) {
        p_51778_.m_61104_(new Property[]{f_54117_, AGE});
    }

    public boolean m_7357_(BlockState p_51762_, BlockGetter p_51763_, BlockPos p_51764_, PathComputationType p_51765_) {
        return false;
    }

    public InteractionResult m_6227_(BlockState pBlockState, Level pLevel, BlockPos pBlockPos, Player pPlayer, InteractionHand pHand, BlockHitResult p_57280_) {
        boolean flag;
        int i = (Integer)pBlockState.m_61143_((Property)AGE);
        boolean bl = flag = i == 3;
        if (!flag && pPlayer.m_21120_(pHand).m_150930_((Item)ItemInit.RUBBER_RAW.get())) {
            return InteractionResult.PASS;
        }
        if (i > 1) {
            int j = 1 + pLevel.f_46441_.m_188503_(2);
            BlockRubberTap.m_49840_((Level)pLevel, (BlockPos)pBlockPos, (ItemStack)new ItemStack((ItemLike)ItemInit.RUBBER_RAW.get(), j + (flag ? 1 : 0)));
            pLevel.m_5594_((Player)null, pBlockPos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 0.8f + pLevel.f_46441_.m_188501_() * 0.4f);
            pLevel.m_7731_(pBlockPos, (BlockState)pBlockState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)), 2);
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return super.m_6227_(pBlockState, pLevel, pBlockPos, pPlayer, pHand, p_57280_);
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        if (Screen.m_96638_()) {
            pTooltip.add((Component)Component.m_237113_((String)"Place on Rubber Log to harvest Raw Rubber.").m_130940_(ChatFormatting.AQUA));
        } else {
            pTooltip.add((Component)Component.m_237113_((String)"Press SHIFT for more info").m_130940_(ChatFormatting.YELLOW));
        }
    }
}

