/*
 * Decompiled with CFR 0.152.
 */
package com.shmeggels.niftyblocks.block;

import com.shmeggels.niftyblocks.init.ItemInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class BlockPearTree
extends CropBlock {
    public static final int FIRST_STAGE_MAX_AGE = 5;
    public static final int SECOND_STAGE_MAX_AGE = 3;
    public static final int MAX_AGE = 5;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)};
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)8);

    public BlockPearTree(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_AGE[this.m_52305_(pState)];
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        float f;
        int currentAge;
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        if (pLevel.m_45524_(pPos, 0) >= 9 && (currentAge = this.m_52305_(pState)) < this.m_7419_() && ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188503_((int)(25.0f / (f = BlockPearTree.m_52272_((Block)this, (BlockGetter)pLevel, (BlockPos)pPos))) + 1) == 0 ? 1 : 0) != 0)) {
            if (currentAge == 5) {
                if (pLevel.m_8055_(pPos.m_6630_(1)).m_60713_(Blocks.f_50016_)) {
                    pLevel.m_7731_(pPos.m_6630_(1), this.m_52289_(currentAge + 1), 2);
                }
            } else {
                pLevel.m_7731_(pPos, this.m_52289_(currentAge + 1), 2);
            }
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public void m_52263_(Level pLevel, BlockPos pPos, BlockState pState) {
        int maxAge;
        int nextAge = this.m_52305_(pState) + this.m_7125_(pLevel);
        if (nextAge > (maxAge = this.m_7419_())) {
            nextAge = maxAge;
        }
        if (this.m_52305_(pState) == 5 && pLevel.m_8055_(pPos.m_6630_(1)).m_60713_(Blocks.f_50016_)) {
            pLevel.m_7731_(pPos.m_6630_(1), this.m_52289_(nextAge), 4);
        } else {
            pLevel.m_7731_(pPos, this.m_52289_(nextAge - 3), 4);
        }
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        return super.m_6266_(state, world, pos);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return super.m_7898_(pState, pLevel, pPos) || pLevel.m_8055_(pPos.m_6625_(1)).m_60713_((Block)this) && (Integer)pLevel.m_8055_(pPos.m_6625_(1)).m_61143_((Property)AGE) == 5;
    }

    public int m_7419_() {
        return 8;
    }

    protected ItemLike m_6404_() {
        return (ItemLike)ItemInit.PEAR_SEEDS.get();
    }

    public IntegerProperty m_7959_() {
        return AGE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE});
    }

    public InteractionResult m_6227_(BlockState pBlockState, Level pLevel, BlockPos pBlockPos, Player pPlayer, InteractionHand pHand, BlockHitResult p_57280_) {
        boolean flag;
        int i = (Integer)pBlockState.m_61143_((Property)AGE);
        boolean bl = flag = i == 8;
        if (!flag && pPlayer.m_21120_(pHand).m_150930_((Item)ItemInit.PEAR.get())) {
            return InteractionResult.PASS;
        }
        if (i > 7) {
            int j = 1 + pLevel.f_46441_.m_188503_(2);
            BlockPearTree.m_49840_((Level)pLevel, (BlockPos)pBlockPos, (ItemStack)new ItemStack((ItemLike)ItemInit.PEAR.get(), j + (flag ? 1 : 0)));
            pLevel.m_5594_((Player)null, pBlockPos, SoundEvents.f_11838_, SoundSource.BLOCKS, 1.0f, 0.8f + pLevel.f_46441_.m_188501_() * 0.4f);
            pLevel.m_7731_(pBlockPos, (BlockState)pBlockState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(6)), 7);
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return super.m_6227_(pBlockState, pLevel, pBlockPos, pPlayer, pHand, p_57280_);
    }

    public boolean m_7370_(LevelReader p_256056_, BlockPos p_57261_, BlockState p_57262_, boolean p_57263_) {
        return (Integer)p_57262_.m_61143_((Property)AGE) < 5;
    }

    public boolean m_214167_(Level p_222558_, RandomSource p_222559_, BlockPos p_222560_, BlockState p_222561_) {
        return true;
    }

    public void m_214148_(ServerLevel p_222553_, RandomSource p_222554_, BlockPos p_222555_, BlockState p_222556_) {
        int i = Math.min(3, (Integer)p_222556_.m_61143_((Property)AGE) + 1);
        p_222553_.m_7731_(p_222555_, (BlockState)p_222556_.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)), 6);
    }
}

