/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.item;

import earth.terrarium.handcrafted.common.entity.FancyPainting;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HangingEntityItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class CustomPaintingItem
extends HangingEntityItem {
    private final Supplier<PaintingVariant> defaultVariant;
    private final TagKey<PaintingVariant> variants;

    public CustomPaintingItem(Item.Properties settings, Supplier<PaintingVariant> defaultVariant, TagKey<PaintingVariant> variants) {
        super(EntityType.f_20506_, settings);
        this.defaultVariant = defaultVariant;
        this.variants = variants;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockPos pos2 = pos.m_121945_(direction);
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        Level level = context.m_43725_();
        if (player != null && !this.m_5595_(player, direction, stack, pos2)) {
            return InteractionResult.FAIL;
        }
        Optional<FancyPainting> optional = this.create(level, pos2, direction);
        if (optional.isEmpty()) {
            return InteractionResult.CONSUME;
        }
        FancyPainting painting = optional.get();
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            EntityType.m_20620_((Level)level, (Player)player, (Entity)painting, (CompoundTag)tag);
        }
        if (painting.m_7088_()) {
            if (!level.f_46443_) {
                painting.m_7084_();
                level.m_142346_((Entity)player, GameEvent.f_157810_, painting.m_20183_());
                level.m_7967_((Entity)painting);
            }
            stack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    public Optional<FancyPainting> create(Level level, BlockPos pos, Direction direction) {
        FancyPainting painting = new FancyPainting(level, pos, direction, (Holder<PaintingVariant>)BuiltInRegistries.f_257051_.m_263177_((Object)this.defaultVariant.get()));
        ArrayList<Holder> list = new ArrayList<Holder>();
        BuiltInRegistries.f_257051_.m_206058_(this.variants).forEach(list::add);
        if (!list.isEmpty()) {
            list.removeIf(holder -> {
                painting.m_28464_((Holder)holder);
                return !painting.m_7088_();
            });
            if (!list.isEmpty()) {
                int max = list.stream().mapToInt(CustomPaintingItem::variantArea).max().orElse(0);
                list.removeIf(holder -> CustomPaintingItem.variantArea((Holder<PaintingVariant>)holder) < max);
                return Util.m_214676_(list, (RandomSource)level.m_213780_()).map(holder -> {
                    painting.m_28464_((Holder)holder);
                    return painting;
                });
            }
        }
        return Optional.empty();
    }

    private static int variantArea(Holder<PaintingVariant> variant) {
        return ((PaintingVariant)variant.m_203334_()).m_218908_() * ((PaintingVariant)variant.m_203334_()).m_218909_();
    }
}

