/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.block.fancybed;

import earth.terrarium.handcrafted.common.block.ItemHoldingBlockEntity;
import earth.terrarium.handcrafted.common.block.fancybed.FancyBedBlockEntity;
import earth.terrarium.handcrafted.common.block.property.DirectionalBlockSide;
import earth.terrarium.handcrafted.common.registry.ModItems;
import earth.terrarium.handcrafted.common.registry.ModTags;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
public class FancyBedBlock
extends BedBlock {
    public static final EnumProperty<DirectionalBlockSide> BED_SHAPE = EnumProperty.m_61587_((String)"shape", DirectionalBlockSide.class);
    public static final VoxelShape X_AXIS_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)8.0, (double)15.0);
    public static final VoxelShape Z_AXIS_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)8.0, (double)16.0);

    public FancyBedBlock(BlockBehaviour.Properties properties) {
        super(DyeColor.WHITE, properties);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FancyBedBlockEntity(pos, state);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((Direction)state.m_61143_((Property)f_54117_)).m_122434_() == Direction.Axis.X ? X_AXIS_SHAPE : Z_AXIS_SHAPE;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof FancyBedBlockEntity) {
                FancyBedBlockEntity entity = (FancyBedBlockEntity)blockEntity;
                if (entity.getStack().m_41720_() != ModItems.WHITE_CUSHION.get()) {
                    ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, entity.getStack());
                    itemEntity.m_20256_(itemEntity.m_20184_().m_82490_(0.5));
                    level.m_7967_((Entity)itemEntity);
                    level.m_46717_(pos, (Block)this);
                }
                if (entity.getSheet().m_41720_() != ModItems.WHITE_SHEET.get()) {
                    ItemEntity itemEntity2 = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, entity.getSheet());
                    itemEntity2.m_20256_(itemEntity2.m_20184_().m_82490_(0.5));
                    level.m_7967_((Entity)itemEntity2);
                    level.m_46717_(pos, (Block)this);
                }
                entity.clear();
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21205_();
        if (stack.m_204117_(ModTags.CUSHIONS) || stack.m_204117_(ModTags.SHEETS) || player.m_6047_()) {
            if (state.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD) {
                return ItemHoldingBlockEntity.placeItem(level, pos.m_121945_(((Direction)state.m_61143_((Property)BedBlock.f_54117_)).m_122424_()), player, ((Item)ModItems.WHITE_CUSHION.get()).m_7968_(), f -> f.m_204117_(ModTags.CUSHIONS), SoundEvents.f_12642_);
            }
            return FancyBedBlock.sheetUse(level, pos, player, ((Item)ModItems.WHITE_SHEET.get()).m_7968_());
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BED_SHAPE, f_54117_, f_49440_, f_49441_});
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (direction == FancyBedBlock.getNeighbourDirection((BedPart)state.m_61143_((Property)f_49440_), (Direction)state.m_61143_((Property)f_54117_))) {
            return neighborState.m_60713_((Block)this) && neighborState.m_61143_((Property)f_49440_) != state.m_61143_((Property)f_49440_) ? (BlockState)((BlockState)state.m_61124_((Property)f_49441_, (Comparable)((Boolean)neighborState.m_61143_((Property)f_49441_)))).m_61124_(BED_SHAPE, (Comparable)((Object)DirectionalBlockSide.getShape((Block)this, (Direction)state.m_61143_((Property)f_54117_), (BlockGetter)level, currentPos))) : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_((BlockState)state.m_61124_(BED_SHAPE, (Comparable)((Object)DirectionalBlockSide.getShape((Block)this, (Direction)state.m_61143_((Property)f_54117_), (BlockGetter)level, currentPos))), direction, neighborState, level, currentPos, neighborPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        BlockPos blockPos = context.m_8083_();
        BlockPos blockPos2 = blockPos.m_121945_(direction);
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_());
        Level level = context.m_43725_();
        return level.m_8055_(blockPos2).m_60629_(context) && level.m_6857_().m_61937_(blockPos2) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction)).m_61124_(BED_SHAPE, (Comparable)((Object)DirectionalBlockSide.getShape((Block)this, (Direction)state.m_61143_((Property)f_54117_), (BlockGetter)context.m_43725_(), blockPos))) : null;
    }

    private static Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    public static InteractionResult sheetUse(Level level, BlockPos pos, Player player, ItemStack defaultSheet) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FancyBedBlockEntity) {
            FancyBedBlockEntity entity = (FancyBedBlockEntity)blockEntity;
            ItemStack stack = player.m_21205_();
            if ((entity.getSheet().m_41619_() || ItemStack.m_41656_((ItemStack)entity.getSheet(), (ItemStack)defaultSheet)) && stack.m_204117_(ModTags.SHEETS)) {
                if (!level.f_46443_) {
                    ItemStack copy = stack.m_41777_();
                    copy.m_41764_(1);
                    entity.setSheet(copy);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.CONSUME;
                }
                player.m_216990_(SoundEvents.f_12642_);
                return InteractionResult.SUCCESS;
            }
            if (player.m_6047_() && !ItemStack.m_41656_((ItemStack)entity.getSheet(), (ItemStack)defaultSheet)) {
                if (!level.f_46443_) {
                    ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, entity.getSheet());
                    entity.setSheet(defaultSheet);
                    itemEntity.m_20256_(itemEntity.m_20184_().m_82490_(0.5));
                    level.m_7967_((Entity)itemEntity);
                    return InteractionResult.CONSUME;
                }
                player.m_216990_(SoundEvents.f_12639_);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.CONSUME_PARTIAL;
    }
}

