/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.block.chair.diningbench;

import earth.terrarium.handcrafted.common.block.SimpleEntityBlock;
import earth.terrarium.handcrafted.common.block.SittableBlock;
import earth.terrarium.handcrafted.common.block.chair.diningbench.DiningBenchBlockEntity;
import earth.terrarium.handcrafted.common.block.property.DirectionalBlockSide;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
public class DiningBenchBlock
extends SimpleEntityBlock
implements SittableBlock {
    public static final EnumProperty<DirectionalBlockSide> DINING_BENCH_SHAPE = EnumProperty.m_61587_((String)"shape", DirectionalBlockSide.class);
    public static final VoxelShape X_AXIS_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)9.0, (double)16.0);
    public static final VoxelShape Z_AXIS_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)9.0, (double)13.0);

    public DiningBenchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(DINING_BENCH_SHAPE, (Comparable)((Object)DirectionalBlockSide.SINGLE))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DiningBenchBlockEntity(pos, state);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? X_AXIS_SHAPE : Z_AXIS_SHAPE;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DINING_BENCH_SHAPE, FACING, WATERLOGGED});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (this.sitOn(level, pos, player, null)) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.CONSUME_PARTIAL;
    }

    @Override
    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return direction.m_122434_().m_122479_() ? (BlockState)state.m_61124_(DINING_BENCH_SHAPE, (Comparable)((Object)DiningBenchBlock.getShape((Block)this, (Direction)state.m_61143_((Property)FACING), (BlockGetter)level, currentPos))) : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(blockPos);
        BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return (BlockState)blockState.m_61124_(DINING_BENCH_SHAPE, (Comparable)((Object)DiningBenchBlock.getShape((Block)this, (Direction)blockState.m_61143_((Property)FACING), (BlockGetter)context.m_43725_(), blockPos)));
    }

    @Override
    public AABB getSeatSize(BlockState state) {
        return new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    }

    public static DirectionalBlockSide getShape(Block block, Direction direction, BlockGetter level, BlockPos pos) {
        boolean check2;
        BlockState blockState3 = level.m_8055_(pos.m_121945_(direction.m_122427_()));
        BlockState blockState4 = level.m_8055_(pos.m_121945_(direction.m_122427_().m_122424_()));
        boolean check1 = blockState3.m_60713_(block) && blockState3.m_61143_((Property)FACING) != direction;
        boolean bl = check2 = blockState4.m_60713_(block) && blockState4.m_61143_((Property)FACING) != direction;
        if (!blockState3.m_60713_(block) && !blockState4.m_60713_(block)) {
            return DirectionalBlockSide.SINGLE;
        }
        if (check1 && blockState4.m_60713_(block)) {
            return DirectionalBlockSide.RIGHT;
        }
        if (check2 && blockState3.m_60713_(block)) {
            return DirectionalBlockSide.LEFT;
        }
        if (check1) {
            return DirectionalBlockSide.SINGLE;
        }
        if (check2) {
            return DirectionalBlockSide.SINGLE;
        }
        if (!blockState3.m_60713_(block)) {
            return DirectionalBlockSide.RIGHT;
        }
        if (!blockState4.m_60713_(block)) {
            return DirectionalBlockSide.LEFT;
        }
        return DirectionalBlockSide.MIDDLE;
    }
}

