/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.nyfsspiders.registration.util;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DatapackRegistryGenerator
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;
    private final Predicate<RegistryDataLoader.RegistryData<?>> predicate;

    public DatapackRegistryGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> lookup, Predicate<RegistryDataLoader.RegistryData<?>> predicate) {
        this.registries = lookup;
        this.output = output;
        this.predicate = predicate;
    }

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        return this.registries.thenCompose(lookup -> {
            RegistryOps ops = RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)lookup);
            return CompletableFuture.allOf((CompletableFuture[])RegistryDataLoader.f_243803_.stream().filter(this.predicate).flatMap(arg_0 -> this.lambda$run$0(output, lookup, (DynamicOps)ops, arg_0)).toArray(CompletableFuture[]::new));
        });
    }

    private <T> Optional<CompletableFuture<?>> dumpRegistryCap(CachedOutput output, HolderLookup.Provider lookup, DynamicOps<JsonElement> ops, RegistryDataLoader.RegistryData<T> data) {
        ResourceKey registryKey = data.f_243794_();
        return lookup.m_254861_(registryKey).map(registry -> {
            PackOutput.PathProvider pathProvider = this.output.m_245269_(PackOutput.Target.DATA_PACK, registryKey.m_135782_().m_135815_());
            return CompletableFuture.allOf((CompletableFuture[])registry.m_214062_().map(value -> DatapackRegistryGenerator.dumpValue(pathProvider.m_245731_(value.m_205785_().m_135782_()), output, ops, data.f_244580_(), value.m_203334_())).toArray(CompletableFuture[]::new));
        });
    }

    private static <E> CompletableFuture<?> dumpValue(Path path, CachedOutput output, DynamicOps<JsonElement> ops, Encoder<E> codec, E value) {
        Optional encoded = codec.encodeStart(ops, value).resultOrPartial(error -> LOGGER.error("Couldn't serialize element {}: {}", (Object)path, error));
        return encoded.isPresent() ? DataProvider.m_253162_((CachedOutput)output, (JsonElement)((JsonElement)encoded.get()), (Path)path) : CompletableFuture.completedFuture(null);
    }

    public String m_6055_() {
        return this.predicate + " registry";
    }

    private /* synthetic */ Stream lambda$run$0(CachedOutput output, HolderLookup.Provider lookup, DynamicOps ops, RegistryDataLoader.RegistryData data) {
        return this.dumpRegistryCap(output, lookup, (DynamicOps<JsonElement>)ops, data).stream();
    }
}

