/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.theurgy;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.theurgy.content.entity.FollowProjectile;
import com.klikli_dev.theurgy.util.EntityUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;

public class TheurgyIntegration {
    public static boolean isLoaded() {
        return ModList.get().isLoaded("theurgy");
    }

    public static void spawnDivinationResultParticle(BlockPos result, Level level, LivingEntity entity) {
        if (TheurgyIntegration.isLoaded()) {
            TheurgyHelper.spawnDivinationResultParticle(result, level, entity);
        } else {
            Occultism.LOGGER.warn("Attempted to spawn Theurgy Divination Result Particle without Theurgy installed");
        }
    }

    public static class TheurgyHelper {
        protected static void spawnDivinationResultParticle(BlockPos result, Level level, LivingEntity entity) {
            Vec3 to;
            float visualizationRange = 10.0f;
            Vec3 from = new Vec3(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_());
            Vec3 resultVec = Vec3.m_82512_((Vec3i)result);
            Vec3 dist = resultVec.m_82546_(from);
            Vec3 dir = dist.m_82541_();
            Vec3 vec3 = to = dist.m_82553_() <= 10.0 ? resultVec : from.m_82549_(dir.m_82490_(10.0));
            if (level.m_46749_(BlockPos.m_274446_((Position)to)) && level.m_46749_(BlockPos.m_274446_((Position)from)) && level.f_46443_) {
                FollowProjectile aoeProjectile = new FollowProjectile(level, from, to, 255, 25, 180, 0.25f);
                EntityUtil.spawnEntityClientSide((Level)level, (Entity)aoeProjectile);
            }
        }
    }
}

