/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.lang.loot;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.block.crops.IReplantableCrops;
import com.klikli_dev.occultism.common.block.otherworld.IOtherworldBlock;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class OccultismBlockLoot
extends BlockLootSubProvider {
    protected static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    protected static final float[] INCREASED_SAPLING_DROP_RATES = new float[]{0.1f, 0.2f, 0.3f, 0.4f};

    public OccultismBlockLoot() {
        super(Set.of(), FeatureFlags.f_244280_.m_247355_());
    }

    public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
        this.m_245660_();
        this.f_244441_.forEach(consumer::accept);
    }

    protected void m_245660_() {
        OccultismBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
            OccultismBlocks.BlockDataGenSettings settings = OccultismBlocks.BLOCK_DATA_GEN_SETTINGS.get(ForgeRegistries.BLOCKS.getKey(block));
            if (settings.lootTableType == OccultismBlocks.LootTableType.EMPTY) {
                this.registerDropNothingLootTable((Block)block);
            } else if (settings.lootTableType == OccultismBlocks.LootTableType.REPLANTABLE_CROP) {
                IReplantableCrops cropsBlock = (IReplantableCrops)block;
                LootItemBlockStatePropertyCondition.Builder lootCondition = LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)CropBlock.f_52244_, 7));
                this.m_247577_((Block)block, this.m_245238_((Block)block, cropsBlock.getCropsItem().m_5456_(), cropsBlock.getSeedsItem().m_5456_(), (LootItemCondition.Builder)lootCondition));
            } else if (settings.lootTableType == OccultismBlocks.LootTableType.DROP_SELF) {
                this.m_245724_((Block)block);
            } else if (settings.lootTableType == OccultismBlocks.LootTableType.OTHERWORLD_BLOCK) {
                this.registerOtherworldBlockTable((Block)block);
            }
        });
        this.m_246481_((Block)OccultismBlocks.OTHERWORLD_LEAVES.get(), block -> this.m_246047_((Block)block, (Block)OccultismBlocks.OTHERWORLD_SAPLING.get(), DEFAULT_SAPLING_DROP_RATES));
        this.m_246481_((Block)OccultismBlocks.OTHERWORLD_LEAVES_NATURAL.get(), block -> this.createOtherworldLeavesDrops((Block)block, Blocks.f_50746_, (Block)OccultismBlocks.OTHERWORLD_SAPLING_NATURAL.get(), INCREASED_SAPLING_DROP_RATES));
        this.m_247577_((Block)OccultismBlocks.SILVER_ORE.get(), this.m_246109_((Block)OccultismBlocks.SILVER_ORE.get(), (Item)OccultismItems.RAW_SILVER.get()));
        this.m_247577_((Block)OccultismBlocks.SILVER_ORE_DEEPSLATE.get(), this.m_246109_((Block)OccultismBlocks.SILVER_ORE_DEEPSLATE.get(), (Item)OccultismItems.RAW_SILVER.get()));
        this.m_247577_((Block)OccultismBlocks.IESNIUM_ORE.get(), this.m_246109_((Block)OccultismBlocks.IESNIUM_ORE.get(), (Item)OccultismItems.RAW_IESNIUM.get()));
    }

    protected void registerOtherworldBlockTable(Block block) {
        if (block instanceof IOtherworldBlock) {
            this.m_247577_(block, this.createOtherworldBlockTable(block));
        } else {
            Occultism.LOGGER.warn("Tried to register otherworld block loot table for non-otherworld block {}", (Object)ForgeRegistries.BLOCKS.getKey((Object)block));
        }
    }

    protected LootTable.Builder createOtherworldBlockTable(Block block) {
        IOtherworldBlock otherworldBlock = (IOtherworldBlock)block;
        return this.createOtherworldBlockTable(block, (ItemLike)otherworldBlock.getCoveredBlock(), (ItemLike)otherworldBlock.getUncoveredBlock());
    }

    protected LootTable.Builder createOtherworldBlockTable(Block block, ItemLike coveredDrop, ItemLike uncoveredDrop) {
        LootItemBlockStatePropertyCondition.Builder uncoveredCondition = LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_(IOtherworldBlock.UNCOVERED, true));
        LootPool.Builder builder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)uncoveredDrop).m_79080_((LootItemCondition.Builder)uncoveredCondition)).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)coveredDrop)));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createOtherworldLeavesDrops(Block leavesBlock, Block coveredSapling, Block uncoveredSapling, float ... chances) {
        LootItemBlockStatePropertyCondition.Builder uncoveredCondition = LootItemBlockStatePropertyCondition.m_81769_((Block)leavesBlock).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_(IOtherworldBlock.UNCOVERED, true));
        AlternativesEntry.Builder saplingLootItem = ((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)uncoveredSapling).m_79080_((LootItemCondition.Builder)uncoveredCondition)).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)coveredSapling));
        return OccultismBlockLoot.m_246160_((Block)leavesBlock, (LootPoolEntryContainer.Builder)((AlternativesEntry.Builder)this.m_247733_((ItemLike)leavesBlock, (ConditionUserBuilder)saplingLootItem)).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])chances))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(f_244248_).m_79076_(((LootPoolSingletonContainer.Builder)this.m_246108_((ItemLike)leavesBlock, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
    }

    public void registerDropNothingLootTable(Block block) {
        this.m_247577_(block, LootTable.m_79147_().m_79161_(LootPool.m_79043_()));
    }
}

