/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.gui.spirit;

import com.klikli_dev.occultism.client.gui.controls.SizedImageButton;
import com.klikli_dev.occultism.client.gui.spirit.SpiritGui;
import com.klikli_dev.occultism.common.container.spirit.SpiritTransporterContainer;
import com.klikli_dev.occultism.network.MessageSetFilterMode;
import com.klikli_dev.occultism.network.MessageSetTagFilterText;
import com.klikli_dev.occultism.network.OccultismPackets;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import org.apache.commons.lang3.StringUtils;

public class SpiritTransporterGui
extends SpiritGui<SpiritTransporterContainer> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("occultism", "textures/gui/inventory_spirit_transporter_tagfilter.png");
    protected static final String TRANSLATION_KEY_BASE = "gui.occultism.spirit.transporter";
    protected final List<Component> tooltip = new ArrayList<Component>();
    protected SpiritTransporterContainer container;
    protected SizedImageButton filterModeButton;
    protected EditBox tagFilterTextField;
    protected String tagFilter;

    public SpiritTransporterGui(SpiritTransporterContainer container, Inventory playerInventory, Component titleIn) {
        super(container, playerInventory, titleIn);
        this.container = container;
        this.f_97726_ = 176;
        this.f_97727_ = 220;
    }

    public boolean isBlacklist() {
        return this.spirit.isFilterBlacklist();
    }

    public String getTagFilterText() {
        return this.tagFilter;
    }

    public void setTagFilterText(String tagFilterText) {
        this.tagFilter = tagFilterText;
    }

    public void setIsBlacklist(boolean isBlacklist) {
        this.spirit.setFilterBlacklist(isBlacklist);
        OccultismPackets.sendToServer(new MessageSetFilterMode(isBlacklist, this.spirit.m_19879_()));
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.setTagFilterText(this.spirit.getTagFilter());
        int isBlacklistButtonTop = 83;
        int isBlacklistButtonLeft = 151;
        int buttonSize = 18;
        int isBlacklistOffset = (this.isBlacklist() ? 0 : 1) * 20;
        this.filterModeButton = new SizedImageButton(this.f_97735_ + isBlacklistButtonLeft, this.f_97736_ + isBlacklistButtonTop, buttonSize, buttonSize, 177, isBlacklistOffset, 20, 20, 20, 256, 256, TEXTURE, button -> {
            this.setIsBlacklist(!this.isBlacklist());
            this.m_7856_();
        });
        this.m_142416_((GuiEventListener)this.filterModeButton);
        int tagFilterLeft = 8;
        int tagFilterTop = 123;
        int tagFilterWidth = 124;
        Objects.requireNonNull(this.f_96547_);
        this.tagFilterTextField = new EditBox(this.f_96547_, this.f_97735_ + tagFilterLeft, this.f_97736_ + tagFilterTop, tagFilterWidth, 9, (Component)Component.m_237113_((String)"forge:ores;*logs*;item:minecraft:chest"));
        this.tagFilterTextField.m_94199_(90);
        this.tagFilterTextField.m_94182_(false);
        this.tagFilterTextField.m_94194_(true);
        this.tagFilterTextField.m_94202_(0xFFFFFF);
        this.tagFilterTextField.m_93692_(false);
        if (!StringUtils.isBlank((CharSequence)this.getTagFilterText())) {
            this.tagFilterTextField.m_94144_(this.getTagFilterText());
        }
        this.m_7787_((GuiEventListener)this.tagFilterTextField);
        this.m_264313_((GuiEventListener)this.tagFilterTextField);
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        guiGraphics.m_280168_().m_85836_();
        int scale = 30;
        SpiritTransporterGui.drawEntityToGui(guiGraphics, this.f_97735_ + 35, this.f_97736_ + 65, scale, this.f_97735_ + 51 - x, this.f_97736_ + 75 - 50 - y, (LivingEntity)this.spirit);
        guiGraphics.m_280168_().m_85849_();
    }

    protected void renderFg(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.tooltip.clear();
        if (this.filterModeButton.m_198029_()) {
            this.tooltip.add((Component)Component.m_237115_((String)"gui.occultism.spirit.transporter.filter_mode"));
            this.tooltip.add((Component)Component.m_237115_((String)("gui.occultism.spirit.transporter.filter_mode." + (this.isBlacklist() ? "blacklist" : "whitelist"))).m_130940_(ChatFormatting.GRAY));
        }
        if (this.isPointInSearchbar(mouseX, mouseY)) {
            this.tooltip.add((Component)Component.m_237115_((String)"gui.occultism.spirit.transporter.tag_filter"));
        }
        if (!this.tooltip.isEmpty()) {
            guiGraphics.m_280677_(this.f_96547_, this.tooltip, Optional.empty(), mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.tagFilterTextField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderFg(guiGraphics, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.isPointInSearchbar(mouseX, mouseY) && mouseButton == 1) {
            this.tagFilterTextField.m_94144_("");
            this.setTagFilterText("");
        }
        if (this.tagFilterTextField.m_6375_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey;
        this.setTagFilterText(this.tagFilterTextField.m_94155_());
        if (this.tagFilterTextField.m_93696_() && this.tagFilterTextField.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.tagFilterTextField.m_93696_() && this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        super.m_7379_();
        this.tagFilterTextField.m_93692_(false);
        this.spirit.setTagFilter(this.tagFilter);
        OccultismPackets.sendToServer(new MessageSetTagFilterText(this.tagFilter, this.spirit.m_19879_()));
    }

    public void m_181908_() {
        this.tagFilterTextField.m_94120_();
        super.m_181908_();
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.tagFilterTextField.m_93696_() && this.tagFilterTextField.m_5534_(codePoint, modifiers)) {
            this.setTagFilterText(this.tagFilterTextField.m_94155_());
        }
        return false;
    }

    protected boolean isPointInSearchbar(double mouseX, double mouseY) {
        int n = this.tagFilterTextField.m_252754_() - this.f_97735_;
        int n2 = this.tagFilterTextField.m_252907_() - this.f_97736_;
        int n3 = this.tagFilterTextField.m_5711_() - 5;
        Objects.requireNonNull(this.f_96547_);
        return this.m_6774_(n, n2, n3, 9 + 6, mouseX, mouseY);
    }
}

