/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.structure.jigsaw;

import com.legacy.structure_gel.api.data_handler.handlers.DataHandler;
import com.legacy.structure_gel.api.structure.jigsaw.ExtendedJigsawStructurePiece;
import com.legacy.structure_gel.api.structure.processor.RemoveGelStructureProcessor;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.structure.GelTemplate;
import com.legacy.structure_gel.core.structure.jigsaw.SinglePoolElementExtension;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.JigsawReplacementProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class GelSinglePoolElement
extends SinglePoolElement {
    public static final Codec<Either<ResourceLocation, StructureTemplate>> POOL_CODEC = Codec.of(GelSinglePoolElement::encodePool, (Decoder)ResourceLocation.f_135803_.map(Either::left));
    public static final Codec<GelSinglePoolElement> CODEC = RecordCodecBuilder.create(instance -> instance.group(GelSinglePoolElement.encodeTemplate(), GelSinglePoolElement.encodeProcessor(), (App)GelSinglePoolElement.m_210538_(), (App)Codec.BOOL.optionalFieldOf("maintainWater", (Object)true).forGetter(element -> element.keepLiquids), (App)Codec.BOOL.optionalFieldOf("ignoreEntities", (Object)false).forGetter(element -> element.ignoreEntities)).apply((Applicative)instance, GelSinglePoolElement::new));
    private boolean keepLiquids = true;
    private boolean ignoreEntities = false;

    private static <T> DataResult<T> encodePool(Either<ResourceLocation, StructureTemplate> locationTemplate, DynamicOps<T> dyn, T data) {
        Optional optional = locationTemplate.left();
        return !optional.isPresent() ? DataResult.error(() -> "Can not serialize a runtime pool element") : ResourceLocation.f_135803_.encode((Object)((ResourceLocation)optional.get()), dyn, data);
    }

    protected static <E extends GelSinglePoolElement> RecordCodecBuilder<E, Holder<StructureProcessorList>> encodeProcessor() {
        return StructureProcessorType.f_74468_.fieldOf("processors").forGetter(piece -> piece.f_210412_);
    }

    protected static <E extends GelSinglePoolElement> RecordCodecBuilder<E, Either<ResourceLocation, StructureTemplate>> encodeTemplate() {
        return POOL_CODEC.fieldOf("location").forGetter(piece -> piece.f_210411_);
    }

    public GelSinglePoolElement(Either<ResourceLocation, StructureTemplate> location, Holder<StructureProcessorList> processors, StructureTemplatePool.Projection projection, boolean keepLiquids, boolean ignoreEntities) {
        super(location, processors, projection);
        this.keepLiquids = keepLiquids;
        this.ignoreEntities = ignoreEntities;
    }

    @Deprecated
    public GelSinglePoolElement maintainWater(boolean keepLiquids) {
        return this.setKeepLiquids(keepLiquids);
    }

    public GelSinglePoolElement setKeepLiquids(boolean keepLiquids) {
        this.keepLiquids = keepLiquids;
        return this;
    }

    public GelSinglePoolElement setIgnoreEntities(boolean ignoreEntities) {
        this.ignoreEntities = ignoreEntities;
        return this;
    }

    protected StructurePlaceSettings m_207169_(Rotation rotation, BoundingBox boundingBox, boolean isLegacy) {
        StructurePlaceSettings placementSettings = new StructurePlaceSettings();
        placementSettings.m_163782_(this.keepLiquids);
        placementSettings.m_74381_(boundingBox);
        placementSettings.m_74379_(rotation);
        placementSettings.m_74402_(true);
        placementSettings.m_74392_(this.ignoreEntities);
        placementSettings.m_74383_((StructureProcessor)RemoveGelStructureProcessor.INSTANCE);
        if (!isLegacy) {
            placementSettings.m_74383_((StructureProcessor)JigsawReplacementProcessor.f_74122_);
        }
        ((StructureProcessorList)this.f_210412_.m_203334_()).m_74425_().forEach(arg_0 -> ((StructurePlaceSettings)placementSettings).m_74383_(arg_0));
        this.m_210539_().m_210609_().forEach(arg_0 -> ((StructurePlaceSettings)placementSettings).m_74383_(arg_0));
        return placementSettings;
    }

    public boolean m_213695_(StructureTemplateManager templateManager, WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGen, BlockPos templatePos, BlockPos jigsawPos, Rotation rotation, BoundingBox bounds, RandomSource rand, boolean isLegacy) {
        SinglePoolElementExtension singlePool;
        GelSinglePoolElement gelSinglePoolElement = this;
        if (gelSinglePoolElement instanceof SinglePoolElementExtension && (gelSinglePoolElement = (singlePool = (SinglePoolElementExtension)((Object)gelSinglePoolElement)).structure_gel$getPiece()) instanceof ExtendedJigsawStructurePiece) {
            ExtendedJigsawStructurePiece extendedJigsawPiece = (ExtendedJigsawStructurePiece)((Object)gelSinglePoolElement);
            return this.place(templateManager, level, structureManager, chunkGen, templatePos, jigsawPos, rotation, bounds, rand, isLegacy, extendedJigsawPiece);
        }
        return super.m_213695_(templateManager, level, structureManager, chunkGen, templatePos, jigsawPos, rotation, bounds, rand, isLegacy);
    }

    public boolean place(StructureTemplateManager templateManager, WorldGenLevel level, StructureManager structureManager, ChunkGenerator chunkGen, BlockPos templatePos, BlockPos jigsawPos, Rotation rotation, BoundingBox bounds, RandomSource rand, boolean isLegacy, ExtendedJigsawStructurePiece extendedJigsawPiece) {
        StructureTemplate template = this.getTemplate(templateManager);
        StructurePlaceSettings placementSettings = this.m_207169_(rotation, bounds, isLegacy);
        if (!GelTemplate.placeInWorld(template, (ServerLevelAccessor)level, templatePos, jigsawPos, placementSettings, rand, 18, extendedJigsawPiece::modifyState)) {
            return false;
        }
        GelSinglePoolElement.processDataHandlers((StructurePiece)extendedJigsawPiece, template, templatePos, jigsawPos, placementSettings, level, rotation, bounds, rand);
        for (StructureTemplate.StructureBlockInfo blockInfo : StructureTemplate.processBlockInfos((ServerLevelAccessor)level, (BlockPos)templatePos, (BlockPos)jigsawPos, (StructurePlaceSettings)placementSettings, (List)this.m_227324_(templateManager, templatePos, rotation, false), (StructureTemplate)template)) {
            this.m_227329_((LevelAccessor)level, blockInfo, templatePos, rotation, rand, bounds);
            if (blockInfo.f_74677_() == null || level.m_8055_(blockInfo.f_74675_()).m_60734_() != Blocks.f_50677_ || StructureMode.valueOf((String)blockInfo.f_74677_().m_128461_("mode")) != StructureMode.DATA) continue;
            extendedJigsawPiece.handleDataMarker(blockInfo.f_74677_().m_128461_("metadata"), blockInfo.f_74675_(), (ServerLevelAccessor)level, rand, bounds);
        }
        return true;
    }

    public static void processDataHandlers(StructurePiece piece, StructureTemplate template, BlockPos templatePos, BlockPos jigsawPos, StructurePlaceSettings placeSettings, WorldGenLevel level, Rotation rotation, BoundingBox bounds, RandomSource rand) {
        for (StructureTemplate.StructureBlockInfo blockInfo : StructureTemplate.processBlockInfos((ServerLevelAccessor)level, (BlockPos)templatePos, (BlockPos)jigsawPos, (StructurePlaceSettings)placeSettings, (List)template.m_230335_(templatePos, new StructurePlaceSettings().m_74379_(rotation), (Block)SGRegistry.Blocks.DATA_HANDLER.get(), false), (StructureTemplate)template)) {
            BlockState state = level.m_8055_(blockInfo.f_74675_());
            if (blockInfo.f_74677_() == null || state.m_60734_() != SGRegistry.Blocks.DATA_HANDLER.get()) continue;
            DataHandler.process(state, blockInfo.f_74677_(), blockInfo.f_74675_(), level, rand, bounds, piece, false);
        }
    }

    public ResourceLocation getLocation() {
        return (ResourceLocation)this.f_210411_.left().get();
    }

    private StructureTemplate getTemplate(StructureTemplateManager templateManager) {
        return (StructureTemplate)this.f_210411_.map(arg_0 -> ((StructureTemplateManager)templateManager).m_230359_(arg_0), Function.identity());
    }

    public StructurePoolElementType<?> m_207234_() {
        return SGRegistry.JigsawDeserializers.GEL_SINGLE_POOL_ELEMENT.get();
    }

    public String toString() {
        return "Gel[" + this.f_210411_ + "]";
    }
}

