/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.mixin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.legacy.structure_gel.api.events.RegisterArmorTrimTexturesEvent;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.client.ClientUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.sources.PalettedPermutations;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class ArmorTrimMixins {

    @Mixin(value={HumanoidArmorLayer.class})
    private static class HumanoidArmorLayerMixin {
        private HumanoidArmorLayerMixin() {
        }

        @ModifyVariable(at=@At(value="HEAD"), ordinal=0, method={"renderTrim(Lnet/minecraft/world/item/ArmorMaterial;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/item/armortrim/ArmorTrim;Lnet/minecraft/client/model/Model;Z)V"}, remap=false)
        private int modifyLightForgeMethod(int original, ArmorMaterial pArmorMaterial, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, ArmorTrim pTrim) {
            int customBlockLight = ClientUtil.getMaterialBrightness(pTrim);
            if (customBlockLight > -1) {
                return LightTexture.m_109885_((int)Math.max(customBlockLight, LightTexture.m_109883_((int)original)), (int)LightTexture.m_109894_((int)original));
            }
            return original;
        }

        @ModifyVariable(at=@At(value="HEAD"), ordinal=0, method={"renderTrim(Lnet/minecraft/world/item/ArmorMaterial;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/world/item/armortrim/ArmorTrim;Lnet/minecraft/client/model/HumanoidModel;Z)V"})
        private int modifyLightVanillaMethod(int original, ArmorMaterial pArmorMaterial, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, ArmorTrim pTrim) {
            int customBlockLight = ClientUtil.getMaterialBrightness(pTrim);
            if (customBlockLight > -1) {
                return LightTexture.m_109885_((int)Math.max(customBlockLight, LightTexture.m_109883_((int)original)), (int)LightTexture.m_109894_((int)original));
            }
            return original;
        }
    }

    @Mixin(value={ArmorTrim.class})
    private static class ArmorTrimMixin {
        private ArmorTrimMixin() {
        }

        @Inject(at={@At(value="HEAD")}, method={"getColorPaletteSuffix"}, cancellable=true)
        private void getCustomPaletteSuffix(ArmorMaterial armorMaterial, CallbackInfoReturnable<String> callback) {
            String override = ClientUtil.getCustomColorPaletteSuffix((ArmorTrim)this, armorMaterial);
            if (override != null) {
                callback.setReturnValue((Object)override);
            }
        }
    }

    @Mixin(value={SpriteResourceLoader.class})
    private static abstract class SpriteResourceLoaderMixin {
        private SpriteResourceLoaderMixin() {
        }

        @Inject(at={@At(value="RETURN")}, method={"load"})
        private static void onLoadReturn(ResourceManager pResourceManager, ResourceLocation atlasLocation, CallbackInfoReturnable<SpriteResourceLoader> callback) {
            try {
                PalettedPermutations permutate;
                SpriteResourceLoader ret;
                RegisterArmorTrimTexturesEvent trimEvent;
                HashMap<Object, Integer> materialLight;
                HashMap<ResourceKey<TrimMaterial>, Map<ArmorMaterial, String>> colorPaletteOverrides;
                HashMap<String, ResourceLocation> trimMaterials;
                HashSet<ResourceLocation> trimPatterns;
                if (atlasLocation.equals((Object)new ResourceLocation("armor_trims"))) {
                    StructureGelMod.LOGGER.debug("Injecting armor trims into texture atlas: " + atlasLocation, new Object[0]);
                    trimPatterns = new HashSet<ResourceLocation>();
                    trimMaterials = new HashMap<String, ResourceLocation>();
                    colorPaletteOverrides = new HashMap<ResourceKey<TrimMaterial>, Map<ArmorMaterial, String>>();
                    materialLight = new HashMap<ResourceKey<TrimMaterial>, Integer>();
                    trimEvent = new RegisterArmorTrimTexturesEvent(trimPatterns, trimMaterials, colorPaletteOverrides, materialLight);
                    ModLoader.get().postEvent((Event)trimEvent);
                    ClientUtil.colorPaletteOverrides = colorPaletteOverrides;
                    ClientUtil.materialLight = materialLight;
                    ret = (SpriteResourceLoader)callback.getReturnValue();
                    for (SpriteSource source : ((SpriteResourceLoaderMixin)ret).getSources()) {
                        if (!(source instanceof PalettedPermutations)) continue;
                        permutate = (PalettedPermutations)source;
                        if (!permutate.f_265884_.equals((Object)new ResourceLocation("trims/color_palettes/trim_palette"))) continue;
                        List<ResourceLocation> patternLocations = Stream.concat(trimPatterns.stream(), trimPatterns.stream().map(rl -> rl.m_266382_("_leggings"))).map(rl -> rl.m_246208_("trims/models/armor/")).toList();
                        permutate.f_265956_ = ImmutableList.builder().addAll((Iterable)permutate.f_265956_).addAll(patternLocations).build();
                        Map<String, ResourceLocation> materialLocations = trimMaterials.entrySet().stream().collect(Collectors.toMap(p -> (String)p.getKey(), p -> ((ResourceLocation)p.getValue()).m_246208_("trims/color_palettes/")));
                        permutate.f_266003_ = ImmutableMap.builder().putAll(permutate.f_266003_).putAll(materialLocations).build();
                    }
                }
                if (atlasLocation.equals((Object)new ResourceLocation("blocks"))) {
                    StructureGelMod.LOGGER.debug("Injecting armor trims into texture atlas: " + atlasLocation, new Object[0]);
                    trimPatterns = new HashSet();
                    trimMaterials = new HashMap();
                    colorPaletteOverrides = new HashMap();
                    materialLight = new HashMap();
                    trimEvent = new RegisterArmorTrimTexturesEvent(trimPatterns, trimMaterials, colorPaletteOverrides, materialLight);
                    ModLoader.get().postEvent((Event)trimEvent);
                    ClientUtil.colorPaletteOverrides = colorPaletteOverrides;
                    ClientUtil.materialLight = materialLight;
                    ret = (SpriteResourceLoader)callback.getReturnValue();
                    for (SpriteSource source : ((SpriteResourceLoaderMixin)ret).getSources()) {
                        if (!(source instanceof PalettedPermutations)) continue;
                        permutate = (PalettedPermutations)source;
                        if (!permutate.f_265884_.equals((Object)new ResourceLocation("trims/color_palettes/trim_palette"))) continue;
                        Map<String, ResourceLocation> materialLocations = trimMaterials.entrySet().stream().collect(Collectors.toMap(p -> (String)p.getKey(), p -> ((ResourceLocation)p.getValue()).m_246208_("trims/color_palettes/")));
                        permutate.f_266003_ = ImmutableMap.builder().putAll(permutate.f_266003_).putAll(materialLocations).build();
                    }
                }
            }
            catch (IllegalAccessError e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                StructureGelMod.LOGGER.error(e, new Object[0]);
                e.printStackTrace();
            }
        }

        @Accessor(value="sources")
        abstract List<SpriteSource> getSources();
    }
}

