/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool.modes;

import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.util.SGText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ReplaceTool
extends BuildingToolMode {
    public ReplaceTool(String name, int modelIndex) {
        super(name, modelIndex);
    }

    @Override
    public void onLeftClick(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
        if (level.f_46443_) {
            return;
        }
        double integrity = BuildingToolItem.getProperty(stack, ToolModeProperty.INTEGRITY);
        int radius = BuildingToolItem.getProperty(stack, ToolModeProperty.MEDIUM_RADIUS);
        Set<BlockPos> poses = ReplaceTool.getReplacePositions(level, clickedPos, radius);
        if (poses.isEmpty()) {
            return;
        }
        RandomSource rand = level.f_46441_;
        ActionHistory.ActionBuilder action = ActionHistory.newAction();
        WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete = BuildingToolItem.getPallete(stack);
        for (BlockPos pos : poses) {
            Optional opState;
            if (!((double)rand.m_188501_() < integrity) || !(opState = pallete.m_216829_(rand)).isPresent()) continue;
            this.setBlock(level, pos, (BlockState)((WeightedEntry.Wrapper)opState.get()).m_146310_(), action);
        }
        ActionHistory.get(player).add(level, action);
        ReplaceTool.sendPlaceMessage(player, ToolModeProperty.Replace.AIR, poses.size(), pallete);
    }

    @Override
    public Object[] getDescArgs() {
        Options options = Minecraft.m_91087_().f_91066_;
        String middleClick = SGText.keybindString(options.f_92097_);
        String leftClick = SGText.keybindString(options.f_92096_);
        return new Object[]{middleClick, leftClick};
    }

    @Override
    public void addProperties(List<ToolModeProperty<?>> properties) {
        super.addProperties(properties);
        properties.add(ToolModeProperty.INTEGRITY);
        properties.add(ToolModeProperty.MEDIUM_RADIUS);
    }

    @Override
    public boolean hasBlockPalette() {
        return true;
    }

    public static Set<BlockPos> getReplacePositions(Level level, BlockPos clickedPos, int radius) {
        BlockState state = level.m_8055_(clickedPos);
        if (state.m_60795_()) {
            return Collections.emptySet();
        }
        Block clickedBlock = state.m_60734_();
        HashSet<BlockPos> allPositions = new HashSet<BlockPos>();
        HashSet<BlockPos> posesToSearch = new HashSet<BlockPos>();
        posesToSearch.add(clickedPos);
        ArrayList<Vec3i> offsets = new ArrayList<Vec3i>(9);
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    offsets.add(new Vec3i(x, y, z));
                }
            }
        }
        while (!posesToSearch.isEmpty()) {
            HashSet<BlockPos> newPoses = new HashSet<BlockPos>();
            for (BlockPos pos : posesToSearch) {
                if (pos.m_123333_((Vec3i)clickedPos) > radius) continue;
                allPositions.add(pos);
                for (Vec3i delta : offsets) {
                    BlockPos offset = pos.m_121955_(delta);
                    if (allPositions.contains(offset) || !level.m_8055_(offset).m_60713_(clickedBlock)) continue;
                    newPoses.add(offset);
                }
            }
            posesToSearch = newPoses;
        }
        return allPositions;
    }
}

