/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool.modes;

import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.util.SGText;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class LineTool
extends BuildingToolMode.ForCorners {
    public LineTool(String name, int modelIndex, boolean resetPosesAfterAction) {
        super(name, modelIndex, resetPosesAfterAction);
    }

    @Override
    public boolean hasAllCorners() {
        return false;
    }

    @Override
    protected void performAction(Level level, Player player, BlockPos clickedPos, ItemStack stack, BlockPos cornerA, BlockPos cornerB) {
        if (level.f_46443_) {
            return;
        }
        WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete = BuildingToolItem.getPallete(stack);
        if (!pallete.m_146337_()) {
            double integrity = BuildingToolItem.getProperty(stack, ToolModeProperty.INTEGRITY);
            ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE);
            BlockState clickedState = level.m_8055_(clickedPos);
            ActionHistory.ActionBuilder action = ActionHistory.newAction();
            RandomSource rand = level.m_213780_();
            Set<BlockPos> poses = LineTool.getLinePositions(cornerA, cornerB);
            int total = 0;
            for (BlockPos pos : poses) {
                Optional opState;
                if (!((double)rand.m_188501_() < integrity) || !replace.shouldReplace(level, clickedState, pos) || !(opState = pallete.m_216829_(rand)).isPresent() || !this.setBlock(level, pos, (BlockState)((WeightedEntry.Wrapper)opState.get()).m_146310_(), action)) continue;
                ++total;
            }
            ActionHistory.get(player).add(level, action);
            LineTool.sendPlaceMessage(player, replace, total, pallete);
        } else {
            BuildingToolMode.sendMessage(player, "info.structure_gel.building_tool.message.missing_state", Style.f_131099_.m_131140_(ChatFormatting.RED), new Object[0]);
        }
    }

    @Override
    public Object[] getDescArgs() {
        Options options = Minecraft.m_91087_().f_91066_;
        String shift = SGText.keybindString(options.f_92090_);
        String middleClick = SGText.keybindString(options.f_92097_);
        String rightClick = SGText.keybindString(options.f_92095_);
        String leftClick = SGText.keybindString(options.f_92096_);
        return new Object[]{middleClick, Component.m_237110_((String)"item.structure_gel.building_tool.mode.select_positions", (Object[])new Object[]{rightClick, shift, rightClick}), leftClick};
    }

    @Override
    public void addProperties(List<ToolModeProperty<?>> properties) {
        super.addProperties(properties);
        properties.add(ToolModeProperty.INTEGRITY);
        properties.add(ToolModeProperty.REPLACE);
    }

    @Override
    public boolean hasBlockPalette() {
        return true;
    }

    @Override
    public Component getHudMessage(ItemStack stack) {
        Optional<BlockPos> p1 = BuildingToolItem.getPos(stack, 0);
        Optional<BlockPos> p2 = BuildingToolItem.getPos(stack, 1);
        if (p1.isPresent() && p2.isPresent()) {
            DecimalFormat format = new DecimalFormat("0.##");
            Double dist = p1.get().m_252807_().m_82554_(p2.get().m_252807_()) + 1.0;
            return Component.m_237110_((String)"info.structure_gel.building_tool.message.length", (Object[])new Object[]{Component.m_237113_((String)format.format(dist)).m_130948_(SGText.VALUE_LABEL_STYLE), Component.m_237113_((String)("" + LineTool.getLinePositions(p1.get(), p2.get()).size())).m_130948_(SGText.VALUE_LABEL_STYLE)});
        }
        return null;
    }

    public static Set<BlockPos> getLinePositions(BlockPos cornerA, BlockPos cornerB) {
        HashSet<BlockPos> poses = new HashSet<BlockPos>();
        double magnitude = Math.sqrt(cornerA.m_123331_((Vec3i)cornerB));
        if (magnitude == 0.0) {
            poses.add(cornerA);
            return poses;
        }
        int x = cornerA.m_123341_();
        int y = cornerA.m_123342_();
        int z = cornerA.m_123343_();
        double dX = (double)(x - cornerB.m_123341_()) / magnitude;
        double dY = (double)(y - cornerB.m_123342_()) / magnitude;
        double dZ = (double)(z - cornerB.m_123343_()) / magnitude;
        BlockPos pos = cornerA;
        int i = 0;
        while (!pos.equals((Object)cornerB) && (double)i < magnitude + 1.0) {
            pos = cornerA.m_7918_((int)(-Math.round(dX * (double)i)), (int)(-Math.round(dY * (double)i)), (int)(-Math.round(dZ * (double)i)));
            ++i;
            poses.add(pos);
        }
        return poses;
    }
}

