/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool.modes;

import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.util.SGText;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ExtendTool
extends BuildingToolMode {
    public ExtendTool(String name, int modelIndex) {
        super(name, modelIndex);
    }

    @Override
    public boolean targetsSpecificPos() {
        return false;
    }

    @Override
    public void onLeftClick(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
        int radius;
        if (level.f_46443_) {
            return;
        }
        ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE_AIR_LIQUID);
        Set<BlockPos> poses = ExtendTool.getExtendPositions(level, clickedPos, clickedFace, replace, radius = BuildingToolItem.getProperty(stack, ToolModeProperty.LARGE_RADIUS).intValue());
        if (poses.isEmpty()) {
            return;
        }
        ActionHistory.ActionBuilder action = ActionHistory.newAction();
        Direction originDir = clickedFace.m_122424_();
        for (BlockPos pos : poses) {
            BlockPos fromPos = pos.m_121945_(originDir);
            BlockEntity blockE = level.m_7702_(fromPos);
            CompoundTag blockEntityNbt = blockE != null ? blockE.m_187482_() : null;
            this.setBlock(level, pos, level.m_8055_(fromPos), blockEntityNbt, action);
        }
        ActionHistory.get(player).add(level, action);
        BuildingToolMode.sendPlaceMessage(player, ToolModeProperty.Replace.ALL, poses.size(), 1, level.m_8055_(clickedPos));
    }

    @Override
    public Object[] getDescArgs() {
        Options options = Minecraft.m_91087_().f_91066_;
        String leftClick = SGText.keybindString(options.f_92096_);
        return new Object[]{leftClick};
    }

    @Override
    public void addProperties(List<ToolModeProperty<?>> properties) {
        properties.add(ToolModeProperty.LARGE_RADIUS);
        properties.add(ToolModeProperty.REPLACE_AIR_LIQUID);
    }

    @Override
    public boolean hasBlockPalette() {
        return false;
    }

    public static Set<BlockPos> getExtendPositions(Level level, BlockPos clickedPos, Direction clickedFace, ToolModeProperty.Replace replace, int radius) {
        BlockState clickedState = level.m_8055_(clickedPos);
        if (clickedState.m_60795_() || !replace.shouldReplace(level, clickedState, clickedPos.m_121945_(clickedFace))) {
            return Collections.emptySet();
        }
        Block clickedBlock = clickedState.m_60734_();
        Direction.Axis axis = clickedFace.m_122434_();
        HashSet<BlockPos> allPositions = new HashSet<BlockPos>();
        HashSet<BlockPos> posesToSearch = new HashSet<BlockPos>();
        posesToSearch.add(clickedPos);
        ArrayList<Vec3i> dirs = new ArrayList<Vec3i>(9);
        for (int a = -1; a <= 1; ++a) {
            for (int b = -1; b <= 1; ++b) {
                Vec3i vec = switch (axis) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction.Axis.X -> new Vec3i(0, a, b);
                    case Direction.Axis.Y -> new Vec3i(a, 0, b);
                    case Direction.Axis.Z -> new Vec3i(a, b, 0);
                };
                dirs.add(vec);
            }
        }
        while (!posesToSearch.isEmpty()) {
            HashSet<BlockPos> newPoses = new HashSet<BlockPos>();
            for (BlockPos pos : posesToSearch) {
                if (pos.m_123333_((Vec3i)clickedPos) > radius) continue;
                allPositions.add(pos);
                for (Vec3i dir : dirs) {
                    BlockState offsetState;
                    BlockPos offset = pos.m_121955_(dir);
                    if (allPositions.contains(offset) || !(offsetState = level.m_8055_(offset)).m_60713_(clickedBlock) || !replace.shouldReplace(level, offsetState, offset.m_121945_(clickedFace))) continue;
                    newPoses.add(offset);
                }
            }
            posesToSearch = newPoses;
        }
        return allPositions.stream().map(p -> p.m_121945_(clickedFace)).collect(Collectors.toSet());
    }
}

