/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class ToolModeProperty<T> {
    public static final String RANGE_KEY = "info.structure_gel.building_tool.property_range";
    private static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat("0.00");
    public static final NumberProp<Integer> REACH_DISTANCE = ToolModeProperty.intProperty("reach_distance", -6, 100, 0);
    public static final NumberProp<Integer> X_SIZE = ToolModeProperty.intProperty("x_size", 1, Integer.MAX_VALUE, 0);
    public static final NumberProp<Integer> Y_SIZE = ToolModeProperty.intProperty("y_size", 1, Integer.MAX_VALUE, 0);
    public static final NumberProp<Integer> Z_SIZE = ToolModeProperty.intProperty("z_size", 1, Integer.MAX_VALUE, 0);
    public static final NumberProp<Integer> WEIGHT = ToolModeProperty.intProperty("weight", 1, 2000, 1);
    public static final NumberProp<Double> INTEGRITY = ToolModeProperty.doubleProperty("integrity", 0.0, 1.0, 1.0);
    public static final NumberProp<Integer> RADIUS = ToolModeProperty.intProperty("radius", 0, 100, 4);
    public static final NumberProp<Integer> MEDIUM_RADIUS = ToolModeProperty.intProperty("radius", 0, 100, 35);
    public static final NumberProp<Integer> LARGE_RADIUS = ToolModeProperty.intProperty("radius", 0, 200, 80);
    public static final NumberProp<Integer> MOVE_DISTANCE = ToolModeProperty.intProperty("move_distance", 1, 100, 1);
    public static final SelectionProp<BooleanProperty> RETAIN_STATE = ToolModeProperty.selectionProperty((String)"retain_state", (StringRepresentable)BooleanProperty.TRUE, (StringRepresentable[])BooleanProperty.VALUES);
    public static final SelectionProp<BooleanProperty> EXTEND_DOWN = ToolModeProperty.selectionProperty((String)"extend_down", (StringRepresentable)BooleanProperty.TRUE, (StringRepresentable[])BooleanProperty.VALUES);
    public static final SelectionProp<Replace> REPLACE = ToolModeProperty.selectionProperty((String)"replace", (StringRepresentable)Replace.ALL, (StringRepresentable[])Replace.values());
    public static final SelectionProp<Replace> REPLACE_ALL_AIR = ToolModeProperty.selectionProperty((String)"replace", (StringRepresentable)Replace.ALL, (StringRepresentable[])new Replace[]{Replace.ALL, Replace.AIR});
    public static final SelectionProp<Replace> REPLACE_AIR_LIQUID = ToolModeProperty.selectionProperty((String)"replace", (StringRepresentable)Replace.AIR_AND_LIQUID, (StringRepresentable[])new Replace[]{Replace.AIR_AND_LIQUID, Replace.AIR});
    public static final SelectionProp<SGRotation> ROTATION = ToolModeProperty.selectionProperty((String)"rotation", (StringRepresentable)SGRotation.R_0, (StringRepresentable[])SGRotation.values());
    public static final SelectionProp<SGMirror> MIRROR = ToolModeProperty.selectionProperty((String)"mirror", (StringRepresentable)SGMirror.NONE, (StringRepresentable[])SGMirror.values());
    public static final SelectionProp<BooleanProperty> CUT_TRUE = ToolModeProperty.selectionProperty((String)"cut", (StringRepresentable)BooleanProperty.TRUE, (StringRepresentable[])BooleanProperty.VALUES);
    public static final SelectionProp<BooleanProperty> CUT_FALSE = ToolModeProperty.selectionProperty((String)"cut", (StringRepresentable)BooleanProperty.FALSE, (StringRepresentable[])BooleanProperty.VALUES);
    public static final SelectionProp<FillMode> FILL_MODE = ToolModeProperty.selectionProperty((String)"fill_mode", (StringRepresentable)FillMode.SOLID, (StringRepresentable[])FillMode.values());
    public static final SelectionProp<Shape> SHAPE = ToolModeProperty.selectionProperty((String)"shape", (StringRepresentable)Shape.SPHERE, (StringRepresentable[])Shape.values());
    private final String key;
    protected final Function<String, T> readFunc;
    protected final Function<T, String> writeFunc;
    protected final Predicate<T> valueTest;
    protected final Supplier<T> defaultVal;
    private final Component nameComponent;
    private final String descKey;

    public ToolModeProperty(String key, Function<String, T> readFunc, Function<T, String> writeFunc, Predicate<T> valueTest, Supplier<T> defaultVal) {
        this.key = key;
        this.readFunc = readFunc;
        this.writeFunc = writeFunc;
        this.valueTest = valueTest;
        this.defaultVal = defaultVal;
        this.nameComponent = Component.m_237115_((String)("info.structure_gel.building_tool.property." + key));
        this.descKey = "info.structure_gel.building_tool.property." + key + ".description";
    }

    public static NumberProp<Double> doubleProperty(String key, double min, double max, double defaultVal) {
        return new NumberProp<Double>(key, Double.class, Double::valueOf, DOUBLE_FORMAT::format, min, max, () -> defaultVal);
    }

    public static NumberProp<Integer> intProperty(String key, int min, int max, int defaultVal) {
        return new NumberProp<Integer>(key, Integer.class, Integer::valueOf, i -> Integer.toString(i), min, max, () -> defaultVal);
    }

    @SafeVarargs
    public static <E extends StringRepresentable> SelectionProp<E> selectionProperty(String key, E defaultValue, E ... values) {
        if (values.length < 1) {
            throw new IllegalArgumentException("Cannot create a ToolModeProperty for an enum without any values. Key = " + key);
        }
        HashMap<String, E> nameMap = new HashMap<String, E>();
        for (E e : values) {
            nameMap.put(e.m_7912_(), e);
        }
        return new SelectionProp<StringRepresentable>(key, nameMap::get, StringRepresentable::m_7912_, nameMap::containsValue, () -> defaultValue, List.of(values));
    }

    public String getKey() {
        return this.key;
    }

    public T getDefaultValue() {
        return this.defaultVal.get();
    }

    public T read(String input) {
        try {
            T val = this.readFunc.apply(input);
            if (val != null && this.isValid(val)) {
                return val;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.defaultVal.get();
    }

    public boolean canRead(String input) {
        try {
            T val = this.readFunc.apply(input);
            return val != null && this.isValid(val);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String write(T input) {
        return this.writeFunc.apply(input);
    }

    public boolean isValid(T value) {
        return this.valueTest.test(value);
    }

    public Component getNameComponent() {
        return this.nameComponent;
    }

    public String getDescKey() {
        return this.descKey;
    }

    public Component getValueComponent(@Nullable T value) {
        return Component.m_237113_((String)(value == null ? "null" : value.toString()));
    }

    public static class NumberProp<T extends Number>
    extends ToolModeProperty<T> {
        private final T min;
        private final T max;
        private final Class<T> numClass;

        public NumberProp(String key, Class<T> numClass, Function<String, T> readFunc, Function<T, String> writeFunc, T min, T max, Supplier<T> defaultVal) {
            super(key, readFunc, writeFunc, n -> n.doubleValue() >= min.doubleValue() && n.doubleValue() <= max.doubleValue(), defaultVal);
            this.min = min;
            this.max = max;
            this.numClass = numClass;
        }

        public T min() {
            return this.min;
        }

        public T max() {
            return this.max;
        }

        public T clamp(T val) {
            if (((Number)val).doubleValue() < ((Number)this.min).doubleValue()) {
                return this.min;
            }
            if (((Number)val).doubleValue() > ((Number)this.max).doubleValue()) {
                return this.max;
            }
            return val;
        }

        @Override
        public T read(String input) {
            try {
                Number ret = (Number)this.readFunc.apply(input);
                if (ret != null) {
                    double d = ret.doubleValue();
                    if (d < ((Number)this.min).doubleValue()) {
                        return this.min;
                    }
                    if (d > ((Number)this.max).doubleValue()) {
                        return this.max;
                    }
                    return (T)ret;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return (T)((Number)this.defaultVal.get());
        }

        public Class<T> getNumberClass() {
            return this.numClass;
        }
    }

    public static class SelectionProp<T extends StringRepresentable>
    extends ToolModeProperty<T> {
        private final List<T> allValues;
        private final Function<T, Component> valueComponents = Util.m_143827_(t -> Component.m_237115_((String)("info.structure_gel.building_tool.property." + this.getKey() + ".value." + t.m_7912_())));

        private SelectionProp(String key, Function<String, T> readFunc, Function<T, String> writeFunc, Predicate<T> valueTest, Supplier<T> defaultVal, List<T> allValues) {
            super(key, readFunc, writeFunc, valueTest, defaultVal);
            this.allValues = List.copyOf(allValues);
        }

        public List<T> getAllValues() {
            return this.allValues;
        }

        @Override
        public Component getValueComponent(@Nullable T value) {
            if (value == null) {
                return Component.m_237113_((String)"null");
            }
            return this.valueComponents.apply(value);
        }
    }

    public record BooleanProperty(boolean value, String key) implements StringRepresentable
    {
        private static final BooleanProperty TRUE = new BooleanProperty(true, "true");
        private static final BooleanProperty FALSE = new BooleanProperty(false, "false");
        private static final BooleanProperty[] VALUES = new BooleanProperty[]{TRUE, FALSE};

        public String m_7912_() {
            return this.key;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Replace implements StringRepresentable
    {
        ALL("all", true){

            @Override
            public boolean shouldReplace(Level level, BlockState clickedState, BlockPos pos) {
                return true;
            }
        }
        ,
        AIR("air", false){

            @Override
            public boolean shouldReplace(Level level, BlockState clickedState, BlockPos pos) {
                return level.m_8055_(pos).m_60795_();
            }
        }
        ,
        CLICKED_BLOCK("clicked_block", false){

            @Override
            public boolean shouldReplace(Level level, BlockState clickedState, BlockPos pos) {
                return !clickedState.m_60795_() && level.m_8055_(pos).m_60713_(clickedState.m_60734_());
            }
        }
        ,
        AIR_AND_LIQUID("air_and_liquid", false){

            @Override
            public boolean shouldReplace(Level level, BlockState clickedState, BlockPos pos) {
                BlockState state = level.m_8055_(pos);
                return state.m_60795_() || state.m_278721_();
            }
        };

        private final String key;
        public final boolean usePlaceMessage;

        private Replace(String key, boolean usePlaceMessage) {
            this.key = key;
            this.usePlaceMessage = usePlaceMessage;
        }

        public abstract boolean shouldReplace(Level var1, BlockState var2, BlockPos var3);

        public String m_7912_() {
            return this.key;
        }
    }

    public static enum SGRotation implements StringRepresentable
    {
        R_0("r_0", r -> Rotation.NONE),
        R_90("r_90", r -> Rotation.CLOCKWISE_90),
        R_180("r_180", r -> Rotation.CLOCKWISE_180),
        R_270("r_270", r -> Rotation.COUNTERCLOCKWISE_90),
        RANDOM("random", r -> (Rotation)Util.m_214670_((Object[])Rotation.values(), (RandomSource)r));

        private final String key;
        private final Function<RandomSource, Rotation> vanilla;

        private SGRotation(String key, Function<RandomSource, Rotation> vanilla) {
            this.key = key;
            this.vanilla = vanilla;
        }

        public String m_7912_() {
            return this.key;
        }

        public Rotation toVanilla(RandomSource rand) {
            return this.vanilla.apply(rand);
        }
    }

    public static enum SGMirror implements StringRepresentable
    {
        NONE("none", r -> Mirror.NONE),
        Z("z", r -> Mirror.FRONT_BACK),
        X("x", r -> Mirror.LEFT_RIGHT),
        RANDOM("random", r -> (Mirror)Util.m_214670_((Object[])Mirror.values(), (RandomSource)r));

        private final String key;
        private final Function<RandomSource, Mirror> vanilla;

        private SGMirror(String key, Function<RandomSource, Mirror> vanilla) {
            this.key = key;
            this.vanilla = vanilla;
        }

        public String m_7912_() {
            return this.key;
        }

        public Mirror toVanilla(RandomSource rand) {
            return this.vanilla.apply(rand);
        }
    }

    public static enum FillMode implements StringRepresentable
    {
        SOLID("solid"),
        HOLLOW("hollow"),
        FRAME("frame");

        private final String key;

        private FillMode(String key) {
            this.key = key;
        }

        public String m_7912_() {
            return this.key;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Shape implements StringRepresentable
    {
        CUBE("cube"){

            @Override
            public boolean isInside(Vec3i vec, int radius) {
                int x = vec.m_123341_();
                int y = vec.m_123342_();
                int z = vec.m_123343_();
                return x >= -radius && x <= radius && y >= -radius && y <= radius && z >= -radius && z <= radius;
            }
        }
        ,
        SPHERE("sphere"){

            @Override
            public boolean isInside(Vec3i vec, int radius) {
                int x = vec.m_123341_();
                int y = vec.m_123342_();
                int z = vec.m_123343_();
                double r = (double)radius + 0.5;
                return CUBE.isInside(vec, radius) && (double)(x * x + y * y + z * z) <= r * r;
            }
        }
        ,
        DIAMOND("diamond"){

            @Override
            public boolean isInside(Vec3i vec, int radius) {
                return CUBE.isInside(vec, radius) && Math.abs(vec.m_123341_()) + Math.abs(vec.m_123342_()) + Math.abs(vec.m_123343_()) <= radius;
            }
        }
        ,
        CYLINDER("cylinder"){

            @Override
            public boolean isInside(Vec3i vec, int radius) {
                int x = vec.m_123341_();
                int z = vec.m_123343_();
                double r = radius > 1 ? (double)radius + 0.5 : (double)radius;
                return CUBE.isInside(vec, radius) && (double)(x * x + z * z) <= r * r;
            }
        };

        private final String key;

        private Shape(String key) {
            this.key = key;
        }

        public String m_7912_() {
            return this.key;
        }

        public abstract boolean isInside(Vec3i var1, int var2);
    }
}

