/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.widget;

import com.legacy.structure_gel.core.client.screen.building_tool.BuildingToolScreen;
import com.legacy.structure_gel.core.client.widget.TooltipImageButton;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import java.util.List;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public class PropertyImageButton<T extends StringRepresentable>
extends TooltipImageButton {
    private final Component name;
    private final ToolModeProperty.SelectionProp<T> property;
    private T currentValue;
    private final Function<T, Component> textCache;

    public PropertyImageButton(int x, int y, OnPress<PropertyImageButton<T>> onPress, Component name, ToolModeProperty.SelectionProp<T> property, T currentVal) {
        this(x, y, BuildingToolScreen.WIDGETS, 256, 256, onPress, name, property, currentVal);
    }

    public PropertyImageButton(int x, int y, ResourceLocation texture, int texWidth, int texHeight, OnPress<PropertyImageButton<T>> onPress, Component name, ToolModeProperty.SelectionProp<T> property, T currentVal) {
        super(x, y, 100, 24, 50, 0, 24, texture, texWidth, texHeight, b -> {
            if (b instanceof PropertyImageButton) {
                onPress.onPress((PropertyImageButton)b);
            }
        }, property.getNameComponent());
        this.name = name;
        this.property = property;
        this.currentValue = currentVal;
        this.textCache = Util.m_143827_(v -> Component.m_237113_((String)(this.name.getString() + ": " + this.property.getValueComponent((StringRepresentable)v).getString())));
    }

    @Override
    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_87963_(graphics, mouseX, mouseY, partialTick);
        Minecraft mc = Minecraft.m_91087_();
        graphics.m_280430_(mc.f_91062_, this.textCache.apply(this.currentValue), this.m_252754_() + 4, this.m_252907_() + 8, this.m_198029_() ? 0xFFFFFF : 0xCDCDCD);
    }

    public void cycleValue(boolean forward) {
        List<T> vals = this.property.getAllValues();
        int index = vals.indexOf(this.currentValue);
        index = forward ? --index : ++index;
        int size = vals.size();
        if (index >= size) {
            index = 0;
        }
        if (index < 0) {
            index = size - 1;
        }
        this.currentValue = (StringRepresentable)vals.get(index);
    }

    @Override
    public void m_5691_() {
        this.cycleValue(Screen.m_96638_());
        super.m_5691_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (this.m_198029_()) {
            boolean up = scroll > 0.0;
            this.cycleValue(!up);
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            super.m_5691_();
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    public ToolModeProperty.SelectionProp<T> getProperty() {
        return this.property;
    }

    public T getSelectedValue() {
        return this.currentValue;
    }

    public static interface OnPress<T extends PropertyImageButton<?>> {
        public void onPress(T var1);
    }
}

