/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.screen.building_tool;

import com.legacy.structure_gel.core.client.ClientProxy;
import com.legacy.structure_gel.core.client.screen.building_tool.BuildingToolScreen;
import com.legacy.structure_gel.core.client.widget.PropertyEditBox;
import com.legacy.structure_gel.core.client.widget.TooltipImageButton;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.SmartBoundingBox;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.util.SGText;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class EditSelectionScreen
extends Screen {
    protected static final Component CLEAR_SELECTION_TEXT = Component.m_237115_((String)"info.structure_gel.building_tool.clear_selection");
    protected static final String CLEAR_SELECTION_DESC = "info.structure_gel.building_tool.clear_selection.description";
    protected static final String EXPAND_FACING_DESC = "info.structure_gel.building_tool.expand_facing.description";
    protected static final String EXPAND_TEXT = "info.structure_gel.building_tool.expand";
    protected static final String EXPAND_DESC = "info.structure_gel.building_tool.expand.description";
    protected static final String SHRINK_TEXT = "info.structure_gel.building_tool.shrink";
    protected static final String SHRINK_DESC = "info.structure_gel.building_tool.shrink.description";
    protected static final Component FACING = Component.m_237115_((String)"info.structure_gel.building_tool.facing");
    protected static final Component FRONT = Component.m_237115_((String)"info.structure_gel.building_tool.front");
    protected static final Component BACK = Component.m_237115_((String)"info.structure_gel.building_tool.back");
    protected static final Component LEFT = Component.m_237115_((String)"info.structure_gel.building_tool.left");
    protected static final Component RIGHT = Component.m_237115_((String)"info.structure_gel.building_tool.right");
    protected static final Component TOP = Component.m_237115_((String)"info.structure_gel.building_tool.top");
    protected static final Component BOTTOM = Component.m_237115_((String)"info.structure_gel.building_tool.bottom");
    private final BuildingToolScreen parent;
    protected final List<Renderable> widgetsToRender = new ArrayList<Renderable>(2);
    private SmartBoundingBox bounds;
    private Vec3i negativePos;
    private Vec3i positivePos;
    private PropertyEditBox<Integer> xEditBox;
    private PropertyEditBox<Integer> yEditBox;
    private PropertyEditBox<Integer> zEditBox;
    private Optional<BuildingToolScreen.DescriptionRenderer> descriptionRenderer = Optional.empty();

    public EditSelectionScreen(BuildingToolScreen parent) {
        super((Component)Component.m_237119_());
        this.parent = parent;
        Optional<BlockPos> posA = BuildingToolItem.getPos(this.parent.stack, 0);
        Optional<BlockPos> posB = BuildingToolItem.getPos(this.parent.stack, 1);
        if (posA.isPresent() && posB.isPresent()) {
            this.bounds = SmartBoundingBox.fromCorners((Vec3i)posA.get(), (Vec3i)posB.get());
        } else if (posA.isPresent() && posB.isEmpty()) {
            this.bounds = SmartBoundingBox.fromCorners((Vec3i)posA.get(), (Vec3i)posA.get());
        } else if (posA.isEmpty() && posB.isPresent()) {
            this.bounds = SmartBoundingBox.fromCorners((Vec3i)posB.get(), (Vec3i)posB.get());
        } else {
            BlockPos playerPos = Minecraft.m_91087_().f_91074_.m_20183_();
            this.bounds = SmartBoundingBox.fromCorners((Vec3i)playerPos, (Vec3i)playerPos);
        }
        this.negativePos = this.bounds.getMin();
        this.positivePos = this.bounds.getMax();
    }

    protected void m_7856_() {
        this.widgetsToRender.clear();
        int texSize = 256;
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int texX = centerX - 100;
        int texY = centerY - 100;
        int circleWidth = 40;
        int w = 16;
        String shiftKey = SGText.keybindString(this.f_96541_.f_91066_.f_92090_);
        this.widgetsToRender.add((Renderable)this.m_7787_((GuiEventListener)new TooltipImageButton(texX + 21, texY + 21, circleWidth, circleWidth, 112, 112, circleWidth, BuildingToolScreen.WIDGETS, texSize, texSize, b -> this.back()).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription(BuildingToolScreen.GO_BACK_TEXT, "info.structure_gel.building_tool.go_back.description", SGText.keybindString(this.f_96541_.f_91066_.f_92094_)))));
        this.widgetsToRender.add((Renderable)this.m_7787_((GuiEventListener)new TooltipImageButton(texX + 21, texY + 139, circleWidth, circleWidth, 72, 112, circleWidth, BuildingToolScreen.WIDGETS, texSize, texSize, b -> this.clearSelection()).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription(CLEAR_SELECTION_TEXT, CLEAR_SELECTION_DESC, new Object[0]))));
        this.widgetsToRender.add((Renderable)this.m_7787_((GuiEventListener)new TooltipImageButton(texX + 80, texY + 80, circleWidth, circleWidth, 32, 112, circleWidth, BuildingToolScreen.WIDGETS, texSize, texSize, b -> this.expandFacing()).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription(this.component(EXPAND_TEXT, FACING), EXPAND_FACING_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.m_7787_((GuiEventListener)new TooltipImageButton(texX + 92, texY + 14, w, w, 0, 112, w, BuildingToolScreen.WIDGETS, texSize, texSize, b -> this.expand(Direction.NORTH)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription(this.component(EXPAND_TEXT, FRONT), EXPAND_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.m_7787_((GuiEventListener)new TooltipImageButton(texX + 92, texY + 34, w, w, 0 + w, 112, w, BuildingToolScreen.WIDGETS, texSize, texSize, b -> this.shrink(Direction.NORTH)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription(this.component(SHRINK_TEXT, FRONT), SHRINK_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.m_7787_((GuiEventListener)new TooltipImageButton(texX + 92, texY + 171, w, w, 0, 112, w, BuildingToolScreen.WIDGETS, texSize, texSize, b -> this.expand(Direction.SOUTH)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription(this.component(EXPAND_TEXT, BACK), EXPAND_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.m_7787_((GuiEventListener)new TooltipImageButton(texX + 92, texY + 150, w, w, 0 + w, 112, w, BuildingToolScreen.WIDGETS, texSize, texSize, b -> this.shrink(Direction.SOUTH)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription(this.component(SHRINK_TEXT, BACK), SHRINK_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.m_7787_((GuiEventListener)new TooltipImageButton(texX + 171, texY + 92, w, w, 0, 112, w, BuildingToolScreen.WIDGETS, texSize, texSize, b -> this.expand(Direction.EAST)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription(this.component(EXPAND_TEXT, RIGHT), EXPAND_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.m_7787_((GuiEventListener)new TooltipImageButton(texX + 150, texY + 92, w, w, 0 + w, 112, w, BuildingToolScreen.WIDGETS, texSize, texSize, b -> this.shrink(Direction.EAST)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription(this.component(SHRINK_TEXT, RIGHT), SHRINK_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.m_7787_((GuiEventListener)new TooltipImageButton(texX + 13, texY + 92, w, w, 0, 112, w, BuildingToolScreen.WIDGETS, texSize, texSize, b -> this.expand(Direction.WEST)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription(this.component(EXPAND_TEXT, LEFT), EXPAND_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.m_7787_((GuiEventListener)new TooltipImageButton(texX + 34, texY + 92, w, w, 0 + w, 112, w, BuildingToolScreen.WIDGETS, texSize, texSize, b -> this.shrink(Direction.WEST)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription(this.component(SHRINK_TEXT, LEFT), SHRINK_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.m_7787_((GuiEventListener)new TooltipImageButton(texX + 151, texY + 136, w, w, 0, 112, w, BuildingToolScreen.WIDGETS, texSize, texSize, b -> this.expand(Direction.UP)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription(this.component(EXPAND_TEXT, TOP), EXPAND_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.m_7787_((GuiEventListener)new TooltipImageButton(texX + 171, texY + 136, w, w, 0 + w, 112, w, BuildingToolScreen.WIDGETS, texSize, texSize, b -> this.shrink(Direction.UP)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription(this.component(SHRINK_TEXT, TOP), SHRINK_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.m_7787_((GuiEventListener)new TooltipImageButton(texX + 151, texY + 180, w, w, 0, 112, w, BuildingToolScreen.WIDGETS, texSize, texSize, b -> this.expand(Direction.DOWN)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription(this.component(EXPAND_TEXT, BOTTOM), EXPAND_DESC, shiftKey))));
        this.widgetsToRender.add((Renderable)this.m_7787_((GuiEventListener)new TooltipImageButton(texX + 171, texY + 180, w, w, 0 + w, 112, w, BuildingToolScreen.WIDGETS, texSize, texSize, b -> this.shrink(Direction.DOWN)).onTooltip((button, poseStack, mouseX, mouseY) -> this.renderDescription(this.component(SHRINK_TEXT, BOTTOM), SHRINK_DESC, shiftKey))));
        int leftPropY = 60;
        ToolModeProperty.NumberProp<Integer> xProp = ToolModeProperty.X_SIZE;
        this.xEditBox = new PropertyEditBox<Integer>(this.f_96541_.f_91062_, centerX - 210, centerY - leftPropY, xProp, 0);
        this.xEditBox.setValue(this.bounds.getXSpan());
        this.xEditBox.m_94151_(s -> {
            if (xProp.canRead((String)s)) {
                this.positivePos = new Vec3i(this.negativePos.m_123341_() + (Integer)xProp.read((String)s) - 1, this.positivePos.m_123342_(), this.positivePos.m_123343_());
                this.updateBounds(false);
            }
        });
        this.widgetsToRender.add((Renderable)this.m_7787_((GuiEventListener)this.xEditBox));
        ToolModeProperty.NumberProp<Integer> yProp = ToolModeProperty.Y_SIZE;
        this.yEditBox = new PropertyEditBox<Integer>(this.f_96541_.f_91062_, centerX - 210, centerY - (leftPropY -= 30), yProp, 0);
        this.yEditBox.setValue(this.bounds.getYSpan());
        this.yEditBox.m_94151_(s -> {
            if (yProp.canRead((String)s)) {
                this.positivePos = new Vec3i(this.positivePos.m_123341_(), this.negativePos.m_123342_() + (Integer)yProp.read((String)s) - 1, this.positivePos.m_123343_());
                this.updateBounds(false);
            }
        });
        this.widgetsToRender.add((Renderable)this.m_7787_((GuiEventListener)this.yEditBox));
        ToolModeProperty.NumberProp<Integer> zProp = ToolModeProperty.Z_SIZE;
        this.zEditBox = new PropertyEditBox<Integer>(this.f_96541_.f_91062_, centerX - 210, centerY - (leftPropY -= 30), zProp, 0);
        this.zEditBox.setValue(this.bounds.getZSpan());
        this.zEditBox.m_94151_(s -> {
            if (zProp.canRead((String)s)) {
                this.positivePos = new Vec3i(this.positivePos.m_123341_(), this.positivePos.m_123342_(), this.negativePos.m_123343_() + (Integer)zProp.read((String)s) - 1);
                this.updateBounds(false);
            }
        });
        this.widgetsToRender.add((Renderable)this.m_7787_((GuiEventListener)this.zEditBox));
        leftPropY -= 30;
    }

    private Component component(String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])args);
    }

    private void expand(Direction direction) {
        if ((direction = this.rotatedByPlayer(direction)).m_122421_() == Direction.AxisDirection.POSITIVE) {
            this.positivePos = this.positivePos.m_121955_(direction.m_122436_());
        } else {
            this.negativePos = this.negativePos.m_121955_(direction.m_122436_());
        }
        if (Screen.m_96638_()) {
            Direction opposite = direction.m_122424_();
            if (opposite.m_122421_() == Direction.AxisDirection.POSITIVE) {
                this.positivePos = this.positivePos.m_121996_(opposite.m_122436_());
            } else {
                this.negativePos = this.negativePos.m_121996_(opposite.m_122436_());
            }
        }
        this.updateBounds(true);
    }

    private void shrink(Direction direction) {
        if ((direction = this.rotatedByPlayer(direction)).m_122421_() == Direction.AxisDirection.POSITIVE) {
            this.positivePos = this.positivePos.m_121996_(direction.m_122436_());
        } else {
            this.negativePos = this.negativePos.m_121996_(direction.m_122436_());
        }
        if (Screen.m_96638_()) {
            Direction opposite = direction.m_122424_();
            if (opposite.m_122421_() == Direction.AxisDirection.POSITIVE) {
                this.positivePos = this.positivePos.m_121955_(opposite.m_122436_());
            } else {
                this.negativePos = this.negativePos.m_121955_(opposite.m_122436_());
            }
        }
        this.updateBounds(true);
    }

    private Direction rotatedByPlayer(Direction direction) {
        if (direction.m_122434_() != Direction.Axis.Y) {
            Direction facingDir = this.f_96541_.f_91074_.m_6350_();
            return Direction.m_122407_((int)((direction.m_122416_() + facingDir.m_122416_()) % 4)).m_122424_();
        }
        return direction;
    }

    private void expandFacing() {
        Direction direction = Direction.m_122382_((Entity)this.f_96541_.f_91074_)[0];
        if (direction.m_122421_() == Direction.AxisDirection.POSITIVE) {
            this.positivePos = this.positivePos.m_121955_(direction.m_122436_());
        } else {
            this.negativePos = this.negativePos.m_121955_(direction.m_122436_());
        }
        if (Screen.m_96638_()) {
            Direction opposite = direction.m_122424_();
            if (opposite.m_122421_() == Direction.AxisDirection.POSITIVE) {
                this.positivePos = this.positivePos.m_121996_(opposite.m_122436_());
            } else {
                this.negativePos = this.negativePos.m_121996_(opposite.m_122436_());
            }
        }
        this.updateBounds(true);
    }

    private void clearSelection() {
        this.parent.clearPoses = true;
        this.close();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        Component component;
        this.parent.renderGrayBackground(graphics, this.f_96543_, this.f_96544_);
        int arrowW = 54;
        int arrowH = 72;
        int topBottomW = 51;
        int topBottomH = 33;
        this.drawHoverable(graphics, mouseX, mouseY, 73, 0, arrowW, arrowH);
        this.drawHoverable(graphics, mouseX, mouseY, 73, 128, arrowW, arrowH);
        this.drawHoverable(graphics, mouseX, mouseY, 0, 73, arrowH, arrowW);
        this.drawHoverable(graphics, mouseX, mouseY, 128, 73, arrowH, arrowW);
        this.drawHoverable(graphics, mouseX, mouseY, 143, 132, topBottomW, topBottomH);
        this.drawHoverable(graphics, mouseX, mouseY, 143, 167, topBottomW, topBottomH);
        this.widgetsToRender.forEach(w -> {
            w.m_88315_(graphics, mouseX, mouseY, partialTick);
            RenderSystem.enableBlend();
        });
        if (this.descriptionRenderer.isPresent()) {
            this.descriptionRenderer.get().render(graphics, mouseX);
            this.descriptionRenderer = Optional.empty();
        }
        if ((component = this.parent.mode.getHudMessage(this.parent.stack)) != null) {
            int length = this.f_96547_.m_92852_((FormattedText)component);
            graphics.m_280430_(this.f_96547_, component, this.f_96543_ / 2 - length / 2, this.f_96544_ / 2 - 112, 0xE0E0E0);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    private void drawHoverable(GuiGraphics graphics, int mouseX, int mouseY, int u, int v, int width, int height) {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int texX = centerX - 100;
        int texY = centerY - 100;
        ResourceLocation texture = mouseX >= texX + u && mouseX <= texX + u + width && mouseY >= texY + v && mouseY <= texY + v + height ? BuildingToolScreen.ARROWS_SELECTED : BuildingToolScreen.ARROWS;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        graphics.m_280218_(texture, texX + u, texY + v, u, v, width, height);
    }

    public boolean m_6375_(double mouseX, double mouseY, int clickType) {
        return super.m_6375_(mouseX, mouseY, clickType);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key key = InputConstants.Type.KEYSYM.m_84895_(keyCode);
        int escape = 256;
        int backspace = 259;
        boolean pressedEnter = keyCode == 257 || keyCode == 335;
        boolean consumed = super.m_7933_(keyCode, scanCode, modifiers);
        if (!consumed && (backspace == keyCode || this.f_96541_.f_91066_.f_92094_.isActiveAndMatches(key))) {
            this.back();
            BuildingToolScreen.playClickSound();
            return true;
        }
        if (escape == keyCode || this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(key) || ((KeyMapping)ClientProxy.BUILDING_TOOL_KEY.get()).isActiveAndMatches(key) || pressedEnter) {
            this.close();
            return true;
        }
        return consumed;
    }

    private void renderDescription(Component title, String descriptionKey, Object ... descriptionArgs) {
        this.renderDescription(title, List.of(Pair.of((Object)descriptionKey, (Object)descriptionArgs)));
    }

    private void renderDescription(Component title, List<Pair<String, Object[]>> descriptionKeys) {
        this.descriptionRenderer = Optional.of(new BuildingToolScreen.DescriptionRenderer(this, title, descriptionKeys));
    }

    public void close() {
        this.m_7379_();
        this.parent.m_7379_();
        BuildingToolScreen.lastScreenState = 1;
        this.f_96541_.m_91152_(null);
    }

    public void back() {
        this.m_7379_();
        BuildingToolScreen.lastScreenState = 0;
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    public void m_7379_() {
        SmartBoundingBox bb = this.updateBounds(false);
        if (this.parent.selectedPosA.isPresent() && this.parent.selectedPosB.isPresent() && !SmartBoundingBox.fromCorners((Vec3i)this.parent.selectedPosA.get(), (Vec3i)this.parent.selectedPosB.get()).equals(bb)) {
            this.parent.usedEditSelectionScreen = true;
        }
        this.parent.selectedPosA = Optional.of(new BlockPos(bb.getPosA()));
        this.parent.selectedPosB = Optional.of(new BlockPos(bb.getPosB()));
    }

    public SmartBoundingBox updateBounds(boolean updateEditBox) {
        ItemStack tool;
        SmartBoundingBox bb = SmartBoundingBox.from(this.bounds);
        bb.setMin(this.negativePos);
        bb.setMax(this.positivePos);
        if (updateEditBox) {
            this.xEditBox.setValue(bb.getXSpan());
            this.yEditBox.setValue(bb.getYSpan());
            this.zEditBox.setValue(bb.getZSpan());
        }
        if ((tool = this.f_96541_.f_91074_.m_21120_(this.parent.hand)).m_150930_((Item)SGRegistry.Items.BUILDING_TOOL.get())) {
            BuildingToolItem.setPos(tool, 0, (Vec3i)new BlockPos(bb.getPosA()));
            BuildingToolItem.setPos(tool, 1, (Vec3i)new BlockPos(bb.getPosB()));
        }
        return bb;
    }

    public void m_86600_() {
        this.parent.m_86600_();
    }

    public boolean m_7043_() {
        return false;
    }
}

