/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.screen.building_tool;

import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class BuildingToolOverlay {
    private static final ResourceLocation TEXTURE = StructureGelMod.locate("textures/gui/building_tool/overlay.png");

    public static void render(ForgeGui gui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        Pair<InteractionHand, ItemStack> tool;
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.f_91066_.f_92062_ && mc.f_91074_.m_7500_() && (mc.f_91080_ == null || mc.f_91080_ instanceof ChatScreen) && (tool = BuildingToolItem.getBuildingTool((Player)mc.f_91074_)) != null) {
            WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete;
            mc.m_91307_().m_6180_("building_tool_overlay");
            ItemStack stack = (ItemStack)tool.getSecond();
            Font font = gui.m_93082_();
            BuildingToolMode mode = BuildingToolItem.getMode(stack);
            Component hudComponent = mode.getHudMessage(stack);
            if (hudComponent != null) {
                int width = font.m_92852_((FormattedText)hudComponent);
                graphics.m_280430_(font, hudComponent, screenWidth / 2 - width / 2, screenHeight - 58, 0xE0E0E0);
            }
            if (mode.hasBlockPalette() && !(pallete = BuildingToolItem.getPallete(stack)).m_146337_()) {
                List sorted = pallete.m_146338_().stream().sorted(BuildingToolOverlay::compare).toList();
                int xSpacing = 20;
                int ySpacing = 20;
                int size = sorted.size();
                int leftEdge = screenWidth / 2 + 126;
                int perRow = Math.max(1, (screenWidth - leftEdge) / xSpacing);
                int rows = size / perRow + (size % perRow == 0 ? 0 : 1) - 1;
                int topEdge = screenHeight - 19 - rows * ySpacing;
                for (int i = 0; i < size; ++i) {
                    WeightedEntry.Wrapper wrapper = (WeightedEntry.Wrapper)sorted.get(i);
                    int horizontalIndex = i % perRow;
                    int row = i / perRow;
                    int x = leftEdge + horizontalIndex * xSpacing;
                    int y = topEdge + row * ySpacing;
                    RenderSystem.enableBlend();
                    int tileWidth = 22;
                    int borderWidth = 1;
                    boolean isFirst = horizontalIndex == 0;
                    boolean isLast = horizontalIndex == perRow - 1 || i == size - 1;
                    boolean isTop = row == 0;
                    boolean isBottom = row == rows || i + perRow > size - 1;
                    int texX = isFirst ? 0 : borderWidth;
                    int texY = isTop ? 0 : borderWidth;
                    int texU = tileWidth - texX - (isLast ? 0 : borderWidth);
                    int texV = tileWidth - texY - (isBottom ? 0 : borderWidth);
                    graphics.m_280218_(TEXTURE, x - 3 + texX, y - 3 + texY, texX, texY, texU, texV);
                    RenderSystem.disableBlend();
                    ItemStack item = BuildingToolItem.getItemForBlock((BlockState)wrapper.m_146310_());
                    graphics.m_280480_(item, x, y);
                    if (size <= 1) continue;
                    graphics.m_280302_(font, item, x, y, "x" + wrapper.m_142631_().m_146281_());
                }
            }
            mc.m_91307_().m_7238_();
        }
    }

    private static int compare(WeightedEntry.Wrapper<BlockState> w1, WeightedEntry.Wrapper<BlockState> w2) {
        return Integer.compare(w2.m_142631_().m_146281_(), w1.m_142631_().m_146281_());
    }
}

