/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.screen;

import com.legacy.structure_gel.api.data_handler.DataHandlerType;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.block.DataHandlerBlock;
import com.legacy.structure_gel.core.block_entity.DataHandlerBlockEntity;
import com.legacy.structure_gel.core.client.widget.DataParamsList;
import com.legacy.structure_gel.core.client.widget.SuggestionEditBox;
import com.legacy.structure_gel.core.client.widget.TooltipImageButton;
import com.legacy.structure_gel.core.network.SGPacketHandler;
import com.legacy.structure_gel.core.network.UpdateDataHandlerPacket;
import com.legacy.structure_gel.core.util.SGText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.Weight;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class DataHandlerScreen
extends Screen {
    private static final ResourceLocation WIDGETS = StructureGelMod.locate("textures/gui/widgets.png");
    private static final String APPLY_AT_HEIGHTMAP_KEY = "gui.structure_gel.data_handler.apply_at_heightmap";
    private final List<DataHandlerBlockEntity.RawHandler> handlers = new ArrayList<DataHandlerBlockEntity.RawHandler>();
    private final List<Map<ResourceLocation, List<DataParamsList.Entry>>> dataParamsCache = new ArrayList<Map<ResourceLocation, List<DataParamsList.Entry>>>();
    private int visibleIndex = 0;
    private final DataHandlerBlockEntity dataHandler;
    private boolean useGravity = false;
    private boolean waterlogged = false;
    private SuggestionEditBox typeEdit;
    private DataParamsList dataParamsList;
    public EditBox weightEdit;
    public EditBox nameEdit;
    public EditBox xOffsetEdit;
    public EditBox yOffsetEdit;
    public EditBox zOffsetEdit;
    public Button doneButton;
    public Button generateButton;
    public Button nextButton;
    public Button prevButton;
    public TooltipImageButton toggleGravityButton;
    public TooltipImageButton toggleWaterloggedButton;

    public DataHandlerScreen(DataHandlerBlockEntity dataHandler) {
        super((Component)Component.m_237119_());
        this.dataHandler = dataHandler;
        this.handlers.addAll(dataHandler.getHandlers().m_146338_());
        this.useGravity = dataHandler.useGravity();
        this.waterlogged = (Boolean)dataHandler.m_58900_().m_61143_((Property)DataHandlerBlock.WATERLOGGED);
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.dataParamsCache.add(new HashMap());
        }
        if (this.handlers.isEmpty()) {
            this.handlers.add(DataHandlerBlockEntity.RawHandler.EMPTY);
        }
        if (this.dataParamsCache.isEmpty()) {
            this.dataParamsCache.add(new HashMap());
        }
    }

    public void m_86600_() {
        this.typeEdit.m_94120_();
        this.dataParamsList.tick();
        this.doneButton.f_93623_ = this.allowDoneButton();
        this.generateButton.f_93623_ = this.allowGenerateButton();
        boolean allValid = this.generateButton.f_93623_ && this.generateButton.f_93623_;
        this.prevButton.f_93623_ = this.visibleIndex > 0 && (this.typeEdit.m_94155_().isEmpty() || allValid);
        this.nextButton.f_93623_ = allValid;
    }

    private void onDone(byte flag) {
        this.beforePageChange();
        this.sendToServer(flag);
        this.f_96541_.m_91152_((Screen)null);
    }

    private void onCancel() {
        this.f_96541_.m_91152_((Screen)null);
    }

    private void sendToServer(byte flag) {
        Vec3 offsetVec;
        try {
            offsetVec = new Vec3(Double.valueOf(this.xOffsetEdit.m_94155_()).doubleValue(), Double.valueOf(this.yOffsetEdit.m_94155_()).doubleValue(), Double.valueOf(this.zOffsetEdit.m_94155_()).doubleValue());
        }
        catch (NumberFormatException e) {
            offsetVec = Vec3.f_82478_;
        }
        SGPacketHandler.sendToServer(new UpdateDataHandlerPacket(flag, this.dataHandler.m_58899_(), this.handlers, this.nameEdit.m_94155_(), this.useGravity, this.waterlogged, offsetVec));
    }

    public void m_7379_() {
        this.onCancel();
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int buttonHeight = 20;
        this.typeEdit = new SuggestionEditBox(this.f_96547_, centerX - 152, 25, 215, buttonHeight, (Component)SGText.TYPE_LABEL, 10, DataHandlerType.REGISTRY.getKeys());
        this.typeEdit.m_94199_(128);
        this.typeEdit.m_94151_(s -> this.updateWidgets());
        this.m_7787_((GuiEventListener)this.typeEdit);
        this.weightEdit = new EditBox(this.f_96547_, this.typeEdit.m_252754_() + this.typeEdit.m_5711_() + 7, this.typeEdit.m_252907_(), 303 - this.typeEdit.m_5711_() - 6, this.typeEdit.m_93694_(), (Component)Component.m_237119_());
        this.weightEdit.m_94199_(8);
        this.weightEdit.m_94144_("1");
        this.weightEdit.m_94151_(s -> this.updateWidgets());
        this.m_142416_((GuiEventListener)this.weightEdit);
        this.dataParamsList = new DataParamsList(this, this.f_96541_, null);
        this.m_7787_((GuiEventListener)this.dataParamsList);
        int totalRowWidth = 300;
        int bottomRowStart = centerX - totalRowWidth / 2;
        int bottomRowIndex = 0;
        int bottomRowWidth = totalRowWidth / 3;
        this.doneButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.onDone((byte)0)).m_252794_(bottomRowStart + bottomRowWidth * bottomRowIndex++, this.f_96544_ - 30).m_253046_(bottomRowWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.onCancel()).m_252794_(bottomRowStart + bottomRowWidth * bottomRowIndex++, this.doneButton.m_252907_()).m_253046_(bottomRowWidth, buttonHeight).m_253136_());
        this.generateButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"jigsaw_block.generate"), button -> this.onDone((byte)1)).m_252794_(bottomRowStart + bottomRowWidth * bottomRowIndex++, this.doneButton.m_252907_()).m_253046_(bottomRowWidth, buttonHeight).m_253136_());
        int nextButtonWidth = 16;
        int nextButtonHeight = 32;
        int nextButtonXOffset = 170;
        this.prevButton = (Button)this.m_142416_((GuiEventListener)new TooltipImageButton(centerX - (nextButtonXOffset + nextButtonWidth), centerY - nextButtonHeight / 2, nextButtonWidth, nextButtonHeight, 0, 0, WIDGETS, button -> this.previous()));
        this.nextButton = (Button)this.m_142416_((GuiEventListener)new TooltipImageButton(centerX + nextButtonXOffset, centerY - nextButtonHeight / 2, nextButtonWidth, nextButtonHeight, nextButtonWidth, 0, WIDGETS, button -> this.next()));
        int imageButtonWidth = 20;
        TooltipImageButton propertiesButton = new TooltipImageButton(this.typeEdit.m_252754_() - 35, this.typeEdit.m_252907_() + 1, imageButtonWidth, imageButtonWidth, 32, 0, WIDGETS, button -> this.toggleProperties());
        propertiesButton.m_257544_(Tooltip.m_257550_((Component)SGText.PROPERTIES_LABEL));
        this.m_142416_((GuiEventListener)propertiesButton);
        int toggleButtonSpacing = imageButtonWidth + 5;
        int toggleButtonX = this.typeEdit.m_252754_();
        this.toggleGravityButton = new TooltipImageButton(toggleButtonX, propertiesButton.m_252907_(), imageButtonWidth, imageButtonWidth, this.useGravity ? 52 : 72, 0, WIDGETS, button -> this.toggleGravity());
        this.toggleGravityButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)APPLY_AT_HEIGHTMAP_KEY, (Object[])new Object[]{this.useGravity})));
        this.toggleWidget((AbstractWidget)this.toggleGravityButton, false);
        this.m_142416_((GuiEventListener)this.toggleGravityButton);
        this.toggleWaterloggedButton = new TooltipImageButton(toggleButtonX += toggleButtonSpacing, propertiesButton.m_252907_(), imageButtonWidth, imageButtonWidth, this.waterlogged ? 92 : 112, 0, WIDGETS, button -> this.toggleWaterlogged());
        this.toggleWaterloggedButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"gui.structure_gel.waterlogged", (Object[])new Object[]{this.waterlogged})));
        this.toggleWidget((AbstractWidget)this.toggleWaterloggedButton, false);
        this.m_142416_((GuiEventListener)this.toggleWaterloggedButton);
        toggleButtonX += toggleButtonSpacing;
        this.nameEdit = new EditBox(this.f_96547_, centerX - this.typeEdit.m_5711_() / 2, this.typeEdit.m_252907_() + 50, this.typeEdit.m_5711_(), this.typeEdit.m_93694_(), (Component)Component.m_237119_());
        Component name = this.dataHandler.getCustomName();
        if (name != null) {
            this.nameEdit.m_94144_(name.getString());
        }
        this.toggleWidget((AbstractWidget)this.nameEdit, false);
        this.m_7787_((GuiEventListener)this.nameEdit);
        Vec3 offset = this.dataHandler.getOffset();
        int offsetEditWidth = 30;
        int offsetEditSpacing = 20;
        this.xOffsetEdit = new EditBox(this.f_96547_, this.nameEdit.m_252754_() + 10, this.nameEdit.m_252907_() + 40, offsetEditWidth, this.typeEdit.m_93694_(), (Component)Component.m_237119_());
        this.xOffsetEdit.m_94144_(Double.toString(offset.m_7096_()));
        this.toggleWidget((AbstractWidget)this.xOffsetEdit, false);
        this.xOffsetEdit.m_257544_(Tooltip.m_257550_((Component)SGText.LEFT_LABEL));
        this.m_7787_((GuiEventListener)this.xOffsetEdit);
        this.yOffsetEdit = new EditBox(this.f_96547_, this.xOffsetEdit.m_252754_() + this.xOffsetEdit.m_5711_() + offsetEditSpacing, this.xOffsetEdit.m_252907_(), offsetEditWidth, this.typeEdit.m_93694_(), (Component)Component.m_237119_());
        this.yOffsetEdit.m_94144_(Double.toString(offset.m_7098_()));
        this.toggleWidget((AbstractWidget)this.yOffsetEdit, false);
        this.yOffsetEdit.m_257544_(Tooltip.m_257550_((Component)SGText.UP_LABEL));
        this.m_7787_((GuiEventListener)this.yOffsetEdit);
        this.zOffsetEdit = new EditBox(this.f_96547_, this.yOffsetEdit.m_252754_() + this.yOffsetEdit.m_5711_() + offsetEditSpacing, this.yOffsetEdit.m_252907_(), offsetEditWidth, this.typeEdit.m_93694_(), (Component)Component.m_237119_());
        this.zOffsetEdit.m_94144_(Double.toString(offset.m_7094_()));
        this.toggleWidget((AbstractWidget)this.zOffsetEdit, false);
        this.zOffsetEdit.m_257544_(Tooltip.m_257550_((Component)SGText.FORWARD_LABEL));
        this.m_7787_((GuiEventListener)this.zOffsetEdit);
        this.updateWidgets();
        this.injectData();
    }

    private void toggleProperties() {
        boolean active = !this.nameEdit.f_93624_;
        this.toggleWidget((AbstractWidget)this.typeEdit, !active);
        this.toggleWidget((AbstractWidget)this.weightEdit, !active);
        this.dataParamsList.showScrollBar = !active;
        for (DataParamsList.Entry entry : this.dataParamsList.m_6702_()) {
            this.toggleWidget(entry.widget, !active);
        }
        this.prevButton.f_93624_ = !active;
        this.nextButton.f_93624_ = !active;
        this.toggleWidget((AbstractWidget)this.nameEdit, active);
        this.toggleWidget((AbstractWidget)this.xOffsetEdit, active);
        this.toggleWidget((AbstractWidget)this.yOffsetEdit, active);
        this.toggleWidget((AbstractWidget)this.zOffsetEdit, active);
        this.toggleWidget((AbstractWidget)this.toggleGravityButton, active);
        this.toggleWidget((AbstractWidget)this.toggleWaterloggedButton, active);
    }

    private void toggleWidget(AbstractWidget widget, boolean active) {
        widget.f_93624_ = active;
        widget.f_93623_ = active;
        widget.m_93692_(false);
        if (widget instanceof EditBox) {
            EditBox edit = (EditBox)widget;
            edit.m_94186_(active);
        }
    }

    private void toggleGravity() {
        this.useGravity = !this.useGravity;
        this.toggleGravityButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)APPLY_AT_HEIGHTMAP_KEY, (Object[])new Object[]{this.useGravity})));
        this.toggleGravityButton.u = this.useGravity ? 52 : 72;
    }

    private void toggleWaterlogged() {
        this.waterlogged = !this.waterlogged;
        this.toggleWaterloggedButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"gui.structure_gel.waterlogged", (Object[])new Object[]{this.waterlogged})));
        this.toggleWaterloggedButton.u = this.waterlogged ? 92 : 112;
    }

    private void next() {
        int size = this.handlers.size();
        if (this.visibleIndex < size) {
            this.beforePageChange();
            ++this.visibleIndex;
            if (this.visibleIndex == size) {
                this.handlers.add(DataHandlerBlockEntity.RawHandler.EMPTY);
                this.dataParamsCache.add(new HashMap());
            }
            this.updateWidgets();
            this.injectData();
        }
    }

    private void previous() {
        if (this.visibleIndex > 0) {
            this.beforePageChange();
            --this.visibleIndex;
            this.updateWidgets();
            this.injectData();
        }
    }

    public boolean allowDoneButton() {
        return ResourceLocation.m_135830_((String)this.typeEdit.m_94155_()) && this.dataParamsList.isValid() && this.isWeightValid();
    }

    public boolean allowGenerateButton() {
        return this.allowDoneButton() && DataHandlerType.REGISTRY.get(new ResourceLocation(this.typeEdit.m_94155_())) != null && this.dataParamsList.isValid() && this.isWeightValid() && !this.nameEdit.m_94213_();
    }

    public boolean isWeightValid() {
        try {
            int weight = Integer.parseInt(this.weightEdit.m_94155_());
            if (weight < 1) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void beforePageChange() {
        Weight weight = Weight.m_146282_((int)Integer.parseInt(this.weightEdit.m_94155_()));
        ResourceLocation typeName = new ResourceLocation(this.typeEdit.m_94155_());
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        for (DataParamsList.Entry entry : this.dataParamsList.m_6702_()) {
            dataMap.put(entry.parser.key, entry.getValue());
        }
        if (this.visibleIndex < this.handlers.size()) {
            this.handlers.set(this.visibleIndex, new DataHandlerBlockEntity.RawHandler(weight, typeName, dataMap));
        }
    }

    private void injectData() {
        DataHandlerBlockEntity.RawHandler handler = this.visibleIndex < this.handlers.size() ? this.handlers.get(this.visibleIndex) : DataHandlerBlockEntity.RawHandler.EMPTY;
        this.weightEdit.m_94144_("" + handler.m_142631_().m_146281_());
        ResourceLocation typeName = handler.typeName();
        this.typeEdit.m_94144_(typeName.m_135815_().isEmpty() ? "" : typeName.toString());
        LinkedHashMap<String, String> dataMap = handler.dataEntries();
        for (DataParamsList.Entry entry : this.dataParamsList.m_6702_()) {
            String val = dataMap.get(entry.parser.key);
            if (val == null) continue;
            entry.setValue(val);
        }
    }

    private void updateWidgets() {
        this.weightEdit.m_94202_(this.isWeightValid() ? 0xE0E0E0 : 14703708);
        String typeStr = this.typeEdit.m_94155_();
        boolean typeFlag = ResourceLocation.m_135830_((String)this.typeEdit.m_94155_());
        this.typeEdit.m_94202_(typeFlag ? 0xE0E0E0 : 14703708);
        this.doneButton.f_93623_ = this.allowDoneButton();
        this.generateButton.f_93623_ = this.allowGenerateButton();
        if (!typeFlag) {
            this.dataParamsList.setEntries(null);
            return;
        }
        ResourceLocation typeName = new ResourceLocation(typeStr);
        DataHandlerType<?> type = DataHandlerType.REGISTRY.get(typeName);
        if (type != null) {
            Map<ResourceLocation, List<DataParamsList.Entry>> cache = this.dataParamsCache.get(this.visibleIndex);
            List<DataParamsList.Entry> cachedParams = cache.get(typeName);
            if (cachedParams == null) {
                this.dataParamsList.createEntries(type.getDataParser());
                cache.put(typeName, this.dataParamsList.childrenClone());
            } else {
                this.dataParamsList.setEntries(cachedParams);
            }
        } else {
            this.dataParamsList.setEntries(null);
        }
        boolean allValid = this.doneButton.f_93623_ && this.generateButton.f_93623_;
        this.prevButton.f_93623_ = this.visibleIndex > 0 && (this.typeEdit.m_94155_().isEmpty() || allValid);
        this.nextButton.f_93623_ = allValid;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        this.dataParamsList.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.typeEdit.m_94213_()) {
            graphics.m_280430_(this.f_96547_, (Component)SGText.TYPE_LABEL, this.typeEdit.m_252754_(), this.typeEdit.m_252907_() - 14, 0xA0A0A0);
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"info.structure_gel.building_tool.property.weight"), this.weightEdit.m_252754_(), this.weightEdit.m_252907_() - 14, 0xA0A0A0);
            this.typeEdit.m_88315_(graphics, mouseX, mouseY, partialTicks);
        } else {
            graphics.m_280430_(this.f_96547_, (Component)SGText.PROPERTIES_LABEL, this.typeEdit.m_252754_(), this.typeEdit.m_252907_() - 14, 0xA0A0A0);
        }
        if (this.nameEdit.m_94213_()) {
            graphics.m_280430_(this.f_96547_, (Component)SGText.DISPLAY_NAME_LABEL, this.nameEdit.m_252754_(), this.nameEdit.m_252907_() - 14, 0xA0A0A0);
            this.nameEdit.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
        int labelX = 11;
        int labelY = 6;
        if (this.xOffsetEdit.m_94213_()) {
            graphics.m_280430_(this.f_96547_, (Component)SGText.OFFSET_LABEL, this.nameEdit.m_252754_(), this.xOffsetEdit.m_252907_() - 14, 0xA0A0A0);
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"\u2190"), this.xOffsetEdit.m_252754_() - labelX, this.xOffsetEdit.m_252907_() + labelY, 0xA0A0A0);
            this.xOffsetEdit.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.yOffsetEdit.m_94213_()) {
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"\u2191"), this.yOffsetEdit.m_252754_() - labelX, this.yOffsetEdit.m_252907_() + labelY, 0xA0A0A0);
            this.yOffsetEdit.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
        if (this.zOffsetEdit.m_94213_()) {
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"\u2199"), this.zOffsetEdit.m_252754_() - labelX, this.zOffsetEdit.m_252907_() + labelY, 0xA0A0A0);
            this.zOffsetEdit.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public void renderTooltip(GuiGraphics graphics, List<Component> lines, int mouseX, int mouseY) {
        graphics.m_280677_(this.f_96547_, lines, Optional.empty(), mouseX, mouseY);
    }

    public void m_6574_(Minecraft mc, int mouseX, int mouseY) {
        String type = this.typeEdit.m_94155_();
        this.m_6575_(mc, mouseX, mouseY);
        this.typeEdit.m_94144_(type);
    }

    public boolean m_6375_(double mouseX, double mouseY, int clickType) {
        for (DataParamsList.Entry entry : this.dataParamsList.m_6702_()) {
            if (!entry.widget.m_93696_() || !entry.widget.m_6375_(mouseX, mouseY, clickType)) continue;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, clickType);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_7933_(int keyCode, int keyB, int modifiers) {
        if (this.typeEdit.m_93696_() && this.typeEdit.m_7933_(keyCode, keyB, modifiers)) {
            return true;
        }
        for (DataParamsList.Entry entry : this.dataParamsList.m_6702_()) {
            if (!entry.widget.m_93696_() || !entry.widget.m_7933_(keyCode, keyB, modifiers)) continue;
            return true;
        }
        if (super.m_7933_(keyCode, keyB, modifiers)) {
            return true;
        }
        if (this.doneButton.f_93623_ && (keyCode == 257 || keyCode == 335)) {
            this.onDone((byte)0);
            return true;
        }
        return false;
    }
}

