/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;

public interface IRenderBase {
    public static final Vec3 ONE = new Vec3(1.0, 1.0, 1.0);

    public static void makeLineBox(PoseStack poseStack, VertexConsumer vertexCon, BlockPos pos, float r, float g, float b, float a) {
        IRenderBase.makeLineBox(poseStack, vertexCon, BoundingBox.m_162375_((Vec3i)pos, (Vec3i)pos), 0.0, r, g, b, a);
    }

    public static void makeLineBox(PoseStack poseStack, VertexConsumer vertexCon, BoundingBox bounds, float r, float g, float b) {
        IRenderBase.makeLineBox(poseStack, vertexCon, bounds, 0.0, r, g, b);
    }

    public static void makeLineBox(PoseStack poseStack, VertexConsumer vertexCon, BoundingBox bounds, float r, float g, float b, float a) {
        IRenderBase.makeLineBox(poseStack, vertexCon, bounds, 0.0, r, g, b, a);
    }

    public static void makeLineBox(PoseStack poseStack, VertexConsumer vertexCon, BoundingBox bounds, double expand, float r, float g, float b) {
        IRenderBase.makeLineBox(poseStack, vertexCon, bounds, expand, r, g, b, 1.0f);
    }

    public static void makeLineBox(PoseStack poseStack, VertexConsumer vertexCon, BoundingBox bounds, double expand, float r, float g, float b, float a) {
        IRenderBase.makeLineBox(poseStack, vertexCon, (double)bounds.m_162395_() - expand, (double)bounds.m_162396_() - expand, (double)bounds.m_162398_() - expand, (double)(bounds.m_162399_() + 1) + expand, (double)(bounds.m_162400_() + 1) + expand, (double)(bounds.m_162401_() + 1) + expand, r, g, b, a);
    }

    public static void makeLineBox(PoseStack poseStack, VertexConsumer vertexCon, double nX, double nY, double nZ, double xX, double xY, double xZ, float r, float g, float b, float a) {
        double width = 0.04;
        Set<Direction> topCulls = Set.of(Direction.UP, Direction.DOWN);
        Set<Direction> sideCulls = Set.of(Direction.EAST, Direction.WEST);
        IRenderBase.makeBox(poseStack, vertexCon, nX - width, nY + width, nZ - width, nX + width, xY - width, nZ + width, r, g, b, a, topCulls);
        IRenderBase.makeBox(poseStack, vertexCon, nX - width, nY + width, xZ - width, nX + width, xY - width, xZ + width, r, g, b, a, topCulls);
        IRenderBase.makeBox(poseStack, vertexCon, xX - width, nY + width, nZ - width, xX + width, xY - width, nZ + width, r, g, b, a, topCulls);
        IRenderBase.makeBox(poseStack, vertexCon, xX - width, nY + width, xZ - width, xX + width, xY - width, xZ + width, r, g, b, a, topCulls);
        IRenderBase.makeBox(poseStack, vertexCon, nX + width, xY - width, nZ - width, xX - width, xY + width, nZ + width, r, g, b, a, sideCulls);
        IRenderBase.makeBox(poseStack, vertexCon, nX + width, xY - width, xZ - width, xX - width, xY + width, xZ + width, r, g, b, a, sideCulls);
        IRenderBase.makeBox(poseStack, vertexCon, nX - width, xY - width, nZ - width, nX + width, xY + width, xZ + width, r, g, b, a);
        IRenderBase.makeBox(poseStack, vertexCon, xX - width, xY - width, nZ - width, xX + width, xY + width, xZ + width, r, g, b, a);
        IRenderBase.makeBox(poseStack, vertexCon, nX + width, nY - width, nZ - width, xX - width, nY + width, nZ + width, r, g, b, a, sideCulls);
        IRenderBase.makeBox(poseStack, vertexCon, nX + width, nY - width, xZ - width, xX - width, nY + width, xZ + width, r, g, b, a, sideCulls);
        IRenderBase.makeBox(poseStack, vertexCon, nX - width, nY - width, nZ - width, nX + width, nY + width, xZ + width, r, g, b, a);
        IRenderBase.makeBox(poseStack, vertexCon, xX - width, nY - width, nZ - width, xX + width, nY + width, xZ + width, r, g, b, a);
    }

    public static void makeBox(PoseStack poseStack, VertexConsumer vertexCon, Vec3 pos, float r, float g, float b, float a) {
        IRenderBase.makeBox(poseStack, vertexCon, pos, pos.m_82549_(ONE), r, g, b, a);
    }

    public static void makeBox(PoseStack poseStack, VertexConsumer vertexCon, Vec3 from, Vec3 to, float r, float g, float b, float a) {
        IRenderBase.makeBox(poseStack, vertexCon, from.m_7096_(), from.m_7098_(), from.m_7094_(), to.m_7096_(), to.m_7098_(), to.m_7094_(), r, g, b, a);
    }

    private static int comparePoses(Vec3 renderPos, Vec3 camPos, BlockPos p1, BlockPos p2) {
        return Double.compare(renderPos.m_82549_(Vec3.m_82512_((Vec3i)p2)).m_82554_(camPos), renderPos.m_82549_(Vec3.m_82512_((Vec3i)p1)).m_82554_(camPos));
    }

    public static void highlightVoxelShapes(PoseStack poseStack, VertexConsumer vertexCon, Vec3i renderPos, Map<BlockPos, VoxelShape> shapes, float r, float g, float b, float a) {
        Vec3 renderVec = Vec3.m_82512_((Vec3i)renderPos);
        Vec3 camPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        shapes.entrySet().stream().sorted((e1, e2) -> IRenderBase.comparePoses(renderVec, camPos, (BlockPos)e1.getKey(), (BlockPos)e2.getKey())).forEach(entry -> {
            BlockPos pos = (BlockPos)entry.getKey();
            VoxelShape shape = (VoxelShape)entry.getValue();
            shape.m_83286_((sx, sy, sz, smx, smy, smz) -> {
                HashSet<Direction> culled = new HashSet<Direction>();
                int facesCulled = 0;
                if (shape == Shapes.m_83144_()) {
                    for (Direction d : Direction.values()) {
                        BlockPos relative = pos.m_121945_(d);
                        if (!shapes.containsKey(relative) || shapes.get(relative) != Shapes.m_83144_()) continue;
                        culled.add(d);
                        facesCulled = (byte)(facesCulled + 1);
                    }
                }
                if (facesCulled < 6) {
                    double extend = 0.005;
                    int x = pos.m_123341_();
                    int y = pos.m_123342_();
                    int z = pos.m_123343_();
                    IRenderBase.makeBox(poseStack, vertexCon, (double)x + sx - (culled.contains(Direction.WEST) ? 0.0 : extend), (double)y + sy - (culled.contains(Direction.DOWN) ? 0.0 : extend), (double)z + sz - (culled.contains(Direction.NORTH) ? 0.0 : extend), (double)x + smx + (culled.contains(Direction.EAST) ? 0.0 : extend), (double)y + smy + (culled.contains(Direction.UP) ? 0.0 : extend), (double)z + smz + (culled.contains(Direction.SOUTH) ? 0.0 : extend), r, g, b, a, culled);
                }
            });
        });
    }

    public static void highlightBlocks(PoseStack poseStack, VertexConsumer vertexCon, Vec3i renderPos, Collection<BlockPos> poses, float r, float g, float b, float a) {
        ArrayList<Pair> toRender = new ArrayList<Pair>();
        for (BlockPos pos : poses) {
            HashSet<Direction> culled = new HashSet<Direction>();
            int facesCulled = 0;
            for (Direction d : Direction.values()) {
                if (!poses.contains(pos.m_121945_(d))) continue;
                culled.add(d);
                facesCulled = (byte)(facesCulled + 1);
            }
            if (facesCulled >= 6) continue;
            toRender.add(Pair.of((Object)pos, culled));
        }
        Vec3 renderVec = Vec3.m_82512_((Vec3i)renderPos);
        Vec3 camPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        toRender.sort((p1, p2) -> IRenderBase.comparePoses(renderVec, camPos, (BlockPos)p1.getFirst(), (BlockPos)p2.getFirst()));
        int size = toRender.size();
        for (int i = 0; i < size; ++i) {
            Pair pair = (Pair)toRender.get(i);
            BlockPos pos = (BlockPos)pair.getFirst();
            Set culled = (Set)pair.getSecond();
            double extend = 0.005;
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            IRenderBase.makeBox(poseStack, vertexCon, (double)x - (culled.contains(Direction.WEST) ? 0.0 : extend), (double)y - (culled.contains(Direction.DOWN) ? 0.0 : extend), (double)z - (culled.contains(Direction.NORTH) ? 0.0 : extend), (double)(x + 1) + (culled.contains(Direction.EAST) ? 0.0 : extend), (double)(y + 1) + (culled.contains(Direction.UP) ? 0.0 : extend), (double)(z + 1) + (culled.contains(Direction.SOUTH) ? 0.0 : extend), r, g, b, a, (Set<Direction>)culled);
        }
    }

    public static void highlightBlockPos(PoseStack poseStack, VertexConsumer vertexCon, Vec3i renderPos, Collection<BlockPos> poses, float r, float g, float b, float a) {
        double inner = 0.25;
        double outer = 1.0 - inner;
        Vec3 renderVec = Vec3.m_82512_((Vec3i)renderPos);
        Vec3 camPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        ArrayList<BlockPos> sorted = new ArrayList<BlockPos>(poses);
        sorted.sort((p1, p2) -> IRenderBase.comparePoses(renderVec, camPos, p1, p2));
        int size = sorted.size();
        for (int i = 0; i < size; ++i) {
            BlockPos pos = (BlockPos)sorted.get(i);
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            IRenderBase.makeBox(poseStack, vertexCon, (double)x + inner, (double)y + inner, (double)z + inner, (double)x + outer, (double)y + outer, (double)z + outer, r, g, b, a);
        }
    }

    public static void makeBox(PoseStack poseStack, VertexConsumer vertexCon, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float r, float g, float b, float a, Set<Direction> culledFaces) {
        IRenderBase.makeBox(poseStack, vertexCon, (float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, r, g, b, a, culledFaces);
    }

    public static void makeBox(PoseStack poseStack, VertexConsumer vertexCon, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float r, float g, float b, float a) {
        IRenderBase.makeBox(poseStack, vertexCon, (float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, r, g, b, a, Collections.emptySet());
    }

    public static void makeBox(PoseStack poseStack, VertexConsumer vertexCon, float mnX, float mnY, float mnZ, float mxX, float mxY, float mxZ, float r, float g, float b, float a, Set<Direction> culledFaces) {
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        float ew = 0.7f;
        float ns = 0.9f;
        float down = 0.5f;
        float dR = r * down;
        float dG = g * down;
        float dB = b * down;
        float ewR = r * ew;
        float ewG = g * ew;
        float ewB = b * ew;
        float nsR = r * ns;
        float nsG = g * ns;
        float nsB = b * ns;
        if (!culledFaces.contains(Direction.WEST)) {
            vertexCon.m_252986_(matrix4f, mnX, mnY, mnZ).m_85950_(ewR, ewG, ewB, a).m_5752_();
            vertexCon.m_252986_(matrix4f, mnX, mnY, mxZ).m_85950_(ewR, ewG, ewB, a).m_5752_();
            vertexCon.m_252986_(matrix4f, mnX, mxY, mxZ).m_85950_(ewR, ewG, ewB, a).m_5752_();
            vertexCon.m_252986_(matrix4f, mnX, mxY, mnZ).m_85950_(ewR, ewG, ewB, a).m_5752_();
        }
        if (!culledFaces.contains(Direction.SOUTH)) {
            vertexCon.m_252986_(matrix4f, mnX, mnY, mxZ).m_85950_(nsR, nsG, nsB, a).m_5752_();
            vertexCon.m_252986_(matrix4f, mxX, mnY, mxZ).m_85950_(nsR, nsG, nsB, a).m_5752_();
            vertexCon.m_252986_(matrix4f, mxX, mxY, mxZ).m_85950_(nsR, nsG, nsB, a).m_5752_();
            vertexCon.m_252986_(matrix4f, mnX, mxY, mxZ).m_85950_(nsR, nsG, nsB, a).m_5752_();
        }
        if (!culledFaces.contains(Direction.EAST)) {
            vertexCon.m_252986_(matrix4f, mxX, mnY, mxZ).m_85950_(ewR, ewG, ewB, a).m_5752_();
            vertexCon.m_252986_(matrix4f, mxX, mnY, mnZ).m_85950_(ewR, ewG, ewB, a).m_5752_();
            vertexCon.m_252986_(matrix4f, mxX, mxY, mnZ).m_85950_(ewR, ewG, ewB, a).m_5752_();
            vertexCon.m_252986_(matrix4f, mxX, mxY, mxZ).m_85950_(ewR, ewG, ewB, a).m_5752_();
        }
        if (!culledFaces.contains(Direction.NORTH)) {
            vertexCon.m_252986_(matrix4f, mxX, mnY, mnZ).m_85950_(nsR, nsG, nsB, a).m_5752_();
            vertexCon.m_252986_(matrix4f, mnX, mnY, mnZ).m_85950_(nsR, nsG, nsB, a).m_5752_();
            vertexCon.m_252986_(matrix4f, mnX, mxY, mnZ).m_85950_(nsR, nsG, nsB, a).m_5752_();
            vertexCon.m_252986_(matrix4f, mxX, mxY, mnZ).m_85950_(nsR, nsG, nsB, a).m_5752_();
        }
        if (!culledFaces.contains(Direction.DOWN)) {
            vertexCon.m_252986_(matrix4f, mnX, mnY, mnZ).m_85950_(dR, dG, dB, a).m_5752_();
            vertexCon.m_252986_(matrix4f, mxX, mnY, mnZ).m_85950_(dR, dG, dB, a).m_5752_();
            vertexCon.m_252986_(matrix4f, mxX, mnY, mxZ).m_85950_(dR, dG, dB, a).m_5752_();
            vertexCon.m_252986_(matrix4f, mnX, mnY, mxZ).m_85950_(dR, dG, dB, a).m_5752_();
        }
        if (!culledFaces.contains(Direction.UP)) {
            vertexCon.m_252986_(matrix4f, mnX, mxY, mnZ).m_85950_(r, g, b, a).m_5752_();
            vertexCon.m_252986_(matrix4f, mnX, mxY, mxZ).m_85950_(r, g, b, a).m_5752_();
            vertexCon.m_252986_(matrix4f, mxX, mxY, mxZ).m_85950_(r, g, b, a).m_5752_();
            vertexCon.m_252986_(matrix4f, mxX, mxY, mnZ).m_85950_(r, g, b, a).m_5752_();
        }
    }
}

