/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.capability.level;

import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.capability.level.IGelLevel;
import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;

public class GelLevel
implements IGelLevel {
    private final Map<String, ActionHistory> actionHistory = new HashMap<String, ActionHistory>();
    private static final String ACTION_HISTORY_KEY = "action_history";

    @Override
    public Set<String> getActionHistoryOwners() {
        return this.actionHistory.keySet();
    }

    @Override
    public ActionHistory getActionHistory(String playerName) {
        return this.actionHistory.computeIfAbsent(playerName, ActionHistory::new);
    }

    @Override
    public void writeToNBT(CompoundTag tag, Level level) {
        ListTag actionsTag = new ListTag();
        for (Map.Entry<String, ActionHistory> entry : this.actionHistory.entrySet()) {
            ActionHistory history = entry.getValue();
            if (history.isEmpty() || history.isExpired(level)) continue;
            String player = entry.getKey();
            try {
                Tag historyTag = (Tag)ActionHistory.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)history).getOrThrow(false, s -> StructureGelMod.LOGGER.error("couldn't serialize action history for " + player + ": " + s, new Object[0]));
                actionsTag.add((Object)historyTag);
            }
            catch (Exception e) {
                StructureGelMod.LOGGER.error("Failed to save action history data for " + player, new Object[0]);
                e.printStackTrace();
            }
        }
        tag.m_128365_(ACTION_HISTORY_KEY, (Tag)actionsTag);
    }

    @Override
    public void readFromNBT(CompoundTag tag, Level level) {
        this.actionHistory.clear();
        if (tag.m_128425_(ACTION_HISTORY_KEY, 9)) {
            ListTag actionsTag = tag.m_128437_(ACTION_HISTORY_KEY, 10);
            for (Tag action : actionsTag) {
                try {
                    ActionHistory history = (ActionHistory)((Pair)ActionHistory.CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)action).getOrThrow(false, s -> StructureGelMod.LOGGER.error("couldn't deserialize action history: " + s, new Object[0]))).getFirst();
                    if (history.isEmpty() || history.isExpired(level)) continue;
                    this.actionHistory.put(history.getPlayer(), history);
                }
                catch (Exception e) {
                    StructureGelMod.LOGGER.error("Failed to load action history data for a player", new Object[0]);
                    e.printStackTrace();
                }
            }
        }
    }
}

