/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.capability;

import com.legacy.structure_gel.core.capability.entity.IGelEntity;
import com.legacy.structure_gel.core.capability.level.IGelLevel;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;

public class GelCapability {
    public static final Capability<IGelEntity> ENTITY_INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IGelEntity>(){});
    public static final Capability<IGelLevel> LEVEL_INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IGelLevel>(){});

    @Nullable
    public static <E extends Entity> IGelEntity get(E entity) {
        LazyOptional cap;
        if (entity != null && (cap = entity.getCapability(ENTITY_INSTANCE)).isPresent()) {
            return cap.resolve().orElseGet(() -> null);
        }
        return null;
    }

    public static <E extends Entity> void ifPresent(E entity, Consumer<IGelEntity> action) {
        IGelEntity cap = GelCapability.get(entity);
        if (cap != null) {
            action.accept(cap);
        }
    }

    public static <E extends Entity> void ifPresent(E entity, Consumer<IGelEntity> action, Runnable elseAction) {
        IGelEntity cap = GelCapability.get(entity);
        if (cap != null) {
            action.accept(cap);
        } else {
            elseAction.run();
        }
    }

    @Nullable
    public static <E extends Entity, R> R getIfPresent(E entity, Function<IGelEntity, R> action, Supplier<R> elseAction) {
        IGelEntity cap = GelCapability.get(entity);
        if (cap != null) {
            return action.apply(cap);
        }
        return elseAction.get();
    }

    @Nullable
    public static IGelLevel get(Level level) {
        LazyOptional cap;
        if (level != null && (cap = level.getCapability(LEVEL_INSTANCE)).isPresent()) {
            return cap.resolve().orElseGet(() -> null);
        }
        return null;
    }
}

