/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.events;

import com.legacy.structure_gel.core.StructureGelMod;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.IModBusEvent;

public class RegisterArmorTrimTexturesEvent
extends Event
implements IModBusEvent {
    private static final String darkerSuffix = "_darker";
    private final Set<ResourceLocation> trimPatterns;
    private final Map<String, ResourceLocation> trimMaterials;
    private final Map<ResourceKey<TrimMaterial>, Map<ArmorMaterial, String>> colorPaletteOverrides;
    private final Map<ResourceKey<TrimMaterial>, Integer> materialLight;

    public RegisterArmorTrimTexturesEvent(Set<ResourceLocation> trimPatterns, Map<String, ResourceLocation> trimMaterials, Map<ResourceKey<TrimMaterial>, Map<ArmorMaterial, String>> colorPaletteOverrides, Map<ResourceKey<TrimMaterial>, Integer> materialLight) {
        this.trimPatterns = trimPatterns;
        this.trimMaterials = trimMaterials;
        this.colorPaletteOverrides = colorPaletteOverrides;
        this.materialLight = materialLight;
    }

    public void registerPatternSprite(ResourceKey<TrimPattern> trimPattern) {
        this.registerPatternSprite(trimPattern.m_135782_());
    }

    public void registerPatternSprite(ResourceLocation trimPattern) {
        if (!this.trimPatterns.add(trimPattern)) {
            StructureGelMod.LOGGER.warn("Registered an armor trim pattern sprite that overrides an existing pattern. " + trimPattern, new Object[0]);
        }
    }

    public void registerMaterialSprite(ResourceKey<TrimMaterial> materialID, boolean withDarker) {
        this.registerMaterialSprite(materialID.m_135782_().m_135815_(), materialID.m_135782_(), withDarker);
    }

    public void registerMaterialSprite(String assetName, ResourceLocation materialID, boolean withDarker) {
        if (this.trimMaterials.put(assetName, materialID) != null) {
            StructureGelMod.LOGGER.warn("Registered an armor trim material palette that overrides an existing palette. asset_name=" + assetName + ", material_id=" + materialID, new Object[0]);
        }
        if (withDarker && this.trimMaterials.put(assetName + darkerSuffix, materialID.m_266382_(darkerSuffix)) != null) {
            StructureGelMod.LOGGER.warn("Registered an armor trim material palette that overrides an existing palette. asset_name=" + assetName + "_darker, material_id=" + materialID.m_266382_(darkerSuffix), new Object[0]);
        }
    }

    public void registerPaletteOverride(ResourceKey<TrimMaterial> material, Map<ArmorMaterial, String> overrides) {
        if (this.colorPaletteOverrides.put(material, overrides) != null) {
            StructureGelMod.LOGGER.warn("Registered an armor trim palette override that overrides an existing override. trim_material=" + material, new Object[0]);
        }
    }

    public void registerMaterialBrightness(ResourceKey<TrimMaterial> material, int brightness) {
        this.materialLight.put(material, brightness);
    }
}

