/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;

public final class BlockHelpers {
    public static HolderGetter<Block> HOLDER_GETTER_FORGE = new HolderGetter<Block>(){

        public Optional<Holder.Reference<Block>> m_254902_(ResourceKey<Block> key) {
            return ForgeRegistries.BLOCKS.getHolder(key);
        }

        public Optional<HolderSet.Named<Block>> m_254901_(TagKey<Block> p_256283_) {
            return Optional.empty();
        }
    };

    public static <T extends Comparable<T>> T getSafeBlockStateProperty(@Nullable BlockState state, Property<T> property, T fallback) {
        Comparable value;
        if (state == null) {
            return fallback;
        }
        try {
            value = state.m_61143_(property);
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
        if (value == null) {
            return fallback;
        }
        return (T)value;
    }

    public static CompoundTag serializeBlockState(BlockState blockState) {
        return NbtUtils.m_129202_((BlockState)blockState);
    }

    public static BlockState deserializeBlockState(HolderGetter<Block> holderGetter, CompoundTag serializedBlockState) {
        return NbtUtils.m_247651_(holderGetter, (CompoundTag)serializedBlockState);
    }

    public static BlockState getBlockStateFromItemStack(ItemStack itemStack) {
        Block block = ((BlockItem)itemStack.m_41720_()).m_40614_();
        return block.m_49966_();
    }

    public static ItemStack getItemStackFromBlockState(BlockState blockState) {
        return new ItemStack((ItemLike)blockState.m_60734_().m_5456_());
    }

    public static void markForUpdate(Level world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        world.m_7260_(pos, blockState, blockState, 3);
    }

    public static void addCollisionBoxToList(BlockPos pos, AABB collidingBox, List<AABB> collisions, AABB addingBox) {
        AABB axisalignedbb;
        if (addingBox != null && collidingBox.m_82381_(axisalignedbb = addingBox.m_82338_(pos))) {
            collisions.add(axisalignedbb);
        }
    }

    public static boolean doesBlockHaveSolidTopSurface(LevelReader world, BlockPos blockPos) {
        return world.m_8055_(blockPos.m_7918_(0, -1, 0)).m_60804_((BlockGetter)world, blockPos);
    }
}

