/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.ReactorGameData;
import it.zerono.mods.extremereactors.gamecontent.TurbineGameData;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.fluid.ReactantFluidBlock;
import it.zerono.mods.extremereactors.gamecontent.fluid.ReactorFluidType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.container.ChargingPortContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport.FluidPortType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.FluidizerPartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.MultiblockFluidizer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.container.FluidizerControllerContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.container.FluidizerSolidInjectorContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerCasingEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerFluidInjectorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerGlassEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerOutputPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerPowerPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.FluidizerSolidInjectorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerFluidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.IFluidizerRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.Reactants;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactorPartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.container.ReactorSolidAccessPortContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorCasingEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorChargingPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorComputerPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorControlRodEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorCreativeWaterGenerator;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorFluidAccessPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorFluidPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorFuelRodBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorFuelRodEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorGlassEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorMekanismFluidPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorPowerTapEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorRedstonePortBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorRedstonePortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorSolidAccessPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.MultiblockReprocessor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.ReprocessorPartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.container.ReprocessorAccessPortContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.ReprocessorAccessPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.ReprocessorCasingEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.ReprocessorCollectorEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.ReprocessorControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.ReprocessorFluidPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.ReprocessorGlassEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.part.ReprocessorPowerPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.recipe.ReprocessorRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.TurbinePartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineCasingEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineChargingPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineComputerPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineCreativeSteamGenerator;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineFluidPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineGlassEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbinePowerTapEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRedstonePortBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRedstonePortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorBearingBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorBearingEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorComponentEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import it.zerono.mods.extremereactors.loader.forge.gamecontent.worldgen.OreBiomeModifier;
import it.zerono.mods.zerocore.base.multiblock.part.GenericDeviceBlock;
import it.zerono.mods.zerocore.base.multiblock.part.GlassBlock;
import it.zerono.mods.zerocore.base.multiblock.part.io.IOPortBlock;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.block.ModOreBlock;
import it.zerono.mods.zerocore.lib.block.multiblock.MultiblockPartBlock;
import it.zerono.mods.zerocore.lib.compat.patchouli.Patchouli;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.fluid.SimpleFluidTypeRenderProperties;
import it.zerono.mods.zerocore.lib.item.ModItem;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.ModRecipeType;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.util.NonNullFunction;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class Content {
    public static void initialize() {
        IEventBus bus = (IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get();
        Blocks.initialize(bus);
        Items.initialize(bus);
        Fluids.initialize(bus);
        TileEntityTypes.initialize(bus);
        ContainerTypes.initialize(bus);
        Recipes.initialize(bus);
        Biomes.initialize(bus);
        CreativeTabs.initialize(bus);
        bus.addListener(Content::onCommonInit);
    }

    private static void onCommonInit(FMLCommonSetupEvent event) {
        ReactorGameData.register();
        TurbineGameData.register();
    }

    public static final class Blocks {
        private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"bigreactors");
        public static final RegistryObject<ModBlock> YELLORIUM_BLOCK = Blocks.registerMetalBlock(Reactants.Yellorium.getBlockName(), DyeColor.YELLOW);
        public static final RegistryObject<ModBlock> CYANITE_BLOCK = Blocks.registerMetalBlock(Reactants.Cyanite.getBlockName(), DyeColor.LIGHT_BLUE);
        public static final RegistryObject<ModBlock> GRAPHITE_BLOCK = Blocks.registerMetalBlock("graphite_block", DyeColor.GRAY);
        public static final RegistryObject<ModBlock> BLUTONIUM_BLOCK = Blocks.registerMetalBlock(Reactants.Blutonium.getBlockName(), DyeColor.PURPLE);
        public static final RegistryObject<ModBlock> MAGENTITE_BLOCK = Blocks.registerMetalBlock(Reactants.Magentite.getBlockName(), DyeColor.MAGENTA);
        public static final RegistryObject<ModBlock> LUDICRITE_BLOCK = Blocks.registerMetalBlock("ludicrite_block", DyeColor.PURPLE);
        public static final RegistryObject<ModBlock> RIDICULITE_BLOCK = Blocks.registerMetalBlock("ridiculite_block", DyeColor.PINK);
        public static final RegistryObject<ModBlock> INANITE_BLOCK = Blocks.registerMetalBlock("inanite_block", DyeColor.RED);
        public static final RegistryObject<ModBlock> INSANITE_BLOCK = Blocks.registerMetalBlock("insanite_block", DyeColor.RED);
        public static final RegistryObject<ModBlock> YELLORITE_ORE_BLOCK = Blocks.registerOreBlock("yellorite_ore", DyeColor.YELLOW, 0, 0);
        public static final RegistryObject<ModBlock> ANGLESITE_ORE_BLOCK = Blocks.registerOreBlock("anglesite_ore", DyeColor.ORANGE);
        public static final RegistryObject<ModBlock> BENITOITE_ORE_BLOCK = Blocks.registerOreBlock("benitoite_ore", DyeColor.LIGHT_BLUE);
        public static final RegistryObject<LiquidBlock> STEAM = BLOCKS.register("steam", () -> new LiquidBlock(Fluids.STEAM_SOURCE, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283864_).m_280170_().m_278166_(PushReaction.DESTROY).m_278788_().m_60910_().m_60953_($ -> 6).m_60978_(100.0f).m_222994_()));
        public static final RegistryObject<ReactantFluidBlock> YELLORIUM_FLUID = Blocks.registerReactantFluidBlock(Reactants.Yellorium, Fluids.YELLORIUM_SOURCE);
        public static final RegistryObject<ReactantFluidBlock> CYANITE_FLUID = Blocks.registerReactantFluidBlock(Reactants.Cyanite, Fluids.CYANITE_SOURCE);
        public static final RegistryObject<ReactantFluidBlock> BLUTONIUM_FLUID = Blocks.registerReactantFluidBlock(Reactants.Blutonium, Fluids.BLUTONIUM_SOURCE);
        public static final RegistryObject<ReactantFluidBlock> MAGENTITE_FLUID = Blocks.registerReactantFluidBlock(Reactants.Magentite, Fluids.MAGENTITE_SOURCE);
        public static final RegistryObject<ReactantFluidBlock> VERDERIUM_FLUID = Blocks.registerReactantFluidBlock(Reactants.Verderium, Fluids.VERDERIUM_SOURCE);
        public static final RegistryObject<ReactantFluidBlock> ROSSINITE_FLUID = Blocks.registerReactantFluidBlock(Reactants.Rossinite, Fluids.ROSSINITE_SOURCE);
        public static final RegistryObject<LiquidBlock> CRYOMISI_FLUID = Blocks.registerModeratorLiquidBlock("cryomisi_fluid", Fluids.CRYOMISI_SOURCE);
        public static final RegistryObject<LiquidBlock> TANGERIUM_FLUID = Blocks.registerModeratorLiquidBlock("tangerium_fluid", Fluids.TANGERIUM_SOURCE);
        public static final RegistryObject<LiquidBlock> REDFRIGIUM_FLUID = Blocks.registerModeratorLiquidBlock("redfrigium_fluid", Fluids.REDFRIGIUM_SOURCE);
        public static final RegistryObject<MultiblockPartBlock<MultiblockReactor, ReactorPartType>> REACTOR_CASING_BASIC = Blocks.registerReactorBlock("basic_reactorcasing", ReactorVariant.Basic, ReactorPartType.Casing);
        public static final RegistryObject<GlassBlock<MultiblockReactor, ReactorPartType>> REACTOR_GLASS_BASIC = Blocks.registerReactorBlock("basic_reactorglass", ReactorVariant.Basic, ReactorPartType.Glass);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReactor, ReactorPartType>> REACTOR_CONTROLLER_BASIC = Blocks.registerReactorBlock("basic_reactorcontroller", ReactorVariant.Basic, ReactorPartType.Controller);
        public static final RegistryObject<ReactorFuelRodBlock> REACTOR_FUELROD_BASIC = Blocks.registerReactorBlock("basic_reactorfuelrod", ReactorVariant.Basic, ReactorPartType.FuelRod);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReactor, ReactorPartType>> REACTOR_CONTROLROD_BASIC = Blocks.registerReactorBlock("basic_reactorcontrolrod", ReactorVariant.Basic, ReactorPartType.ControlRod);
        public static final RegistryObject<IOPortBlock<MultiblockReactor, ReactorPartType>> REACTOR_SOLID_ACCESSPORT_BASIC = Blocks.registerReactorBlock("basic_reactorsolidaccessport", ReactorVariant.Basic, ReactorPartType.SolidAccessPort);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReactor, ReactorPartType>> REACTOR_POWERTAP_FE_ACTIVE_BASIC = Blocks.registerReactorBlock("basic_reactorpowertapfe_active", ReactorVariant.Basic, ReactorPartType.ActivePowerTapFE);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReactor, ReactorPartType>> REACTOR_POWERTAP_FE_PASSIVE_BASIC = Blocks.registerReactorBlock("basic_reactorpowertapfe_passive", ReactorVariant.Basic, ReactorPartType.PassivePowerTapFE);
        public static final RegistryObject<ReactorRedstonePortBlock> REACTOR_REDSTONEPORT_BASIC = Blocks.registerReactorBlock("basic_reactorredstoneport", ReactorVariant.Basic, ReactorPartType.RedstonePort);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReactor, ReactorPartType>> REACTOR_CHARGINGPORT_FE_BASIC = Blocks.registerReactorBlock("basic_reactorchargingportfe", ReactorVariant.Basic, ReactorPartType.ChargingPortFE);
        public static final RegistryObject<MultiblockPartBlock<MultiblockReactor, ReactorPartType>> REACTOR_CASING_REINFORCED = Blocks.registerReactorBlock("reinforced_reactorcasing", ReactorVariant.Reinforced, ReactorPartType.Casing);
        public static final RegistryObject<GlassBlock<MultiblockReactor, ReactorPartType>> REACTOR_GLASS_REINFORCED = Blocks.registerReactorBlock("reinforced_reactorglass", ReactorVariant.Reinforced, ReactorPartType.Glass);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReactor, ReactorPartType>> REACTOR_CONTROLLER_REINFORCED = Blocks.registerReactorBlock("reinforced_reactorcontroller", ReactorVariant.Reinforced, ReactorPartType.Controller);
        public static final RegistryObject<ReactorFuelRodBlock> REACTOR_FUELROD_REINFORCED = Blocks.registerReactorBlock("reinforced_reactorfuelrod", ReactorVariant.Reinforced, ReactorPartType.FuelRod);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReactor, ReactorPartType>> REACTOR_CONTROLROD_REINFORCED = Blocks.registerReactorBlock("reinforced_reactorcontrolrod", ReactorVariant.Reinforced, ReactorPartType.ControlRod);
        public static final RegistryObject<IOPortBlock<MultiblockReactor, ReactorPartType>> REACTOR_SOLID_ACCESSPORT_REINFORCED = Blocks.registerReactorBlock("reinforced_reactorsolidaccessport", ReactorVariant.Reinforced, ReactorPartType.SolidAccessPort);
        public static final RegistryObject<IOPortBlock<MultiblockReactor, ReactorPartType>> REACTOR_FLUID_ACCESSPORT_REINFORCED = Blocks.registerReactorBlock("reinforced_reactorfluidaccessport", ReactorVariant.Reinforced, ReactorPartType.FluidAccessPort);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReactor, ReactorPartType>> REACTOR_POWERTAP_FE_ACTIVE_REINFORCED = Blocks.registerReactorBlock("reinforced_reactorpowertapfe_active", ReactorVariant.Reinforced, ReactorPartType.ActivePowerTapFE);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReactor, ReactorPartType>> REACTOR_POWERTAP_FE_PASSIVE_REINFORCED = Blocks.registerReactorBlock("reinforced_reactorpowertapfe_passive", ReactorVariant.Reinforced, ReactorPartType.PassivePowerTapFE);
        public static final RegistryObject<IOPortBlock<MultiblockReactor, ReactorPartType>> REACTOR_FLUIDTPORT_FORGE_ACTIVE_REINFORCED = Blocks.registerReactorBlock("reinforced_reactorfluidport_forge_active", ReactorVariant.Reinforced, ReactorPartType.ActiveFluidPortForge);
        public static final RegistryObject<IOPortBlock<MultiblockReactor, ReactorPartType>> REACTOR_FLUIDPORT_FORGE_PASSIVE_REINFORCED = Blocks.registerReactorBlock("reinforced_reactorfluidport_forge_passive", ReactorVariant.Reinforced, ReactorPartType.PassiveFluidPortForge);
        public static final RegistryObject<IOPortBlock<MultiblockReactor, ReactorPartType>> REACTOR_FLUIDPORT_MEKANISM_PASSIVE_REINFORCED = Blocks.registerReactorBlock("reinforced_reactorfluidport_mekanism_passive", ReactorVariant.Reinforced, ReactorPartType.PassiveFluidPortMekanism);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReactor, ReactorPartType>> REACTOR_CREATIVE_WATER_GENERATOR_REINFORCED = Blocks.registerReactorBlock("reinforced_reactorcreativewatergenerator", ReactorVariant.Reinforced, ReactorPartType.CreativeWaterGenerator);
        public static final RegistryObject<ReactorRedstonePortBlock> REACTOR_REDSTONEPORT_REINFORCED = Blocks.registerReactorBlock("reinforced_reactorredstoneport", ReactorVariant.Reinforced, ReactorPartType.RedstonePort);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReactor, ReactorPartType>> REACTOR_COMPUTERPORT_REINFORCED = Blocks.registerReactorBlock("reinforced_reactorcomputerport", ReactorVariant.Reinforced, ReactorPartType.ComputerPort);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReactor, ReactorPartType>> REACTOR_CHARGINGPORT_FE_REINFORCED = Blocks.registerReactorBlock("reinforced_reactorchargingportfe", ReactorVariant.Reinforced, ReactorPartType.ChargingPortFE);
        public static final RegistryObject<MultiblockPartBlock<MultiblockTurbine, TurbinePartType>> TURBINE_CASING_BASIC = Blocks.registerTurbineBlock("basic_turbinecasing", TurbineVariant.Basic, TurbinePartType.Casing);
        public static final RegistryObject<GlassBlock<MultiblockTurbine, TurbinePartType>> TURBINE_GLASS_BASIC = Blocks.registerTurbineBlock("basic_turbineglass", TurbineVariant.Basic, TurbinePartType.Glass);
        public static final RegistryObject<GenericDeviceBlock<MultiblockTurbine, TurbinePartType>> TURBINE_CONTROLLER_BASIC = Blocks.registerTurbineBlock("basic_turbinecontroller", TurbineVariant.Basic, TurbinePartType.Controller);
        public static final RegistryObject<TurbineRotorBearingBlock> TURBINE_ROTORBEARING_BASIC = Blocks.registerTurbineBlock("basic_turbinerotorbearing", TurbineVariant.Basic, TurbinePartType.RotorBearing);
        public static final RegistryObject<GenericDeviceBlock<MultiblockTurbine, TurbinePartType>> TURBINE_ROTORSHAFT_BASIC = Blocks.registerTurbineBlock("basic_turbinerotorshaft", TurbineVariant.Basic, TurbinePartType.RotorShaft);
        public static final RegistryObject<GenericDeviceBlock<MultiblockTurbine, TurbinePartType>> TURBINE_ROTORBLADE_BASIC = Blocks.registerTurbineBlock("basic_turbinerotorblade", TurbineVariant.Basic, TurbinePartType.RotorBlade);
        public static final RegistryObject<GenericDeviceBlock<MultiblockTurbine, TurbinePartType>> TURBINE_POWERTAP_FE_ACTIVE_BASIC = Blocks.registerTurbineBlock("basic_turbinepowertapfe_active", TurbineVariant.Basic, TurbinePartType.ActivePowerTapFE);
        public static final RegistryObject<GenericDeviceBlock<MultiblockTurbine, TurbinePartType>> TURBINE_POWERTAP_FE_PASSIVE_BASIC = Blocks.registerTurbineBlock("basic_turbinepowertapfe_passive", TurbineVariant.Basic, TurbinePartType.PassivePowerTapFE);
        public static final RegistryObject<IOPortBlock<MultiblockTurbine, TurbinePartType>> TURBINE_FLUIDPORT_FORGE_ACTIVE_BASIC = Blocks.registerTurbineBlock("basic_turbinefluidport_forge_active", TurbineVariant.Basic, TurbinePartType.ActiveFluidPortForge);
        public static final RegistryObject<IOPortBlock<MultiblockTurbine, TurbinePartType>> TURBINE_FLUIDPORT_FORGE_PASSIVE_BASIC = Blocks.registerTurbineBlock("basic_turbinefluidport_forge_passive", TurbineVariant.Basic, TurbinePartType.PassiveFluidPortForge);
        public static final RegistryObject<GenericDeviceBlock<MultiblockTurbine, TurbinePartType>> TURBINE_CREATIVE_STEAM_GENERATOR_BASIC = Blocks.registerTurbineBlock("basic_turbinecreativesteamgenerator", TurbineVariant.Basic, TurbinePartType.CreativeSteamGenerator);
        public static final RegistryObject<TurbineRedstonePortBlock> TURBINE_REDSTONEPORT_BASIC = Blocks.registerTurbineBlock("basic_turbineredstoneport", TurbineVariant.Basic, TurbinePartType.RedstonePort);
        public static final RegistryObject<GenericDeviceBlock<MultiblockTurbine, TurbinePartType>> TURBINE_CHARGINGPORT_FE_BASIC = Blocks.registerTurbineBlock("basic_turbinechargingportfe", TurbineVariant.Basic, TurbinePartType.ChargingPortFE);
        public static final RegistryObject<MultiblockPartBlock<MultiblockTurbine, TurbinePartType>> TURBINE_CASING_REINFORCED = Blocks.registerTurbineBlock("reinforced_turbinecasing", TurbineVariant.Reinforced, TurbinePartType.Casing);
        public static final RegistryObject<GlassBlock<MultiblockTurbine, TurbinePartType>> TURBINE_GLASS_REINFORCED = Blocks.registerTurbineBlock("reinforced_turbineglass", TurbineVariant.Reinforced, TurbinePartType.Glass);
        public static final RegistryObject<GenericDeviceBlock<MultiblockTurbine, TurbinePartType>> TURBINE_CONTROLLER_REINFORCED = Blocks.registerTurbineBlock("reinforced_turbinecontroller", TurbineVariant.Reinforced, TurbinePartType.Controller);
        public static final RegistryObject<TurbineRotorBearingBlock> TURBINE_ROTORBEARING_REINFORCED = Blocks.registerTurbineBlock("reinforced_turbinerotorbearing", TurbineVariant.Reinforced, TurbinePartType.RotorBearing);
        public static final RegistryObject<GenericDeviceBlock<MultiblockTurbine, TurbinePartType>> TURBINE_ROTORSHAFT_REINFORCED = Blocks.registerTurbineBlock("reinforced_turbinerotorshaft", TurbineVariant.Reinforced, TurbinePartType.RotorShaft);
        public static final RegistryObject<GenericDeviceBlock<MultiblockTurbine, TurbinePartType>> TURBINE_ROTORBLADE_REINFORCED = Blocks.registerTurbineBlock("reinforced_turbinerotorblade", TurbineVariant.Reinforced, TurbinePartType.RotorBlade);
        public static final RegistryObject<GenericDeviceBlock<MultiblockTurbine, TurbinePartType>> TURBINE_POWERTAP_FE_ACTIVE_REINFORCED = Blocks.registerTurbineBlock("reinforced_turbinepowertapfe_active", TurbineVariant.Reinforced, TurbinePartType.ActivePowerTapFE);
        public static final RegistryObject<GenericDeviceBlock<MultiblockTurbine, TurbinePartType>> TURBINE_POWERTAP_FE_PASSIVE_REINFORCED = Blocks.registerTurbineBlock("reinforced_turbinepowertapfe_passive", TurbineVariant.Reinforced, TurbinePartType.PassivePowerTapFE);
        public static final RegistryObject<IOPortBlock<MultiblockTurbine, TurbinePartType>> TURBINE_FLUIDPORT_FORGE_ACTIVE_REINFORCED = Blocks.registerTurbineBlock("reinforced_turbinefluidport_forge_active", TurbineVariant.Reinforced, TurbinePartType.ActiveFluidPortForge);
        public static final RegistryObject<IOPortBlock<MultiblockTurbine, TurbinePartType>> TURBINE_FLUIDPORT_FORGE_PASSIVE_REINFORCED = Blocks.registerTurbineBlock("reinforced_turbinefluidport_forge_passive", TurbineVariant.Reinforced, TurbinePartType.PassiveFluidPortForge);
        public static final RegistryObject<GenericDeviceBlock<MultiblockTurbine, TurbinePartType>> TURBINE_CREATIVE_STEAM_GENERATOR_REINFORCED = Blocks.registerTurbineBlock("reinforced_turbinecreativesteamgenerator", TurbineVariant.Reinforced, TurbinePartType.CreativeSteamGenerator);
        public static final RegistryObject<TurbineRedstonePortBlock> TURBINE_REDSTONEPORT_REINFORCED = Blocks.registerTurbineBlock("reinforced_turbineredstoneport", TurbineVariant.Reinforced, TurbinePartType.RedstonePort);
        public static final RegistryObject<GenericDeviceBlock<MultiblockTurbine, TurbinePartType>> TURBINE_COMPUTERPORT_REINFORCED = Blocks.registerTurbineBlock("reinforced_turbinecomputerport", TurbineVariant.Reinforced, TurbinePartType.ComputerPort);
        public static final RegistryObject<GenericDeviceBlock<MultiblockTurbine, TurbinePartType>> TURBINE_CHARGINGPORT_FE_REINFORCED = Blocks.registerTurbineBlock("reinforced_turbinechargingportfe", TurbineVariant.Reinforced, TurbinePartType.ChargingPortFE);
        public static final RegistryObject<MultiblockPartBlock<MultiblockReprocessor, ReprocessorPartType>> REPROCESSOR_CASING = Blocks.registerReprocessorBlock("reprocessorcasing", ReprocessorPartType.Casing);
        public static final RegistryObject<GlassBlock<MultiblockReprocessor, ReprocessorPartType>> REPROCESSOR_GLASS = Blocks.registerReprocessorBlock("reprocessorglass", ReprocessorPartType.Glass);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReprocessor, ReprocessorPartType>> REPROCESSOR_CONTROLLER = Blocks.registerReprocessorBlock("reprocessorcontroller", ReprocessorPartType.Controller);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReprocessor, ReprocessorPartType>> REPROCESSOR_WASTEINJECTOR = Blocks.registerReprocessorBlock("reprocessorwasteinjector", ReprocessorPartType.WasteInjector);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReprocessor, ReprocessorPartType>> REPROCESSOR_FLUIDINJECTOR = Blocks.registerReprocessorBlock("reprocessorfluidinjector", ReprocessorPartType.FluidInjector);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReprocessor, ReprocessorPartType>> REPROCESSOR_OUTPUTPORT = Blocks.registerReprocessorBlock("reprocessoroutputport", ReprocessorPartType.OutputPort);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReprocessor, ReprocessorPartType>> REPROCESSOR_POWERPORT = Blocks.registerReprocessorBlock("reprocessorpowerport", ReprocessorPartType.PowerPort);
        public static final RegistryObject<GenericDeviceBlock<MultiblockReprocessor, ReprocessorPartType>> REPROCESSOR_COLLECTOR = Blocks.registerReprocessorBlock("reprocessorcollector", ReprocessorPartType.Collector);
        public static final RegistryObject<MultiblockPartBlock<MultiblockFluidizer, FluidizerPartType>> FLUIDIZER_CASING = Blocks.registerFluidizerBlock("fluidizercasing", FluidizerPartType.Casing);
        public static final RegistryObject<GlassBlock<MultiblockFluidizer, FluidizerPartType>> FLUIDIZER_GLASS = Blocks.registerFluidizerBlock("fluidizerglass", FluidizerPartType.Glass);
        public static final RegistryObject<GenericDeviceBlock<MultiblockFluidizer, FluidizerPartType>> FLUIDIZER_CONTROLLER = Blocks.registerFluidizerBlock("fluidizercontroller", FluidizerPartType.Controller);
        public static final RegistryObject<GenericDeviceBlock<MultiblockFluidizer, FluidizerPartType>> FLUIDIZER_SOLIDINJECTOR = Blocks.registerFluidizerBlock("fluidizersolidinjector", FluidizerPartType.SolidInjector);
        public static final RegistryObject<GenericDeviceBlock<MultiblockFluidizer, FluidizerPartType>> FLUIDIZER_FLUIDINJECTOR = Blocks.registerFluidizerBlock("fluidizerfluidinjector", FluidizerPartType.FluidInjector);
        public static final RegistryObject<GenericDeviceBlock<MultiblockFluidizer, FluidizerPartType>> FLUIDIZER_OUTPUTPORT = Blocks.registerFluidizerBlock("fluidizeroutputport", FluidizerPartType.OutputPort);
        public static final RegistryObject<GenericDeviceBlock<MultiblockFluidizer, FluidizerPartType>> FLUIDIZER_POWERPORT = Blocks.registerFluidizerBlock("fluidizerpowerport", FluidizerPartType.PowerPort);

        static void initialize(IEventBus bus) {
            BLOCKS.register(bus);
        }

        public static Collection<RegistryObject<Block>> getAll() {
            return BLOCKS.getEntries();
        }

        private static RegistryObject<ModBlock> registerMetalBlock(String name, DyeColor color) {
            return BLOCKS.register(name, () -> new ModBlock(BlockBehaviour.Properties.m_284310_().m_284268_(color).m_60918_(SoundType.f_56743_)));
        }

        private static RegistryObject<ModBlock> registerOreBlock(String name, DyeColor color) {
            return Blocks.registerOreBlock(name, color, 3, 5);
        }

        private static RegistryObject<ModBlock> registerOreBlock(String name, DyeColor color, int minDroppedXP, int maxDroppedXP) {
            return BLOCKS.register(name, () -> new ModOreBlock(BlockBehaviour.Properties.m_284310_().m_284268_(color).m_60918_(SoundType.f_56742_).m_60999_().m_280658_(NoteBlockInstrument.BASEDRUM).m_60913_(3.0f, 3.0f), minDroppedXP, maxDroppedXP));
        }

        private static <T extends MultiblockPartBlock<MultiblockReactor, ReactorPartType>> RegistryObject<T> registerReactorBlock(String name, ReactorVariant variant, ReactorPartType partType) {
            return BLOCKS.register(name, () -> partType.createBlock((IMultiblockVariant)variant));
        }

        private static <T extends MultiblockPartBlock<MultiblockTurbine, TurbinePartType>> RegistryObject<T> registerTurbineBlock(String name, TurbineVariant variant, TurbinePartType partType) {
            return BLOCKS.register(name, () -> partType.createBlock((IMultiblockVariant)variant));
        }

        private static <T extends MultiblockPartBlock<MultiblockReprocessor, ReprocessorPartType>> RegistryObject<T> registerReprocessorBlock(String name, ReprocessorPartType partType) {
            return BLOCKS.register(name, () -> partType.createBlock());
        }

        private static <T extends MultiblockPartBlock<MultiblockFluidizer, FluidizerPartType>> RegistryObject<T> registerFluidizerBlock(String name, FluidizerPartType partType) {
            return BLOCKS.register(name, () -> partType.createBlock());
        }

        private static RegistryObject<LiquidBlock> registerModeratorLiquidBlock(String name, Supplier<FlowingFluid> source) {
            return BLOCKS.register(name, () -> new LiquidBlock(source, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283864_).m_280170_().m_278166_(PushReaction.DESTROY).m_278788_().m_60910_().m_60978_(100.0f).m_222994_()));
        }

        private static RegistryObject<ReactantFluidBlock> registerReactantFluidBlock(Reactants reactant, Supplier<? extends FlowingFluid> fluid) {
            return BLOCKS.register(reactant.getFluidName(), () -> new ReactantFluidBlock(reactant, fluid));
        }
    }

    public static final class Items {
        private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"bigreactors");
        public static final RegistryObject<ModItem> YELLORIUM_INGOT = Items.registerItemGeneric(Reactants.Yellorium.getIngotName());
        public static final RegistryObject<ModItem> CYANITE_INGOT = Items.registerItemGeneric(Reactants.Cyanite.getIngotName());
        public static final RegistryObject<ModItem> GRAPHITE_INGOT = Items.registerItemGeneric("graphite_ingot");
        public static final RegistryObject<ModItem> BLUTONIUM_INGOT = Items.registerItemGeneric(Reactants.Blutonium.getIngotName());
        public static final RegistryObject<ModItem> MAGENTITE_INGOT = Items.registerItemGeneric(Reactants.Magentite.getIngotName());
        public static final RegistryObject<ModItem> LUDICRITE_INGOT = Items.registerItemGeneric("ludicrite_ingot");
        public static final RegistryObject<ModItem> RIDICULITE_INGOT = Items.registerItemGeneric("ridiculite_ingot");
        public static final RegistryObject<ModItem> INANITE_INGOT = Items.registerItemGeneric("inanite_ingot");
        public static final RegistryObject<ModItem> INSANITE_INGOT = Items.registerItemGeneric("insanite_ingot");
        public static final RegistryObject<ModItem> YELLORIUM_NUGGET = Items.registerItemGeneric(Reactants.Yellorium.getNuggetName());
        public static final RegistryObject<ModItem> BLUTONIUM_NUGGET = Items.registerItemGeneric(Reactants.Blutonium.getNuggetName());
        public static final RegistryObject<ModItem> YELLORIUM_DUST = Items.registerItemGeneric(Reactants.Yellorium.getDustName());
        public static final RegistryObject<ModItem> CYANITE_DUST = Items.registerItemGeneric(Reactants.Cyanite.getDustName());
        public static final RegistryObject<ModItem> GRAPHITE_DUST = Items.registerItemGeneric("graphite_dust");
        public static final RegistryObject<ModItem> BLUTONIUM_DUST = Items.registerItemGeneric(Reactants.Blutonium.getDustName());
        public static final RegistryObject<ModItem> MAGENTITE_DUST = Items.registerItemGeneric(Reactants.Magentite.getDustName());
        public static final RegistryObject<ModItem> LUDICRITE_DUST = Items.registerItemGeneric("ludicrite_dust");
        public static final RegistryObject<ModItem> RIDICULITE_DUST = Items.registerItemGeneric("ridiculite_dust");
        public static final RegistryObject<ModItem> INANITE_DUST = Items.registerItemGeneric("inanite_dust");
        public static final RegistryObject<ModItem> INSANITE_DUST = Items.registerItemGeneric("insanite_dust");
        public static final RegistryObject<BlockItem> YELLORIUM_BLOCK = Items.registerItemBlock(Reactants.Yellorium.getBlockName(), () -> Blocks.YELLORIUM_BLOCK);
        public static final RegistryObject<BlockItem> CYANITE_BLOCK = Items.registerItemBlock(Reactants.Cyanite.getBlockName(), () -> Blocks.CYANITE_BLOCK);
        public static final RegistryObject<BlockItem> GRAPHITE_BLOCK = Items.registerItemBlock("graphite_block", () -> Blocks.GRAPHITE_BLOCK);
        public static final RegistryObject<BlockItem> BLUTONIUM_BLOCK = Items.registerItemBlock(Reactants.Blutonium.getBlockName(), () -> Blocks.BLUTONIUM_BLOCK);
        public static final RegistryObject<BlockItem> MAGENTITE_BLOCK = Items.registerItemBlock(Reactants.Magentite.getBlockName(), () -> Blocks.MAGENTITE_BLOCK);
        public static final RegistryObject<BlockItem> LUDICRITE_BLOCK = Items.registerItemBlock("ludicrite_block", () -> Blocks.LUDICRITE_BLOCK);
        public static final RegistryObject<BlockItem> RIDICULITE_BLOCK = Items.registerItemBlock("ridiculite_block", () -> Blocks.RIDICULITE_BLOCK);
        public static final RegistryObject<BlockItem> INANITE_BLOCK = Items.registerItemBlock("inanite_block", () -> Blocks.INANITE_BLOCK);
        public static final RegistryObject<BlockItem> INSANITE_BLOCK = Items.registerItemBlock("insanite_block", () -> Blocks.INSANITE_BLOCK);
        public static final RegistryObject<ModItem> ANGLESITE_CRYSTAL = Items.registerItemGeneric("anglesite_crystal");
        public static final RegistryObject<ModItem> BENITOITE_CRYSTAL = Items.registerItemGeneric("benitoite_crystal");
        public static final RegistryObject<BlockItem> YELLORITE_ORE_BLOCK = Items.registerItemBlock("yellorite_ore", () -> Blocks.YELLORITE_ORE_BLOCK);
        public static final RegistryObject<BlockItem> ANGLESITE_ORE_BLOCK = Items.registerItemBlock("anglesite_ore", () -> Blocks.ANGLESITE_ORE_BLOCK);
        public static final RegistryObject<BlockItem> BENITOITE_ORE_BLOCK = Items.registerItemBlock("benitoite_ore", () -> Blocks.BENITOITE_ORE_BLOCK);
        public static final RegistryObject<BucketItem> STEAM_BUCKET = Items.registerBucket("steam_bucket", Fluids.STEAM_SOURCE);
        public static final RegistryObject<BucketItem> YELLORIUM_BUCKET = Items.registerBucket(Reactants.Yellorium.getBucketName(), Fluids.YELLORIUM_SOURCE);
        public static final RegistryObject<BucketItem> CYANITE_BUCKET = Items.registerBucket(Reactants.Cyanite.getBucketName(), Fluids.CYANITE_SOURCE);
        public static final RegistryObject<BucketItem> BLUTONIUM_BUCKET = Items.registerBucket(Reactants.Blutonium.getBucketName(), Fluids.BLUTONIUM_SOURCE);
        public static final RegistryObject<BucketItem> MAGENTITE_BUCKET = Items.registerBucket(Reactants.Magentite.getBucketName(), Fluids.MAGENTITE_SOURCE);
        public static final RegistryObject<BucketItem> VERDERIUM_BUCKET = Items.registerBucket(Reactants.Verderium.getBucketName(), Fluids.VERDERIUM_SOURCE);
        public static final RegistryObject<BucketItem> ROSSINITE_BUCKET = Items.registerBucket(Reactants.Rossinite.getBucketName(), Fluids.ROSSINITE_SOURCE);
        public static final RegistryObject<BucketItem> CRYOMISI_BUCKET = Items.registerBucket("cryomisi_bucket", Fluids.CRYOMISI_SOURCE);
        public static final RegistryObject<BucketItem> TANGERIUM_BUCKET = Items.registerBucket("tangerium_bucket", Fluids.TANGERIUM_SOURCE);
        public static final RegistryObject<BucketItem> REDFRIGIUM_BUCKET = Items.registerBucket("redfrigium_bucket", Fluids.REDFRIGIUM_SOURCE);
        public static final RegistryObject<BlockItem> REACTOR_CASING_BASIC = Items.registerItemBlock("basic_reactorcasing", () -> () -> Blocks.REACTOR_CASING_BASIC.get());
        public static final RegistryObject<BlockItem> REACTOR_GLASS_BASIC = Items.registerItemBlock("basic_reactorglass", () -> () -> Blocks.REACTOR_GLASS_BASIC.get());
        public static final RegistryObject<BlockItem> REACTOR_CONTROLLER_BASIC = Items.registerItemBlock("basic_reactorcontroller", () -> () -> Blocks.REACTOR_CONTROLLER_BASIC.get());
        public static final RegistryObject<BlockItem> REACTOR_FUELROD_BASIC = Items.registerItemBlock("basic_reactorfuelrod", () -> () -> Blocks.REACTOR_FUELROD_BASIC.get());
        public static final RegistryObject<BlockItem> REACTOR_CONTROLROD_BASIC = Items.registerItemBlock("basic_reactorcontrolrod", () -> () -> Blocks.REACTOR_CONTROLROD_BASIC.get());
        public static final RegistryObject<BlockItem> REACTOR_SOLID_ACCESSPORT_BASIC = Items.registerItemBlock("basic_reactorsolidaccessport", () -> () -> Blocks.REACTOR_SOLID_ACCESSPORT_BASIC.get());
        public static final RegistryObject<BlockItem> REACTOR_POWERTAP_FE_ACTIVE_BASIC = Items.registerItemBlock("basic_reactorpowertapfe_active", () -> () -> Blocks.REACTOR_POWERTAP_FE_ACTIVE_BASIC.get());
        public static final RegistryObject<BlockItem> REACTOR_POWERTAP_FE_PASSIVE_BASIC = Items.registerItemBlock("basic_reactorpowertapfe_passive", () -> () -> Blocks.REACTOR_POWERTAP_FE_PASSIVE_BASIC.get());
        public static final RegistryObject<BlockItem> REACTOR_REDSTONEPORT_BASIC = Items.registerItemBlock("basic_reactorredstoneport", () -> () -> Blocks.REACTOR_REDSTONEPORT_BASIC.get());
        public static final RegistryObject<BlockItem> REACTOR_CHARGINGPORT_FE_BASIC = Items.registerItemBlock("basic_reactorchargingportfe", () -> () -> Blocks.REACTOR_CHARGINGPORT_FE_BASIC.get());
        public static final RegistryObject<BlockItem> REACTOR_CASING_REINFORCED = Items.registerItemBlock("reinforced_reactorcasing", () -> () -> Blocks.REACTOR_CASING_REINFORCED.get());
        public static final RegistryObject<BlockItem> REACTOR_GLASS_REINFORCED = Items.registerItemBlock("reinforced_reactorglass", () -> () -> Blocks.REACTOR_GLASS_REINFORCED.get());
        public static final RegistryObject<BlockItem> REACTOR_CONTROLLER_REINFORCED = Items.registerItemBlock("reinforced_reactorcontroller", () -> () -> Blocks.REACTOR_CONTROLLER_REINFORCED.get());
        public static final RegistryObject<BlockItem> REACTOR_FUELROD_REINFORCED = Items.registerItemBlock("reinforced_reactorfuelrod", () -> () -> Blocks.REACTOR_FUELROD_REINFORCED.get());
        public static final RegistryObject<BlockItem> REACTOR_CONTROLROD_REINFORCED = Items.registerItemBlock("reinforced_reactorcontrolrod", () -> () -> Blocks.REACTOR_CONTROLROD_REINFORCED.get());
        public static final RegistryObject<BlockItem> REACTOR_SOLID_ACCESSPORT_REINFORCED = Items.registerItemBlock("reinforced_reactorsolidaccessport", () -> () -> Blocks.REACTOR_SOLID_ACCESSPORT_REINFORCED.get());
        public static final RegistryObject<BlockItem> REACTOR_FLUID_ACCESSPORT_REINFORCED = Items.registerItemBlock("reinforced_reactorfluidaccessport", () -> () -> Blocks.REACTOR_FLUID_ACCESSPORT_REINFORCED.get());
        public static final RegistryObject<BlockItem> REACTOR_POWERTAP_FE_ACTIVE_REINFORCED = Items.registerItemBlock("reinforced_reactorpowertapfe_active", () -> () -> Blocks.REACTOR_POWERTAP_FE_ACTIVE_REINFORCED.get());
        public static final RegistryObject<BlockItem> REACTOR_POWERTAP_FE_PASSIVE_REINFORCED = Items.registerItemBlock("reinforced_reactorpowertapfe_passive", () -> () -> Blocks.REACTOR_POWERTAP_FE_PASSIVE_REINFORCED.get());
        public static final RegistryObject<BlockItem> REACTOR_COMPUTERPORT_REINFORCED = Items.registerItemBlock("reinforced_reactorcomputerport", () -> () -> Blocks.REACTOR_COMPUTERPORT_REINFORCED.get());
        public static final RegistryObject<BlockItem> REACTOR_REDSTONEPORT_REINFORCED = Items.registerItemBlock("reinforced_reactorredstoneport", () -> () -> Blocks.REACTOR_REDSTONEPORT_REINFORCED.get());
        public static final RegistryObject<BlockItem> REACTOR_FLUIDPORT_FORGE_ACTIVE_REINFORCED = Items.registerItemBlock("reinforced_reactorfluidport_forge_active", () -> () -> Blocks.REACTOR_FLUIDTPORT_FORGE_ACTIVE_REINFORCED.get());
        public static final RegistryObject<BlockItem> REACTOR_FLUIDPORT_FORGE_PASSIVE_REINFORCED = Items.registerItemBlock("reinforced_reactorfluidport_forge_passive", () -> () -> Blocks.REACTOR_FLUIDPORT_FORGE_PASSIVE_REINFORCED.get());
        public static final RegistryObject<BlockItem> REACTOR_FLUIDPORT_MEKANISM_PASSIVE_REINFORCED = Items.registerItemBlock("reinforced_reactorfluidport_mekanism_passive", () -> () -> Blocks.REACTOR_FLUIDPORT_MEKANISM_PASSIVE_REINFORCED.get());
        public static final RegistryObject<BlockItem> REACTOR_CREATIVE_WATER_GENERATOR_REINFORCED = Items.registerItemBlock("reinforced_reactorcreativewatergenerator", () -> () -> Blocks.REACTOR_CREATIVE_WATER_GENERATOR_REINFORCED.get());
        public static final RegistryObject<BlockItem> REACTOR_CHARGINGPORT_FE_REINFORCED = Items.registerItemBlock("reinforced_reactorchargingportfe", () -> () -> Blocks.REACTOR_CHARGINGPORT_FE_REINFORCED.get());
        public static final RegistryObject<BlockItem> TURBINE_CASING_BASIC = Items.registerItemBlock("basic_turbinecasing", () -> () -> Blocks.TURBINE_CASING_BASIC.get());
        public static final RegistryObject<BlockItem> TURBINE_GLASS_BASIC = Items.registerItemBlock("basic_turbineglass", () -> () -> Blocks.TURBINE_GLASS_BASIC.get());
        public static final RegistryObject<BlockItem> TURBINE_CONTROLLER_BASIC = Items.registerItemBlock("basic_turbinecontroller", () -> () -> Blocks.TURBINE_CONTROLLER_BASIC.get());
        public static final RegistryObject<BlockItem> TURBINE_ROTORBEARING_BASIC = Items.registerItemBlock("basic_turbinerotorbearing", () -> () -> Blocks.TURBINE_ROTORBEARING_BASIC.get());
        public static final RegistryObject<BlockItem> TURBINE_ROTORSHAFT_BASIC = Items.registerItemBlock("basic_turbinerotorshaft", () -> () -> Blocks.TURBINE_ROTORSHAFT_BASIC.get());
        public static final RegistryObject<BlockItem> TURBINE_ROTORBLADE_BASIC = Items.registerItemBlock("basic_turbinerotorblade", () -> () -> Blocks.TURBINE_ROTORBLADE_BASIC.get());
        public static final RegistryObject<BlockItem> TURBINE_POWERTAP_FE_ACTIVE_BASIC = Items.registerItemBlock("basic_turbinepowertapfe_active", () -> () -> Blocks.TURBINE_POWERTAP_FE_ACTIVE_BASIC.get());
        public static final RegistryObject<BlockItem> TURBINE_POWERTAP_FE_PASSIVE_BASIC = Items.registerItemBlock("basic_turbinepowertapfe_passive", () -> () -> Blocks.TURBINE_POWERTAP_FE_PASSIVE_BASIC.get());
        public static final RegistryObject<BlockItem> TURBINE_FLUIDPORT_FORGE_ACTIVE_BASIC = Items.registerItemBlock("basic_turbinefluidport_forge_active", () -> () -> Blocks.TURBINE_FLUIDPORT_FORGE_ACTIVE_BASIC.get());
        public static final RegistryObject<BlockItem> TURBINE_FLUIDPORT_FORGE_PASSIVE_BASIC = Items.registerItemBlock("basic_turbinefluidport_forge_passive", () -> () -> Blocks.TURBINE_FLUIDPORT_FORGE_PASSIVE_BASIC.get());
        public static final RegistryObject<BlockItem> TURBINE_REDSTONEPORT_BASIC = Items.registerItemBlock("basic_turbineredstoneport", () -> () -> Blocks.TURBINE_REDSTONEPORT_BASIC.get());
        public static final RegistryObject<BlockItem> TURBINE_CREATIVE_STEAM_GENERATOR_BASIC = Items.registerItemBlock("basic_turbinecreativesteamgenerator", () -> () -> Blocks.TURBINE_CREATIVE_STEAM_GENERATOR_BASIC.get());
        public static final RegistryObject<BlockItem> TURBINE_CHARGINGPORT_FE_BASIC = Items.registerItemBlock("basic_turbinechargingportfe", () -> () -> Blocks.TURBINE_CHARGINGPORT_FE_BASIC.get());
        public static final RegistryObject<BlockItem> TURBINE_CASING_REINFORCED = Items.registerItemBlock("reinforced_turbinecasing", () -> () -> Blocks.TURBINE_CASING_REINFORCED.get());
        public static final RegistryObject<BlockItem> TURBINE_GLASS_REINFORCED = Items.registerItemBlock("reinforced_turbineglass", () -> () -> Blocks.TURBINE_GLASS_REINFORCED.get());
        public static final RegistryObject<BlockItem> TURBINE_CONTROLLER_REINFORCED = Items.registerItemBlock("reinforced_turbinecontroller", () -> () -> Blocks.TURBINE_CONTROLLER_REINFORCED.get());
        public static final RegistryObject<BlockItem> TURBINE_ROTORBEARING_REINFORCED = Items.registerItemBlock("reinforced_turbinerotorbearing", () -> () -> Blocks.TURBINE_ROTORBEARING_REINFORCED.get());
        public static final RegistryObject<BlockItem> TURBINE_ROTORSHAFT_REINFORCED = Items.registerItemBlock("reinforced_turbinerotorshaft", () -> () -> Blocks.TURBINE_ROTORSHAFT_REINFORCED.get());
        public static final RegistryObject<BlockItem> TURBINE_ROTORBLADE_REINFORCED = Items.registerItemBlock("reinforced_turbinerotorblade", () -> () -> Blocks.TURBINE_ROTORBLADE_REINFORCED.get());
        public static final RegistryObject<BlockItem> TURBINE_POWERTAP_FE_ACTIVE_REINFORCED = Items.registerItemBlock("reinforced_turbinepowertapfe_active", () -> () -> Blocks.TURBINE_POWERTAP_FE_ACTIVE_REINFORCED.get());
        public static final RegistryObject<BlockItem> TURBINE_POWERTAP_FE_PASSIVE_REINFORCED = Items.registerItemBlock("reinforced_turbinepowertapfe_passive", () -> () -> Blocks.TURBINE_POWERTAP_FE_PASSIVE_REINFORCED.get());
        public static final RegistryObject<BlockItem> TURBINE_FLUIDPORT_FORGE_ACTIVE_REINFORCED = Items.registerItemBlock("reinforced_turbinefluidport_forge_active", () -> () -> Blocks.TURBINE_FLUIDPORT_FORGE_ACTIVE_REINFORCED.get());
        public static final RegistryObject<BlockItem> TURBINE_FLUIDPORT_FORGE_PASSIVE_REINFORCED = Items.registerItemBlock("reinforced_turbinefluidport_forge_passive", () -> () -> Blocks.TURBINE_FLUIDPORT_FORGE_PASSIVE_REINFORCED.get());
        public static final RegistryObject<BlockItem> TURBINE_REDSTONEPORT_REINFORCED = Items.registerItemBlock("reinforced_turbineredstoneport", () -> () -> Blocks.TURBINE_REDSTONEPORT_REINFORCED.get());
        public static final RegistryObject<BlockItem> TURBINE_COMPUTERPORT_REINFORCED = Items.registerItemBlock("reinforced_turbinecomputerport", () -> () -> Blocks.TURBINE_COMPUTERPORT_REINFORCED.get());
        public static final RegistryObject<BlockItem> TURBINE_CREATIVE_STEAM_GENERATOR_REINFORCED = Items.registerItemBlock("reinforced_turbinecreativesteamgenerator", () -> () -> Blocks.TURBINE_CREATIVE_STEAM_GENERATOR_REINFORCED.get());
        public static final RegistryObject<BlockItem> TURBINE_CHARGINGPORT_FE_REINFORCED = Items.registerItemBlock("reinforced_turbinechargingportfe", () -> () -> Blocks.TURBINE_CHARGINGPORT_FE_REINFORCED.get());
        public static final RegistryObject<BlockItem> REPROCESSOR_CASING = Items.registerItemBlock("reprocessorcasing", () -> () -> Blocks.REPROCESSOR_CASING.get());
        public static final RegistryObject<BlockItem> REPROCESSOR_GLASS = Items.registerItemBlock("reprocessorglass", () -> () -> Blocks.REPROCESSOR_GLASS.get());
        public static final RegistryObject<BlockItem> REPROCESSOR_CONTROLLER = Items.registerItemBlock("reprocessorcontroller", () -> () -> Blocks.REPROCESSOR_CONTROLLER.get());
        public static final RegistryObject<BlockItem> REPROCESSOR_WASTEINJECTOR = Items.registerItemBlock("reprocessorwasteinjector", () -> () -> Blocks.REPROCESSOR_WASTEINJECTOR.get());
        public static final RegistryObject<BlockItem> REPROCESSOR_FLUIDINJECTOR = Items.registerItemBlock("reprocessorfluidinjector", () -> () -> Blocks.REPROCESSOR_FLUIDINJECTOR.get());
        public static final RegistryObject<BlockItem> REPROCESSOR_OUTPUTPORT = Items.registerItemBlock("reprocessoroutputport", () -> () -> Blocks.REPROCESSOR_OUTPUTPORT.get());
        public static final RegistryObject<BlockItem> REPROCESSOR_POWERPORT = Items.registerItemBlock("reprocessorpowerport", () -> () -> Blocks.REPROCESSOR_POWERPORT.get());
        public static final RegistryObject<BlockItem> REPROCESSOR_COLLECTOR = Items.registerItemBlock("reprocessorcollector", () -> () -> Blocks.REPROCESSOR_COLLECTOR.get());
        public static final RegistryObject<BlockItem> FLUIDIZER_CASING = Items.registerItemBlock("fluidizercasing", () -> () -> Blocks.FLUIDIZER_CASING.get());
        public static final RegistryObject<BlockItem> FLUIDIZER_GLASS = Items.registerItemBlock("fluidizerglass", () -> () -> Blocks.FLUIDIZER_GLASS.get());
        public static final RegistryObject<BlockItem> FLUIDIZER_CONTROLLER = Items.registerItemBlock("fluidizercontroller", () -> () -> Blocks.FLUIDIZER_CONTROLLER.get());
        public static final RegistryObject<BlockItem> FLUIDIZER_SOLIDINJECTOR = Items.registerItemBlock("fluidizersolidinjector", () -> () -> Blocks.FLUIDIZER_SOLIDINJECTOR.get());
        public static final RegistryObject<BlockItem> FLUIDIZER_FLUIDINJECTOR = Items.registerItemBlock("fluidizerfluidinjector", () -> () -> Blocks.FLUIDIZER_FLUIDINJECTOR.get());
        public static final RegistryObject<BlockItem> FLUIDIZER_OUTPUTPORT = Items.registerItemBlock("fluidizeroutputport", () -> () -> Blocks.FLUIDIZER_OUTPUTPORT.get());
        public static final RegistryObject<BlockItem> FLUIDIZER_POWERPORT = Items.registerItemBlock("fluidizerpowerport", () -> () -> Blocks.FLUIDIZER_POWERPORT.get());
        public static final RegistryObject<ModItem> WRENCH = Items.registerItemGeneric("wrench", 1);

        static void initialize(IEventBus bus) {
            ITEMS.register(bus);
        }

        private static RegistryObject<ModItem> registerItemGeneric(String name) {
            return Items.registerItemGeneric(name, 64);
        }

        private static RegistryObject<ModItem> registerItemGeneric(String name, int maxStack) {
            return ITEMS.register(name, () -> new ModItem(new Item.Properties().m_41487_(maxStack)));
        }

        private static RegistryObject<BlockItem> registerItemBlock(String name, Supplier<Supplier<ModBlock>> blockSupplier) {
            return ITEMS.register(name, () -> ((ModBlock)((Supplier)blockSupplier.get()).get()).createBlockItem(new Item.Properties().m_41487_(64)));
        }

        private static RegistryObject<BucketItem> registerBucket(String name, Supplier<? extends Fluid> sourceFluid) {
            return ITEMS.register(name, () -> new BucketItem(sourceFluid, new Item.Properties().m_41495_(net.minecraft.world.item.Items.f_42446_).m_41487_(1)));
        }
    }

    public static final class Fluids {
        private static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"bigreactors");
        private static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"bigreactors");
        public static RegistryObject<FluidType> STEAM_FLUID_TYPE = FLUID_TYPES.register("steam", () -> new FluidType(FluidType.Properties.create().descriptionId("fluid.bigreactors.steam").density(1).lightLevel(6).canDrown(false).canSwim(false).canPushEntity(false).fallDistanceModifier(0.1f).canExtinguish(false).canConvertToSource(false).supportsBoating(false).pathType(BlockPathTypes.WALKABLE).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).canHydrate(false).temperature(100).rarity(Rarity.COMMON)){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept((IClientFluidTypeExtensions)new SimpleFluidTypeRenderProperties(-1, CommonConstants.FLUID_TEXTURE_SOURCE_WATER, CommonConstants.FLUID_TEXTURE_FLOWING_WATER, CommonConstants.FLUID_TEXTURE_OVERLAY_WATER));
            }
        });
        public static final RegistryObject<FlowingFluid> STEAM_SOURCE = Fluids.registerSteam("steam", (NonNullFunction<ForgeFlowingFluid.Properties, FlowingFluid>)((NonNullFunction)ForgeFlowingFluid.Source::new));
        public static final RegistryObject<FlowingFluid> STEAM_FLOWING = Fluids.registerSteam("steam_flowing", (NonNullFunction<ForgeFlowingFluid.Properties, FlowingFluid>)((NonNullFunction)ForgeFlowingFluid.Flowing::new));
        public static RegistryObject<FluidType> YELLORIUM_FLUID_TYPE = Fluids.registerReactantFluidType(Reactants.Yellorium);
        public static final RegistryObject<FlowingFluid> YELLORIUM_SOURCE = FLUIDS.register(Reactants.Yellorium.getFluidSourceName(), () -> new ForgeFlowingFluid.Source(new ForgeFlowingFluid.Properties(YELLORIUM_FLUID_TYPE, YELLORIUM_SOURCE, YELLORIUM_FLOWING).bucket(Items.YELLORIUM_BUCKET).block(Blocks.YELLORIUM_FLUID)));
        public static final RegistryObject<FlowingFluid> YELLORIUM_FLOWING = FLUIDS.register(Reactants.Yellorium.getFluidFlowingName(), () -> new ForgeFlowingFluid.Flowing(new ForgeFlowingFluid.Properties(YELLORIUM_FLUID_TYPE, YELLORIUM_SOURCE, YELLORIUM_FLOWING).bucket(Items.YELLORIUM_BUCKET).block(Blocks.YELLORIUM_FLUID)));
        public static RegistryObject<FluidType> CYANITE_FLUID_TYPE = Fluids.registerReactantFluidType(Reactants.Cyanite);
        public static final RegistryObject<FlowingFluid> CYANITE_SOURCE = FLUIDS.register(Reactants.Cyanite.getFluidSourceName(), () -> new ForgeFlowingFluid.Source(new ForgeFlowingFluid.Properties(CYANITE_FLUID_TYPE, CYANITE_SOURCE, CYANITE_FLOWING).bucket(Items.CYANITE_BUCKET).block(Blocks.CYANITE_FLUID)));
        public static final RegistryObject<FlowingFluid> CYANITE_FLOWING = FLUIDS.register(Reactants.Cyanite.getFluidFlowingName(), () -> new ForgeFlowingFluid.Flowing(new ForgeFlowingFluid.Properties(CYANITE_FLUID_TYPE, CYANITE_SOURCE, CYANITE_FLOWING).bucket(Items.CYANITE_BUCKET).block(Blocks.CYANITE_FLUID)));
        public static RegistryObject<FluidType> BLUTONIUM_FLUID_TYPE = Fluids.registerReactantFluidType(Reactants.Blutonium);
        public static final RegistryObject<FlowingFluid> BLUTONIUM_SOURCE = FLUIDS.register(Reactants.Blutonium.getFluidSourceName(), () -> new ForgeFlowingFluid.Source(new ForgeFlowingFluid.Properties(BLUTONIUM_FLUID_TYPE, BLUTONIUM_SOURCE, BLUTONIUM_FLOWING).bucket(Items.BLUTONIUM_BUCKET).block(Blocks.BLUTONIUM_FLUID)));
        public static final RegistryObject<FlowingFluid> BLUTONIUM_FLOWING = FLUIDS.register(Reactants.Blutonium.getFluidFlowingName(), () -> new ForgeFlowingFluid.Flowing(new ForgeFlowingFluid.Properties(BLUTONIUM_FLUID_TYPE, BLUTONIUM_SOURCE, BLUTONIUM_FLOWING).bucket(Items.BLUTONIUM_BUCKET).block(Blocks.BLUTONIUM_FLUID)));
        public static RegistryObject<FluidType> MAGENTITE_FLUID_TYPE = Fluids.registerReactantFluidType(Reactants.Magentite);
        public static final RegistryObject<FlowingFluid> MAGENTITE_SOURCE = FLUIDS.register(Reactants.Magentite.getFluidSourceName(), () -> new ForgeFlowingFluid.Source(new ForgeFlowingFluid.Properties(MAGENTITE_FLUID_TYPE, MAGENTITE_SOURCE, MAGENTITE_FLOWING).bucket(Items.MAGENTITE_BUCKET).block(Blocks.MAGENTITE_FLUID)));
        public static final RegistryObject<FlowingFluid> MAGENTITE_FLOWING = FLUIDS.register(Reactants.Magentite.getFluidFlowingName(), () -> new ForgeFlowingFluid.Flowing(new ForgeFlowingFluid.Properties(MAGENTITE_FLUID_TYPE, MAGENTITE_SOURCE, MAGENTITE_FLOWING).bucket(Items.MAGENTITE_BUCKET).block(Blocks.MAGENTITE_FLUID)));
        public static RegistryObject<FluidType> VERDERIUM_FLUID_TYPE = Fluids.registerReactantFluidType(Reactants.Verderium);
        public static final RegistryObject<FlowingFluid> VERDERIUM_SOURCE = FLUIDS.register(Reactants.Verderium.getFluidSourceName(), () -> new ForgeFlowingFluid.Source(new ForgeFlowingFluid.Properties(VERDERIUM_FLUID_TYPE, VERDERIUM_SOURCE, VERDERIUM_FLOWING).bucket(Items.VERDERIUM_BUCKET).block(Blocks.VERDERIUM_FLUID)));
        public static final RegistryObject<FlowingFluid> VERDERIUM_FLOWING = FLUIDS.register(Reactants.Verderium.getFluidFlowingName(), () -> new ForgeFlowingFluid.Flowing(new ForgeFlowingFluid.Properties(VERDERIUM_FLUID_TYPE, VERDERIUM_SOURCE, VERDERIUM_FLOWING).bucket(Items.VERDERIUM_BUCKET).block(Blocks.VERDERIUM_FLUID)));
        public static RegistryObject<FluidType> ROSSINITE_FLUID_TYPE = Fluids.registerReactantFluidType(Reactants.Rossinite);
        public static final RegistryObject<FlowingFluid> ROSSINITE_SOURCE = FLUIDS.register(Reactants.Rossinite.getFluidSourceName(), () -> new ForgeFlowingFluid.Source(new ForgeFlowingFluid.Properties(ROSSINITE_FLUID_TYPE, ROSSINITE_SOURCE, ROSSINITE_FLOWING).bucket(Items.ROSSINITE_BUCKET).block(Blocks.ROSSINITE_FLUID)));
        public static final RegistryObject<FlowingFluid> ROSSINITE_FLOWING = FLUIDS.register(Reactants.Rossinite.getFluidFlowingName(), () -> new ForgeFlowingFluid.Flowing(new ForgeFlowingFluid.Properties(ROSSINITE_FLUID_TYPE, ROSSINITE_SOURCE, ROSSINITE_FLOWING).bucket(Items.ROSSINITE_BUCKET).block(Blocks.ROSSINITE_FLUID)));
        public static RegistryObject<FluidType> CRYOMISI_FLUID_TYPE = FLUID_TYPES.register("cryomisi", () -> ReactorFluidType.of("cryomisi", 16056365, 1000, 6, Rarity.RARE));
        public static final RegistryObject<FlowingFluid> CRYOMISI_SOURCE = FLUIDS.register("cryomisi", () -> new ForgeFlowingFluid.Source(new ForgeFlowingFluid.Properties(CRYOMISI_FLUID_TYPE, CRYOMISI_SOURCE, CRYOMISI_FLOWING).bucket(Items.CRYOMISI_BUCKET).block(Blocks.CRYOMISI_FLUID)));
        public static final RegistryObject<FlowingFluid> CRYOMISI_FLOWING = FLUIDS.register("cryomisi_flowing", () -> new ForgeFlowingFluid.Flowing(new ForgeFlowingFluid.Properties(CRYOMISI_FLUID_TYPE, CRYOMISI_SOURCE, CRYOMISI_FLOWING).bucket(Items.CRYOMISI_BUCKET).block(Blocks.CRYOMISI_FLUID)));
        public static RegistryObject<FluidType> TANGERIUM_FLUID_TYPE = FLUID_TYPES.register("tangerium", () -> ReactorFluidType.of("tangerium", 13583931, 1500, 5, Rarity.RARE));
        public static final RegistryObject<FlowingFluid> TANGERIUM_SOURCE = FLUIDS.register("tangerium", () -> new ForgeFlowingFluid.Source(new ForgeFlowingFluid.Properties(TANGERIUM_FLUID_TYPE, TANGERIUM_SOURCE, TANGERIUM_FLOWING).bucket(Items.TANGERIUM_BUCKET).block(Blocks.TANGERIUM_FLUID)));
        public static final RegistryObject<FlowingFluid> TANGERIUM_FLOWING = FLUIDS.register("tangerium_flowing", () -> new ForgeFlowingFluid.Flowing(new ForgeFlowingFluid.Properties(TANGERIUM_FLUID_TYPE, TANGERIUM_SOURCE, TANGERIUM_FLOWING).bucket(Items.TANGERIUM_BUCKET).block(Blocks.TANGERIUM_FLUID)));
        public static RegistryObject<FluidType> REDFRIGIUM_FLUID_TYPE = FLUID_TYPES.register("redfrigium", () -> ReactorFluidType.of("redfrigium", 16561089, 1500, 8, Rarity.EPIC));
        public static final RegistryObject<FlowingFluid> REDFRIGIUM_SOURCE = FLUIDS.register("redfrigium", () -> new ForgeFlowingFluid.Source(new ForgeFlowingFluid.Properties(REDFRIGIUM_FLUID_TYPE, REDFRIGIUM_SOURCE, REDFRIGIUM_FLOWING).bucket(Items.REDFRIGIUM_BUCKET).block(Blocks.REDFRIGIUM_FLUID)));
        public static final RegistryObject<FlowingFluid> REDFRIGIUM_FLOWING = FLUIDS.register("redfrigium_flowing", () -> new ForgeFlowingFluid.Flowing(new ForgeFlowingFluid.Properties(REDFRIGIUM_FLUID_TYPE, REDFRIGIUM_SOURCE, REDFRIGIUM_FLOWING).bucket(Items.REDFRIGIUM_BUCKET).block(Blocks.REDFRIGIUM_FLUID)));

        static void initialize(IEventBus bus) {
            FLUIDS.register(bus);
            FLUID_TYPES.register(bus);
        }

        private static RegistryObject<FlowingFluid> registerSteam(String name, NonNullFunction<ForgeFlowingFluid.Properties, FlowingFluid> factory) {
            return FLUIDS.register(name, () -> (FlowingFluid)factory.apply((Object)new ForgeFlowingFluid.Properties(STEAM_FLUID_TYPE, STEAM_SOURCE, STEAM_FLOWING).bucket(Items.STEAM_BUCKET).block(Blocks.STEAM)));
        }

        private static RegistryObject<FluidType> registerReactantFluidType(Reactants reactant) {
            return FLUID_TYPES.register(reactant.getFluidName(), () -> ReactorFluidType.of(reactant));
        }
    }

    public static final class TileEntityTypes {
        private static final DeferredRegister<BlockEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"bigreactors");
        public static final RegistryObject<BlockEntityType<ReactorCasingEntity>> REACTOR_CASING = TileEntityTypes.registerBlockEntity("reactorcasing", ReactorCasingEntity::new, () -> () -> Blocks.REACTOR_CASING_BASIC.get(), () -> () -> Blocks.REACTOR_CASING_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<ReactorGlassEntity>> REACTOR_GLASS = TileEntityTypes.registerBlockEntity("reactorglass", ReactorGlassEntity::new, () -> () -> Blocks.REACTOR_GLASS_BASIC.get(), () -> () -> Blocks.REACTOR_GLASS_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<ReactorControllerEntity>> REACTOR_CONTROLLER = TileEntityTypes.registerBlockEntity("reactorcontroller", ReactorControllerEntity::new, () -> () -> Blocks.REACTOR_CONTROLLER_BASIC.get(), () -> () -> Blocks.REACTOR_CONTROLLER_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<ReactorFuelRodEntity>> REACTOR_FUELROD = TileEntityTypes.registerBlockEntity("reactorfuelrod", ReactorFuelRodEntity::new, () -> () -> Blocks.REACTOR_FUELROD_BASIC.get(), () -> () -> Blocks.REACTOR_FUELROD_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<ReactorControlRodEntity>> REACTOR_CONTROLROD = TileEntityTypes.registerBlockEntity("reactorcontrolrod", ReactorControlRodEntity::new, () -> () -> Blocks.REACTOR_CONTROLROD_BASIC.get(), () -> () -> Blocks.REACTOR_CONTROLROD_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<ReactorSolidAccessPortEntity>> REACTOR_SOLID_ACCESSPORT = TileEntityTypes.registerBlockEntity("reactoraccessport", ReactorSolidAccessPortEntity::new, () -> () -> Blocks.REACTOR_SOLID_ACCESSPORT_BASIC.get(), () -> () -> Blocks.REACTOR_SOLID_ACCESSPORT_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<ReactorFluidAccessPortEntity>> REACTOR_FLUID_ACCESSPORT = TileEntityTypes.registerBlockEntity("reactoraccessportfluid", ReactorFluidAccessPortEntity::new, () -> () -> Blocks.REACTOR_FLUID_ACCESSPORT_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<ReactorFluidPortEntity>> REACTOR_FLUIDPORT_FORGE_ACTIVE = TileEntityTypes.registerBlockEntity("reactorfluidport_forge_active", (position, blockState) -> new ReactorFluidPortEntity(FluidPortType.Forge, IoMode.Active, (BlockEntityType)REACTOR_FLUIDPORT_FORGE_ACTIVE.get(), position, blockState), () -> () -> Blocks.REACTOR_FLUIDTPORT_FORGE_ACTIVE_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<ReactorFluidPortEntity>> REACTOR_FLUIDPORT_FORGE_PASSIVE = TileEntityTypes.registerBlockEntity("reactorfluidport_forge_passive", (position, blockState) -> new ReactorFluidPortEntity(FluidPortType.Forge, IoMode.Passive, (BlockEntityType)REACTOR_FLUIDPORT_FORGE_PASSIVE.get(), position, blockState), () -> () -> Blocks.REACTOR_FLUIDPORT_FORGE_PASSIVE_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<ReactorMekanismFluidPortEntity>> REACTOR_FLUIDPORT_MEKANISM_PASSIVE = TileEntityTypes.registerBlockEntity("reactorfluidport_mekanism_passive", ReactorMekanismFluidPortEntity::new, () -> () -> Blocks.REACTOR_FLUIDPORT_MEKANISM_PASSIVE_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<ReactorCreativeWaterGenerator>> REACTOR_CREATIVE_WATER_GENERATOR = TileEntityTypes.registerBlockEntity("reactorcreativewatergenerator", ReactorCreativeWaterGenerator::new, () -> () -> Blocks.REACTOR_FLUIDPORT_FORGE_PASSIVE_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<ReactorPowerTapEntity>> REACTOR_POWERTAP_FE_ACTIVE = TileEntityTypes.registerBlockEntity("reactorpowertap_fe_active", (position, blockState) -> new ReactorPowerTapEntity(EnergySystem.ForgeEnergy, IoMode.Active, (BlockEntityType)REACTOR_POWERTAP_FE_ACTIVE.get(), position, blockState), () -> () -> Blocks.REACTOR_POWERTAP_FE_ACTIVE_BASIC.get(), () -> () -> Blocks.REACTOR_POWERTAP_FE_ACTIVE_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<ReactorPowerTapEntity>> REACTOR_POWERTAP_FE_PASSIVE = TileEntityTypes.registerBlockEntity("reactorpowertap_fe_passive", (position, blockState) -> new ReactorPowerTapEntity(EnergySystem.ForgeEnergy, IoMode.Passive, (BlockEntityType)REACTOR_POWERTAP_FE_PASSIVE.get(), position, blockState), () -> () -> Blocks.REACTOR_POWERTAP_FE_PASSIVE_BASIC.get(), () -> () -> Blocks.REACTOR_POWERTAP_FE_PASSIVE_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<ReactorComputerPortEntity>> REACTOR_COMPUTERPORT = TileEntityTypes.registerBlockEntity("reactorcomputerport", ReactorComputerPortEntity::new, () -> () -> Blocks.REACTOR_COMPUTERPORT_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<ReactorRedstonePortEntity>> REACTOR_REDSTONEPORT = TileEntityTypes.registerBlockEntity("reactorredstoneport", ReactorRedstonePortEntity::new, () -> () -> Blocks.REACTOR_REDSTONEPORT_BASIC.get(), () -> () -> Blocks.REACTOR_REDSTONEPORT_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<ReactorChargingPortEntity>> REACTOR_CHARGINGPORT_FE = TileEntityTypes.registerBlockEntity("reactorchargingport_fe", (position, blockState) -> new ReactorChargingPortEntity(EnergySystem.ForgeEnergy, (BlockEntityType)REACTOR_CHARGINGPORT_FE.get(), position, blockState), () -> () -> Blocks.REACTOR_CHARGINGPORT_FE_BASIC.get(), () -> () -> Blocks.REACTOR_CHARGINGPORT_FE_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<TurbineCasingEntity>> TURBINE_CASING = TileEntityTypes.registerBlockEntity("turbinecasing", TurbineCasingEntity::new, () -> () -> Blocks.TURBINE_CASING_BASIC.get(), () -> () -> Blocks.TURBINE_CASING_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<TurbineGlassEntity>> TURBINE_GLASS = TileEntityTypes.registerBlockEntity("turbineglass", TurbineGlassEntity::new, () -> () -> Blocks.TURBINE_GLASS_BASIC.get(), () -> () -> Blocks.TURBINE_GLASS_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<TurbineControllerEntity>> TURBINE_CONTROLLER = TileEntityTypes.registerBlockEntity("turbinecontroller", TurbineControllerEntity::new, () -> () -> Blocks.TURBINE_CONTROLLER_BASIC.get(), () -> () -> Blocks.TURBINE_CONTROLLER_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<TurbineRotorBearingEntity>> TURBINE_ROTORBEARING = TileEntityTypes.registerBlockEntity("turbinerotorbearing", TurbineRotorBearingEntity::new, () -> () -> Blocks.TURBINE_ROTORBEARING_BASIC.get(), () -> () -> Blocks.TURBINE_ROTORBEARING_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<TurbineRotorComponentEntity>> TURBINE_ROTORSHAFT = TileEntityTypes.registerBlockEntity("turbinerotorshaft", TurbineRotorComponentEntity::shaft, () -> () -> Blocks.TURBINE_ROTORSHAFT_BASIC.get(), () -> () -> Blocks.TURBINE_ROTORSHAFT_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<TurbineRotorComponentEntity>> TURBINE_ROTORBLADE = TileEntityTypes.registerBlockEntity("turbinerotorblade", TurbineRotorComponentEntity::blade, () -> () -> Blocks.TURBINE_ROTORBLADE_BASIC.get(), () -> () -> Blocks.TURBINE_ROTORBLADE_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<TurbineFluidPortEntity>> TURBINE_FLUIDPORT_FORGE_ACTIVE = TileEntityTypes.registerBlockEntity("turbinefluidport_forge_active", (position, blockState) -> new TurbineFluidPortEntity(FluidPortType.Forge, IoMode.Active, (BlockEntityType)TURBINE_FLUIDPORT_FORGE_ACTIVE.get(), position, blockState), () -> () -> Blocks.TURBINE_FLUIDPORT_FORGE_ACTIVE_BASIC.get(), () -> () -> Blocks.TURBINE_FLUIDPORT_FORGE_ACTIVE_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<TurbineFluidPortEntity>> TURBINE_FLUIDPORT_FORGE_PASSIVE = TileEntityTypes.registerBlockEntity("turbinefluidport_forge_passive", (position, blockState) -> new TurbineFluidPortEntity(FluidPortType.Forge, IoMode.Passive, (BlockEntityType)TURBINE_FLUIDPORT_FORGE_PASSIVE.get(), position, blockState), () -> () -> Blocks.TURBINE_FLUIDPORT_FORGE_PASSIVE_BASIC.get(), () -> () -> Blocks.TURBINE_FLUIDPORT_FORGE_PASSIVE_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<TurbineCreativeSteamGenerator>> TURBINE_CREATIVE_STEAM_GENERATOR = TileEntityTypes.registerBlockEntity("turbinecreativesteamgenerator", TurbineCreativeSteamGenerator::new, () -> () -> Blocks.TURBINE_CREATIVE_STEAM_GENERATOR_BASIC.get());
        public static final RegistryObject<BlockEntityType<TurbinePowerTapEntity>> TURBINE_POWERTAP_FE_ACTIVE = TileEntityTypes.registerBlockEntity("turbinepowertap_fe_active", (position, blockState) -> new TurbinePowerTapEntity(EnergySystem.ForgeEnergy, IoMode.Active, (BlockEntityType)TURBINE_POWERTAP_FE_ACTIVE.get(), position, blockState), () -> () -> Blocks.TURBINE_POWERTAP_FE_ACTIVE_BASIC.get(), () -> () -> Blocks.TURBINE_POWERTAP_FE_ACTIVE_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<TurbinePowerTapEntity>> TURBINE_POWERTAP_FE_PASSIVE = TileEntityTypes.registerBlockEntity("turbinepowertap_fe_passive", (position, blockState) -> new TurbinePowerTapEntity(EnergySystem.ForgeEnergy, IoMode.Passive, (BlockEntityType)TURBINE_POWERTAP_FE_PASSIVE.get(), position, blockState), () -> () -> Blocks.TURBINE_POWERTAP_FE_PASSIVE_BASIC.get(), () -> () -> Blocks.TURBINE_POWERTAP_FE_PASSIVE_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<TurbineComputerPortEntity>> TURBINE_COMPUTERPORT = TileEntityTypes.registerBlockEntity("turbinecomputerport", TurbineComputerPortEntity::new, () -> () -> Blocks.TURBINE_COMPUTERPORT_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<TurbineRedstonePortEntity>> TURBINE_REDSTONEPORT = TileEntityTypes.registerBlockEntity("turbineredstoneport", TurbineRedstonePortEntity::new, () -> () -> Blocks.TURBINE_REDSTONEPORT_BASIC.get(), () -> () -> Blocks.TURBINE_REDSTONEPORT_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<TurbineChargingPortEntity>> TURBINE_CHARGINGPORT_FE = TileEntityTypes.registerBlockEntity("turbinechargingport_fe", (position, blockState) -> new TurbineChargingPortEntity(EnergySystem.ForgeEnergy, (BlockEntityType)TURBINE_CHARGINGPORT_FE.get(), position, blockState), () -> () -> Blocks.TURBINE_CHARGINGPORT_FE_BASIC.get(), () -> () -> Blocks.TURBINE_CHARGINGPORT_FE_REINFORCED.get());
        public static final RegistryObject<BlockEntityType<ReprocessorCasingEntity>> REPROCESSOR_CASING = TileEntityTypes.registerBlockEntity("reprocessorcasing", ReprocessorCasingEntity::new, () -> () -> Blocks.REPROCESSOR_CASING.get());
        public static final RegistryObject<BlockEntityType<ReprocessorGlassEntity>> REPROCESSOR_GLASS = TileEntityTypes.registerBlockEntity("reprocessorglass", ReprocessorGlassEntity::new, () -> () -> Blocks.REPROCESSOR_GLASS.get());
        public static final RegistryObject<BlockEntityType<ReprocessorControllerEntity>> REPROCESSOR_CONTROLLER = TileEntityTypes.registerBlockEntity("reprocessorcontroller", ReprocessorControllerEntity::new, () -> () -> Blocks.REPROCESSOR_CONTROLLER.get());
        public static final RegistryObject<BlockEntityType<ReprocessorAccessPortEntity>> REPROCESSOR_WASTEINJECTOR = TileEntityTypes.registerBlockEntity("reprocessorwasteinjector", (position, blockState) -> new ReprocessorAccessPortEntity((BlockEntityType)REPROCESSOR_WASTEINJECTOR.get(), IoDirection.Input, position, blockState), () -> () -> Blocks.REPROCESSOR_WASTEINJECTOR.get());
        public static final RegistryObject<BlockEntityType<ReprocessorFluidPortEntity>> REPROCESSOR_FLUIDINJECTOR = TileEntityTypes.registerBlockEntity("reprocessorfluidinjector", ReprocessorFluidPortEntity::new, () -> () -> Blocks.REPROCESSOR_FLUIDINJECTOR.get());
        public static final RegistryObject<BlockEntityType<ReprocessorAccessPortEntity>> REPROCESSOR_OUTPUTPORT = TileEntityTypes.registerBlockEntity("reprocessoroutputport", (position, blockState) -> new ReprocessorAccessPortEntity((BlockEntityType)REPROCESSOR_OUTPUTPORT.get(), IoDirection.Output, position, blockState), () -> () -> Blocks.REPROCESSOR_OUTPUTPORT.get());
        public static final RegistryObject<BlockEntityType<ReprocessorPowerPortEntity>> REPROCESSOR_POWERPORT = TileEntityTypes.registerBlockEntity("reprocessorpowerport", ReprocessorPowerPortEntity::new, () -> () -> Blocks.REPROCESSOR_POWERPORT.get());
        public static final RegistryObject<BlockEntityType<ReprocessorCollectorEntity>> REPROCESSOR_COLLECTOR = TileEntityTypes.registerBlockEntity("reprocessorcollector", ReprocessorCollectorEntity::new, () -> () -> Blocks.REPROCESSOR_COLLECTOR.get());
        public static final RegistryObject<BlockEntityType<FluidizerCasingEntity>> FLUIDIZER_CASING = TileEntityTypes.registerBlockEntity("fluidizercasing", FluidizerCasingEntity::new, () -> () -> Blocks.FLUIDIZER_CASING.get());
        public static final RegistryObject<BlockEntityType<FluidizerGlassEntity>> FLUIDIZER_GLASS = TileEntityTypes.registerBlockEntity("fluidizerglass", FluidizerGlassEntity::new, () -> () -> Blocks.FLUIDIZER_GLASS.get());
        public static final RegistryObject<BlockEntityType<FluidizerControllerEntity>> FLUIDIZER_CONTROLLER = TileEntityTypes.registerBlockEntity("fluidizercontroller", FluidizerControllerEntity::new, () -> () -> Blocks.FLUIDIZER_CONTROLLER.get());
        public static final RegistryObject<BlockEntityType<FluidizerSolidInjectorEntity>> FLUIDIZER_SOLIDINJECTOR = TileEntityTypes.registerBlockEntity("fluidizersolidinjector", FluidizerSolidInjectorEntity::new, () -> () -> Blocks.FLUIDIZER_SOLIDINJECTOR.get());
        public static final RegistryObject<BlockEntityType<FluidizerFluidInjectorEntity>> FLUIDIZER_FLUIDINJECTOR = TileEntityTypes.registerBlockEntity("fluidizefluidinjector", FluidizerFluidInjectorEntity::new, () -> () -> Blocks.FLUIDIZER_FLUIDINJECTOR.get());
        public static final RegistryObject<BlockEntityType<FluidizerOutputPortEntity>> FLUIDIZER_OUTPUTPORT = TileEntityTypes.registerBlockEntity("fluidizeoutputport", FluidizerOutputPortEntity::new, () -> () -> Blocks.FLUIDIZER_OUTPUTPORT.get());
        public static final RegistryObject<BlockEntityType<FluidizerPowerPortEntity>> FLUIDIZER_POWERPORT = TileEntityTypes.registerBlockEntity("fluidizerpowerport", FluidizerPowerPortEntity::new, () -> () -> Blocks.FLUIDIZER_POWERPORT.get());

        static void initialize(IEventBus bus) {
            TILE_ENTITIES.register(bus);
        }

        @SafeVarargs
        private static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> registerBlockEntity(String name, BlockEntityType.BlockEntitySupplier<T> factory, Supplier<Supplier<Block>> ... validBlockSuppliers) {
            return TILE_ENTITIES.register(name, () -> {
                Block[] validBlocks = new Block[validBlockSuppliers.length];
                if (validBlockSuppliers.length > 0) {
                    for (int i = 0; i < validBlockSuppliers.length; ++i) {
                        validBlocks[i] = (Block)((Supplier)validBlockSuppliers[i].get()).get();
                    }
                }
                return BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)factory, (Block[])validBlocks).m_58966_(null);
            });
        }
    }

    public static final class ContainerTypes {
        private static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"bigreactors");
        public static final RegistryObject<MenuType<ModTileContainer<ReactorControllerEntity>>> REACTOR_CONTROLLER = ContainerTypes.registerContainer("reactorcontroller", (windowId, inv, data) -> ModTileContainer.empty((MenuType)((MenuType)REACTOR_CONTROLLER.get()), (int)windowId, (Inventory)inv, (FriendlyByteBuf)data));
        public static final RegistryObject<MenuType<ReactorSolidAccessPortContainer>> REACTOR_SOLID_ACCESSPORT = ContainerTypes.registerContainer("reactoraccessport", ReactorSolidAccessPortContainer::new);
        public static final RegistryObject<MenuType<ModTileContainer<ReactorFluidAccessPortEntity>>> REACTOR_FLUID_ACCESSPORT = ContainerTypes.registerContainer("reactoraccessportfluid", (windowId, inv, data) -> ModTileContainer.empty((MenuType)((MenuType)REACTOR_FLUID_ACCESSPORT.get()), (int)windowId, (Inventory)inv, (FriendlyByteBuf)data));
        public static final RegistryObject<MenuType<ModTileContainer<ReactorRedstonePortEntity>>> REACTOR_REDSTONEPORT = ContainerTypes.registerContainer("reactorredstoneport", (windowId, inv, data) -> ModTileContainer.empty((MenuType)((MenuType)REACTOR_REDSTONEPORT.get()), (int)windowId, (Inventory)inv, (FriendlyByteBuf)data));
        public static final RegistryObject<MenuType<ModTileContainer<ReactorControlRodEntity>>> REACTOR_CONTROLROD = ContainerTypes.registerContainer("reactorcontrolrod", (windowId, inv, data) -> ModTileContainer.empty((MenuType)((MenuType)REACTOR_CONTROLROD.get()), (int)windowId, (Inventory)inv, (FriendlyByteBuf)data));
        public static final RegistryObject<MenuType<ChargingPortContainer<ReactorChargingPortEntity>>> REACTOR_CHARGINGPORT = ContainerTypes.registerContainer("reactorchargingport", (windowId, inv, data) -> new ChargingPortContainer(windowId, (MenuType)REACTOR_CHARGINGPORT.get(), inv, data));
        public static final RegistryObject<MenuType<ModTileContainer<ReactorFluidPortEntity>>> REACTOR_FLUIDPORT = ContainerTypes.registerContainer("reactorfluidport", (windowId, inv, data) -> ModTileContainer.empty((MenuType)((MenuType)REACTOR_FLUIDPORT.get()), (int)windowId, (Inventory)inv, (FriendlyByteBuf)data));
        public static final RegistryObject<MenuType<ModTileContainer<TurbineControllerEntity>>> TURBINE_CONTROLLER = ContainerTypes.registerContainer("turbinecontroller", (windowId, inv, data) -> ModTileContainer.empty((MenuType)((MenuType)TURBINE_CONTROLLER.get()), (int)windowId, (Inventory)inv, (FriendlyByteBuf)data));
        public static final RegistryObject<MenuType<ModTileContainer<TurbineRedstonePortEntity>>> TURBINE_REDSTONEPORT = ContainerTypes.registerContainer("turbineredstoneport", (windowId, inv, data) -> ModTileContainer.empty((MenuType)((MenuType)TURBINE_REDSTONEPORT.get()), (int)windowId, (Inventory)inv, (FriendlyByteBuf)data));
        public static final RegistryObject<MenuType<ChargingPortContainer<TurbineChargingPortEntity>>> TURBINE_CHARGINGPORT = ContainerTypes.registerContainer("turbinechargingport", (windowId, inv, data) -> new ChargingPortContainer(windowId, (MenuType)TURBINE_CHARGINGPORT.get(), inv, data));
        public static final RegistryObject<MenuType<ModTileContainer<TurbineFluidPortEntity>>> TURBINE_FLUIDPORT = ContainerTypes.registerContainer("turbinefluidport", (windowId, inv, data) -> ModTileContainer.empty((MenuType)((MenuType)TURBINE_FLUIDPORT.get()), (int)windowId, (Inventory)inv, (FriendlyByteBuf)data));
        public static final RegistryObject<MenuType<ModTileContainer<ReprocessorControllerEntity>>> REPROCESSOR_CONTROLLER = ContainerTypes.registerContainer("reprocessorcontroller", (windowId, inv, data) -> ModTileContainer.empty((MenuType)((MenuType)REPROCESSOR_CONTROLLER.get()), (int)windowId, (Inventory)inv, (FriendlyByteBuf)data));
        public static final RegistryObject<MenuType<ReprocessorAccessPortContainer>> REPROCESSOR_ACCESSPORT = ContainerTypes.registerContainer("reprocessoraccessport", ReprocessorAccessPortContainer::new);
        public static final RegistryObject<MenuType<FluidizerControllerContainer>> FLUIDIZER_CONTROLLER = ContainerTypes.registerContainer("fluidizercontroller", FluidizerControllerContainer::new);
        public static final RegistryObject<MenuType<FluidizerSolidInjectorContainer>> FLUIDIZER_SOLID_INJECTOR = ContainerTypes.registerContainer("fluidizersolidinjector", FluidizerSolidInjectorContainer::new);

        static void initialize(IEventBus bus) {
            CONTAINERS.register(bus);
        }

        private static <C extends AbstractContainerMenu> RegistryObject<MenuType<C>> registerContainer(String name, IContainerFactory<C> factory) {
            return CONTAINERS.register(name, () -> IForgeMenuType.create((IContainerFactory)factory));
        }
    }

    public static final class Recipes {
        private static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"bigreactors");
        public static final ModRecipeType<ReprocessorRecipe> REPROCESSOR_RECIPE_TYPE = ModRecipeType.create((ResourceLocation)ReprocessorRecipe.ID);
        public static final RegistryObject<RecipeSerializer<ReprocessorRecipe>> REPROCESSOR_RECIPE_SERIALIZER = SERIALIZERS.register("reprocessor", ReprocessorRecipe::serializer);
        public static final ModRecipeType<ModRecipe> FLUIDIZER_RECIPE_TYPE = ModRecipeType.create((ResourceLocation)ExtremeReactors.ROOT_LOCATION.buildWithSuffix("fluidizer"));
        public static final RegistryObject<RecipeSerializer<FluidizerSolidRecipe>> FLUIDIZER_SOLID_RECIPE_SERIALIZER = SERIALIZERS.register(IFluidizerRecipe.Type.Solid.getRecipeName(), FluidizerSolidRecipe::serializer);
        public static final RegistryObject<RecipeSerializer<FluidizerSolidMixingRecipe>> FLUIDIZER_SOLIDMIXING_RECIPE_SERIALIZER = SERIALIZERS.register(IFluidizerRecipe.Type.SolidMixing.getRecipeName(), FluidizerSolidMixingRecipe::serializer);
        public static final RegistryObject<RecipeSerializer<FluidizerFluidMixingRecipe>> FLUIDIZER_FLUIDMIXING_RECIPE_SERIALIZER = SERIALIZERS.register(IFluidizerRecipe.Type.FluidMixing.getRecipeName(), FluidizerFluidMixingRecipe::serializer);

        static void initialize(IEventBus bus) {
            SERIALIZERS.register(bus);
        }
    }

    public static final class Biomes {
        private static final DeferredRegister<Codec<? extends BiomeModifier>> BIOME_MODIFIER_SERIALIZERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"bigreactors");
        public static final RegistryObject<Codec<OreBiomeModifier>> OREGEN_YELLORITE = Biomes.register("oregen_yellorite", OreBiomeModifier::yellorite);
        public static final RegistryObject<Codec<OreBiomeModifier>> OREGEN_ANGLESITE = Biomes.register("oregen_anglesite", OreBiomeModifier::anglesite);
        public static final RegistryObject<Codec<OreBiomeModifier>> OREGEN_BENITOITE = Biomes.register("oregen_benitoite", OreBiomeModifier::benitoite);

        static void initialize(IEventBus bus) {
            BIOME_MODIFIER_SERIALIZERS.register(bus);
        }

        private static RegistryObject<Codec<OreBiomeModifier>> register(String name, BiFunction<HolderSet<Biome>, Holder<PlacedFeature>, OreBiomeModifier> factory) {
            return BIOME_MODIFIER_SERIALIZERS.register(name, () -> RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(OreBiomeModifier::validBiomes), (App)PlacedFeature.f_191773_.fieldOf("feature").forGetter(OreBiomeModifier::feature)).apply((Applicative)builder, factory)));
        }
    }

    public static final class CreativeTabs {
        private static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"bigreactors");

        static void initialize(IEventBus bus) {
            ResourceLocation tabGeneral = ExtremeReactors.ROOT_LOCATION.buildWithSuffix("tab.general");
            ResourceLocation tabReactor = ExtremeReactors.ROOT_LOCATION.buildWithSuffix("tab.reactor");
            ResourceLocation tabTurbine = ExtremeReactors.ROOT_LOCATION.buildWithSuffix("tab.turbine");
            TABS.register(bus);
            TABS.register("tab.general", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.bigreactors.general")).m_257737_(() -> new ItemStack((ItemLike)Items.YELLORITE_ORE_BLOCK.get())).withTabsBefore(new ResourceKey[]{CreativeModeTabs.f_256731_}).withTabsAfter(new ResourceLocation[]{tabReactor}).m_257501_((parameters, output) -> {
                CreativeTabs.acceptAll(output, new Supplier[]{Blocks.YELLORITE_ORE_BLOCK, Blocks.ANGLESITE_ORE_BLOCK, Blocks.BENITOITE_ORE_BLOCK, Items.YELLORIUM_INGOT, Items.YELLORIUM_DUST, Blocks.YELLORIUM_BLOCK, Items.BLUTONIUM_INGOT, Items.BLUTONIUM_DUST, Blocks.BLUTONIUM_BLOCK, Items.CYANITE_INGOT, Items.CYANITE_DUST, Blocks.CYANITE_BLOCK, Items.MAGENTITE_INGOT, Items.MAGENTITE_DUST, Blocks.MAGENTITE_BLOCK, Items.GRAPHITE_INGOT, Items.GRAPHITE_DUST, Blocks.GRAPHITE_BLOCK, Items.LUDICRITE_INGOT, Items.LUDICRITE_DUST, Blocks.LUDICRITE_BLOCK, Items.RIDICULITE_INGOT, Items.RIDICULITE_DUST, Blocks.RIDICULITE_BLOCK, Items.INANITE_INGOT, Items.INANITE_DUST, Blocks.INANITE_BLOCK, Items.INSANITE_INGOT, Items.INSANITE_DUST, Blocks.INSANITE_BLOCK, Items.YELLORIUM_NUGGET, Items.BLUTONIUM_NUGGET, Items.ANGLESITE_CRYSTAL, Items.BENITOITE_CRYSTAL, Items.WRENCH});
                Patchouli.consumeBookStack((ResourceLocation)PatchouliCompat.HANDBOOK_ID, arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
                CreativeTabs.acceptAll(output, new Supplier[]{Blocks.REPROCESSOR_CASING, Blocks.REPROCESSOR_GLASS, Blocks.REPROCESSOR_CONTROLLER, Blocks.REPROCESSOR_COLLECTOR, Blocks.REPROCESSOR_WASTEINJECTOR, Blocks.REPROCESSOR_FLUIDINJECTOR, Blocks.REPROCESSOR_OUTPUTPORT, Blocks.REPROCESSOR_POWERPORT});
                CreativeTabs.acceptAll(output, new Supplier[]{Items.STEAM_BUCKET, Items.YELLORIUM_BUCKET, Items.CYANITE_BUCKET, Items.BLUTONIUM_BUCKET, Items.MAGENTITE_BUCKET, Items.VERDERIUM_BUCKET, Items.ROSSINITE_BUCKET, Items.CRYOMISI_BUCKET, Items.TANGERIUM_BUCKET, Items.REDFRIGIUM_BUCKET});
                CreativeTabs.acceptAll(output, new Supplier[]{Blocks.FLUIDIZER_CASING, Blocks.FLUIDIZER_GLASS, Blocks.FLUIDIZER_CONTROLLER, Blocks.FLUIDIZER_SOLIDINJECTOR, Blocks.FLUIDIZER_FLUIDINJECTOR, Blocks.FLUIDIZER_OUTPUTPORT, Blocks.FLUIDIZER_POWERPORT});
            }).m_257652_());
            TABS.register("tab.reactor", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.bigreactors.reactor")).m_257737_(() -> new ItemStack((ItemLike)Items.REACTOR_FUELROD_BASIC.get())).m_257794_().withTabsBefore(new ResourceLocation[]{tabGeneral}).withTabsAfter(new ResourceLocation[]{tabTurbine}).m_257501_((parameters, output) -> CreativeTabs.acceptAll(output, new Supplier[]{Blocks.REACTOR_CONTROLLER_BASIC, Blocks.REACTOR_CASING_BASIC, Blocks.REACTOR_GLASS_BASIC, Blocks.REACTOR_FUELROD_BASIC, Blocks.REACTOR_CONTROLROD_BASIC, Blocks.REACTOR_SOLID_ACCESSPORT_BASIC, Blocks.REACTOR_CHARGINGPORT_FE_BASIC, Blocks.REACTOR_POWERTAP_FE_ACTIVE_BASIC, Blocks.REACTOR_POWERTAP_FE_PASSIVE_BASIC, Blocks.REACTOR_REDSTONEPORT_BASIC, Blocks.REACTOR_CONTROLLER_REINFORCED, Blocks.REACTOR_CASING_REINFORCED, Blocks.REACTOR_GLASS_REINFORCED, Blocks.REACTOR_FUELROD_REINFORCED, Blocks.REACTOR_CONTROLROD_REINFORCED, Blocks.REACTOR_SOLID_ACCESSPORT_REINFORCED, Blocks.REACTOR_FLUID_ACCESSPORT_REINFORCED, Blocks.REACTOR_POWERTAP_FE_ACTIVE_REINFORCED, Blocks.REACTOR_POWERTAP_FE_PASSIVE_REINFORCED, Blocks.REACTOR_CHARGINGPORT_FE_REINFORCED, Blocks.REACTOR_REDSTONEPORT_REINFORCED, Blocks.REACTOR_COMPUTERPORT_REINFORCED, Blocks.REACTOR_FLUIDTPORT_FORGE_ACTIVE_REINFORCED, Blocks.REACTOR_FLUIDPORT_FORGE_PASSIVE_REINFORCED, Blocks.REACTOR_FLUIDPORT_MEKANISM_PASSIVE_REINFORCED, Blocks.REACTOR_CREATIVE_WATER_GENERATOR_REINFORCED})).m_257652_());
            TABS.register("tab.turbine", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.bigreactors.turbine")).m_257737_(() -> new ItemStack((ItemLike)Items.TURBINE_ROTORSHAFT_BASIC.get())).m_257794_().withTabsBefore(new ResourceLocation[]{tabReactor}).m_257501_((parameters, output) -> CreativeTabs.acceptAll(output, new Supplier[]{Blocks.TURBINE_CONTROLLER_BASIC, Blocks.TURBINE_CASING_BASIC, Blocks.TURBINE_GLASS_BASIC, Blocks.TURBINE_ROTORBEARING_BASIC, Blocks.TURBINE_ROTORSHAFT_BASIC, Blocks.TURBINE_ROTORBLADE_BASIC, Blocks.TURBINE_POWERTAP_FE_ACTIVE_BASIC, Blocks.TURBINE_POWERTAP_FE_PASSIVE_BASIC, Blocks.TURBINE_CHARGINGPORT_FE_BASIC, Blocks.TURBINE_REDSTONEPORT_BASIC, Blocks.TURBINE_FLUIDPORT_FORGE_ACTIVE_BASIC, Blocks.TURBINE_FLUIDPORT_FORGE_PASSIVE_BASIC, Blocks.TURBINE_CREATIVE_STEAM_GENERATOR_BASIC, Blocks.TURBINE_CONTROLLER_REINFORCED, Blocks.TURBINE_CASING_REINFORCED, Blocks.TURBINE_GLASS_REINFORCED, Blocks.TURBINE_ROTORBEARING_REINFORCED, Blocks.TURBINE_ROTORSHAFT_REINFORCED, Blocks.TURBINE_ROTORBLADE_REINFORCED, Blocks.TURBINE_POWERTAP_FE_ACTIVE_REINFORCED, Blocks.TURBINE_POWERTAP_FE_PASSIVE_REINFORCED, Blocks.TURBINE_CHARGINGPORT_FE_REINFORCED, Blocks.TURBINE_REDSTONEPORT_REINFORCED, Blocks.TURBINE_COMPUTERPORT_REINFORCED, Blocks.TURBINE_FLUIDPORT_FORGE_ACTIVE_REINFORCED, Blocks.TURBINE_FLUIDPORT_FORGE_PASSIVE_REINFORCED, Blocks.TURBINE_CREATIVE_STEAM_GENERATOR_REINFORCED})).m_257652_());
        }

        @SafeVarargs
        static void acceptAll(CreativeModeTab.Output output, Supplier<? extends ItemLike> ... items) {
            for (Supplier<? extends ItemLike> item : items) {
                output.m_245282_(item.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }
    }
}

