/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.datagen.recipe;

import it.zerono.mods.extremereactors.datagen.recipe.AbstractRecipesDataProvider;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.ContentTags;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerFluidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.FluidizerSolidMixingRecipe;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.IFluidizerRecipe;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.recipe.OneToOneRecipeBuilder;
import it.zerono.mods.zerocore.lib.datagen.provider.recipe.TwoToOneRecipeBuilder;
import it.zerono.mods.zerocore.lib.recipe.ingredient.FluidStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.ItemStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.FluidStackRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;

public class FluidizerRecipesDataProvider
extends AbstractRecipesDataProvider {
    public FluidizerRecipesDataProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registryLookup, ResourceLocationBuilder modLocationRoot) {
        super("Fluidizer recipes", output, registryLookup, modLocationRoot);
    }

    protected void m_245200_(Consumer<FinishedRecipe> builder) {
        this.solid(builder, "yellorium", (Supplier<? extends Item>)Content.Items.YELLORIUM_INGOT, (Supplier<FlowingFluid>)Content.Fluids.YELLORIUM_SOURCE);
        this.solid(builder, "yellorium9", (Supplier<? extends Item>)Content.Items.YELLORIUM_BLOCK, (Supplier<FlowingFluid>)Content.Fluids.YELLORIUM_SOURCE, 9);
        this.solid(builder, "cyanite", (Supplier<? extends Item>)Content.Items.CYANITE_INGOT, (Supplier<FlowingFluid>)Content.Fluids.CYANITE_SOURCE);
        this.solid(builder, "cyanite9", (Supplier<? extends Item>)Content.Items.CYANITE_BLOCK, (Supplier<FlowingFluid>)Content.Fluids.CYANITE_SOURCE, 9);
        this.solid(builder, "blutonium", (Supplier<? extends Item>)Content.Items.BLUTONIUM_INGOT, (Supplier<FlowingFluid>)Content.Fluids.BLUTONIUM_SOURCE);
        this.solid(builder, "blutonium9", (Supplier<? extends Item>)Content.Items.BLUTONIUM_BLOCK, (Supplier<FlowingFluid>)Content.Fluids.BLUTONIUM_SOURCE, 9);
        this.solid(builder, "magentite", (Supplier<? extends Item>)Content.Items.MAGENTITE_INGOT, (Supplier<FlowingFluid>)Content.Fluids.MAGENTITE_SOURCE);
        this.solid(builder, "magentite9", (Supplier<? extends Item>)Content.Items.MAGENTITE_BLOCK, (Supplier<FlowingFluid>)Content.Fluids.MAGENTITE_SOURCE, 9);
        this.solidMixing(builder, "verderium", (Supplier<? extends Item>)Content.Items.YELLORIUM_INGOT, 2, (Supplier<? extends Item>)Content.Items.BLUTONIUM_INGOT, 1, (Supplier<FlowingFluid>)Content.Fluids.VERDERIUM_SOURCE, 2);
        this.solidMixing(builder, "verderium9", (Supplier<? extends Item>)Content.Items.YELLORIUM_BLOCK, 2, (Supplier<? extends Item>)Content.Items.BLUTONIUM_BLOCK, 1, (Supplier<FlowingFluid>)Content.Fluids.VERDERIUM_SOURCE, 18);
        this.fluidMixing(builder, "verderium", (Supplier<? extends Fluid>)Content.Fluids.YELLORIUM_SOURCE, 2000, (Supplier<? extends Fluid>)Content.Fluids.BLUTONIUM_SOURCE, 1000, (Supplier<? extends Fluid>)Content.Fluids.VERDERIUM_SOURCE, 2000);
        this.solidMixing(builder, "cryomisi", Items.f_42451_, 1, Items.f_41981_, 1, (Fluid)Content.Fluids.CRYOMISI_SOURCE.get(), 500);
        this.solidMixing(builder, "tangerium", (Item)Content.Items.ANGLESITE_CRYSTAL.get(), 1, Items.f_42584_, 4, (Fluid)Content.Fluids.TANGERIUM_SOURCE.get(), 500);
        this.fluidMixing(builder, "redfrigium", (Supplier<? extends Fluid>)Content.Fluids.CRYOMISI_SOURCE, 1000, (Supplier<? extends Fluid>)Content.Fluids.TANGERIUM_SOURCE, 1000, (Supplier<? extends Fluid>)Content.Fluids.REDFRIGIUM_SOURCE, 2000);
        this.casing(builder);
        this.glass(builder);
        this.controller(builder);
        this.port(builder, "solidinjector", (Supplier<? extends ItemLike>)Content.Items.FLUIDIZER_SOLIDINJECTOR, (ItemLike)Items.f_41862_, ContentTags.Items.INGOTS_YELLORIUM, (TagKey<Item>)Tags.Items.DUSTS_REDSTONE);
        this.port(builder, "fluidinjector", (Supplier<? extends ItemLike>)Content.Items.FLUIDIZER_FLUIDINJECTOR, (ItemLike)Items.f_41869_, (TagKey<Item>)Tags.Items.INGOTS_NETHERITE, (TagKey<Item>)Tags.Items.GEMS_LAPIS);
        this.port(builder, "outputport", (Supplier<? extends ItemLike>)Content.Items.FLUIDIZER_OUTPUTPORT, (ItemLike)Items.f_41855_, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_LAPIS, (TagKey<Item>)Tags.Items.CHESTS);
        this.port(builder, "powerport", (Supplier<? extends ItemLike>)Content.Items.FLUIDIZER_POWERPORT, (ItemLike)Items.f_42350_, (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_REDSTONE, (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
    }

    private void solid(Consumer<FinishedRecipe> builder, String name, Supplier<? extends Item> ingredient, Supplier<FlowingFluid> result) {
        this.solid(builder, name, ingredient, result, 1);
    }

    private void solid(Consumer<FinishedRecipe> builder, String name, Supplier<? extends Item> ingredient, Supplier<FlowingFluid> result, int resultMultiplier) {
        this.solid(builder, name, ingredient.get(), 1, (Fluid)result.get(), 1000 * resultMultiplier);
    }

    private void solid(Consumer<FinishedRecipe> builder, String name, Item ingredient, int ingredientAmount, Fluid result, int resultAmount) {
        new OneToOneRecipeBuilder(IFluidizerRecipe.Type.Solid.getRecipeId(), (IRecipeIngredient)ItemStackRecipeIngredient.from((ItemLike)ingredient, (int)ingredientAmount), (IRecipeResult)FluidStackRecipeResult.from((FluidStack)new FluidStack(result, resultAmount))).build(builder, this.fluidizerSolidRoot().buildWithSuffix(name));
    }

    private void solidMixing(Consumer<FinishedRecipe> builder, String name, Supplier<? extends Item> ingredient1, int ingredient1Amount, Supplier<? extends Item> ingredient2, int ingredient2Amount, Supplier<FlowingFluid> result, int resultMultiplier) {
        this.solidMixing(builder, name, ingredient1.get(), ingredient1Amount, ingredient2.get(), ingredient2Amount, (Fluid)result.get(), 1000 * resultMultiplier);
    }

    private void solidMixing(Consumer<FinishedRecipe> builder, String name, Item ingredient1, int ingredient1Amount, Item ingredient2, int ingredient2Amount, Fluid result, int resultAmount) {
        ResourceLocationBuilder idBuilder = this.fluidizerSolidMixingRoot().append(name);
        new TwoToOneRecipeBuilder(IFluidizerRecipe.Type.SolidMixing.getRecipeId(), (IRecipeIngredient)ItemStackRecipeIngredient.from((ItemLike)ingredient1, (int)ingredient1Amount), (IRecipeIngredient)ItemStackRecipeIngredient.from((ItemLike)ingredient2, (int)ingredient2Amount), (IRecipeResult)FluidStackRecipeResult.from((FluidStack)new FluidStack(result, resultAmount)), FluidizerSolidMixingRecipe::getLabel).build(builder, idBuilder.buildWithSuffix("_1"));
        new TwoToOneRecipeBuilder(IFluidizerRecipe.Type.SolidMixing.getRecipeId(), (IRecipeIngredient)ItemStackRecipeIngredient.from((ItemLike)ingredient2, (int)ingredient2Amount), (IRecipeIngredient)ItemStackRecipeIngredient.from((ItemLike)ingredient1, (int)ingredient1Amount), (IRecipeResult)FluidStackRecipeResult.from((FluidStack)new FluidStack(result, resultAmount)), FluidizerSolidMixingRecipe::getLabel).build(builder, idBuilder.buildWithSuffix("_2"));
    }

    private void fluidMixing(Consumer<FinishedRecipe> builder, String name, Supplier<? extends Fluid> ingredient1, int ingredient1Amount, Supplier<? extends Fluid> ingredient2, int ingredient2Amount, Supplier<? extends Fluid> result, int resultAmount) {
        this.fluidMixing(builder, name, ingredient1.get(), ingredient1Amount, ingredient2.get(), ingredient2Amount, result.get(), resultAmount);
    }

    private void fluidMixing(Consumer<FinishedRecipe> builder, String name, Fluid ingredient1, int ingredient1Amount, Fluid ingredient2, int ingredient2Amount, Fluid result, int resultAmount) {
        ResourceLocationBuilder idBuilder = this.fluidizerFluidMixingRoot().append(name);
        new TwoToOneRecipeBuilder(IFluidizerRecipe.Type.FluidMixing.getRecipeId(), (IRecipeIngredient)FluidStackRecipeIngredient.from((Fluid)ingredient1, (int)ingredient1Amount), (IRecipeIngredient)FluidStackRecipeIngredient.from((Fluid)ingredient2, (int)ingredient2Amount), (IRecipeResult)FluidStackRecipeResult.from((FluidStack)new FluidStack(result, resultAmount)), FluidizerFluidMixingRecipe::getLabel).build(builder, idBuilder.buildWithSuffix("_1"));
        new TwoToOneRecipeBuilder(IFluidizerRecipe.Type.FluidMixing.getRecipeId(), (IRecipeIngredient)FluidStackRecipeIngredient.from((Fluid)ingredient2, (int)ingredient2Amount), (IRecipeIngredient)FluidStackRecipeIngredient.from((Fluid)ingredient1, (int)ingredient1Amount), (IRecipeResult)FluidStackRecipeResult.from((FluidStack)new FluidStack(result, resultAmount)), FluidizerFluidMixingRecipe::getLabel).build(builder, idBuilder.buildWithSuffix("_2"));
    }

    private void casing(Consumer<FinishedRecipe> builder) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (Supplier)Content.Items.FLUIDIZER_CASING).m_206416_(Character.valueOf('I'), Tags.Items.INGOTS_IRON).m_126127_(Character.valueOf('W'), (ItemLike)Items.f_42447_).m_206416_(Character.valueOf('C'), ContentTags.Items.INGOTS_YELLORIUM).m_126130_("ICI").m_126130_("CWC").m_126130_("ICI").m_126132_("has_item", (CriterionTriggerInstance)FluidizerRecipesDataProvider.m_206406_(ContentTags.Items.INGOTS_YELLORIUM)).m_126140_(builder, this.fluidizerRoot().buildWithSuffix("casing"));
    }

    private void glass(Consumer<FinishedRecipe> builder) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (Supplier)Content.Items.FLUIDIZER_GLASS).m_126127_(Character.valueOf('C'), (ItemLike)Content.Items.FLUIDIZER_CASING.get()).m_206416_(Character.valueOf('G'), Tags.Items.GLASS).m_126130_("GCG").m_126132_("has_item", (CriterionTriggerInstance)FluidizerRecipesDataProvider.m_125977_((ItemLike)((ItemLike)Content.Items.FLUIDIZER_CASING.get()))).m_126140_(builder, this.fluidizerRoot().buildWithSuffix("glass"));
    }

    private void controller(Consumer<FinishedRecipe> builder) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, (Supplier)Content.Items.FLUIDIZER_CONTROLLER).m_126127_(Character.valueOf('C'), (ItemLike)Content.Items.FLUIDIZER_CASING.get()).m_206416_(Character.valueOf('Y'), ContentTags.Items.INGOTS_YELLORIUM).m_206416_(Character.valueOf('P'), Tags.Items.DUSTS_GLOWSTONE).m_206416_(Character.valueOf('E'), Tags.Items.GEMS_EMERALD).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42351_).m_126130_("CXC").m_126130_("YEY").m_126130_("CPC").m_126132_("has_item", (CriterionTriggerInstance)FluidizerRecipesDataProvider.m_125977_((ItemLike)((ItemLike)Content.Items.FLUIDIZER_CASING.get()))).m_126132_("has_item2", (CriterionTriggerInstance)FluidizerRecipesDataProvider.m_206406_((TagKey)Tags.Items.DUSTS_GLOWSTONE)).m_126140_(builder, this.fluidizerRoot().buildWithSuffix("controller"));
    }

    private void port(Consumer<FinishedRecipe> builder, String name, Supplier<? extends ItemLike> result, ItemLike item1, TagKey<Item> tag2, TagKey<Item> tag3) {
        this.shaped(RecipeCategory.BUILDING_BLOCKS, result).m_126127_(Character.valueOf('C'), (ItemLike)Content.Items.FLUIDIZER_CASING.get()).m_126127_(Character.valueOf('1'), item1).m_206416_(Character.valueOf('2'), tag2).m_206416_(Character.valueOf('3'), tag3).m_126130_("C2C").m_126130_("313").m_126130_("C2C").m_126132_("has_item", (CriterionTriggerInstance)FluidizerRecipesDataProvider.m_125977_((ItemLike)((ItemLike)Content.Items.FLUIDIZER_CASING.get()))).m_126132_("has_item2", (CriterionTriggerInstance)FluidizerRecipesDataProvider.m_125977_((ItemLike)item1)).m_126140_(builder, this.fluidizerRoot().buildWithSuffix(name));
    }
}

