/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.helper;

import com.blakebr0.cucumber.Cucumber;
import com.blakebr0.cucumber.event.RecipeManagerLoadingEvent;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class RecipeHelper {
    private static RecipeManager recipeManager;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAddReloadListeners(AddReloadListenerEvent event) {
        recipeManager = event.getServerResources().m_206887_();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRecipesUpdated(RecipesUpdatedEvent event) {
        recipeManager = event.getRecipeManager();
    }

    public static RecipeManager getRecipeManager() {
        return recipeManager;
    }

    public static Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> getRecipes() {
        return RecipeHelper.getRecipeManager().f_44007_;
    }

    public static <C extends Container, T extends Recipe<C>> Map<ResourceLocation, T> getRecipes(RecipeType<T> type) {
        return RecipeHelper.getRecipeManager().m_44054_(type);
    }

    @Deprecated(forRemoval=true)
    public static void addRecipe(Recipe<?> recipe) {
        if (RecipeHelper.recipeManager.f_44007_ instanceof ImmutableMap) {
            RecipeHelper.recipeManager.f_44007_ = new HashMap(RecipeHelper.recipeManager.f_44007_);
            RecipeHelper.recipeManager.f_44007_.replaceAll((t, v) -> new HashMap((Map)RecipeHelper.recipeManager.f_44007_.get(t)));
        }
        if (RecipeHelper.recipeManager.f_199900_ instanceof ImmutableMap) {
            RecipeHelper.recipeManager.f_199900_ = new HashMap(RecipeHelper.recipeManager.f_199900_);
        }
        RecipeHelper.getRecipeManager().f_44007_.computeIfAbsent(recipe.m_6671_(), t -> new HashMap()).put(recipe.m_6423_(), recipe);
        RecipeHelper.getRecipeManager().f_199900_.put(recipe.m_6423_(), recipe);
    }

    public static void fireRecipeManagerLoadedEvent(RecipeManager manager, Map<RecipeType<?>, ImmutableMap.Builder<ResourceLocation, Recipe<?>>> map, ImmutableMap.Builder<ResourceLocation, Recipe<?>> builder) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ArrayList recipes = new ArrayList();
        try {
            MinecraftForge.EVENT_BUS.post((Event)new RecipeManagerLoadingEvent(manager, recipes));
        }
        catch (Exception e) {
            Cucumber.LOGGER.error("An error occurred while firing RecipeManagerLoadingEvent", (Throwable)e);
        }
        for (Recipe<?> recipe : recipes) {
            map.computeIfAbsent(recipe.m_6671_(), t -> ImmutableMap.builder()).put((Object)recipe.m_6423_(), recipe);
            builder.put((Object)recipe.m_6423_(), recipe);
        }
        Cucumber.LOGGER.info("Cucumber registered {} recipes in {} ms", (Object)recipes.size(), (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
    }

    public static void fireRecipeManagerLoadedEventKubeJSEdition(RecipeManager manager) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ArrayList recipes = new ArrayList();
        try {
            MinecraftForge.EVENT_BUS.post((Event)new RecipeManagerLoadingEvent(manager, recipes));
        }
        catch (Exception e) {
            Cucumber.LOGGER.error("An error occurred while firing RecipeManagerLoadingEvent", (Throwable)e);
        }
        for (Recipe<?> recipe : recipes) {
            try {
                RecipeHelper.addRecipe(recipe);
            }
            catch (UnsupportedOperationException e) {
                RecipeHelper.recipeManager.f_44007_ = new HashMap(RecipeHelper.recipeManager.f_44007_);
                RecipeHelper.recipeManager.f_44007_.replaceAll((t, v) -> new HashMap((Map)RecipeHelper.recipeManager.f_44007_.get(t)));
                RecipeHelper.recipeManager.f_199900_ = new HashMap(RecipeHelper.recipeManager.f_199900_);
                manager.f_44007_.computeIfAbsent(recipe.m_6671_(), t -> new HashMap()).put(recipe.m_6423_(), recipe);
                manager.f_199900_.put(recipe.m_6423_(), recipe);
            }
        }
        Cucumber.LOGGER.info("Cucumber registered {} recipes in {} ms (KUBEJS MODE)", (Object)recipes.size(), (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
    }
}

