/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.mixin;

import com.illusivesoulworks.polymorph.PolymorphConstants;
import com.illusivesoulworks.polymorph.common.integration.PolymorphIntegrations;
import com.illusivesoulworks.polymorph.platform.Services;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.Mixins;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinErrorHandler;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class IntegratedMixinPlugin
implements IMixinConfigPlugin,
IMixinErrorHandler {
    private static final Map<String, String> CLASS_TO_MOD = new HashMap<String, String>();

    public void onLoad(String mixinPackage) {
        Mixins.registerErrorHandlerClass((String)"com.illusivesoulworks.polymorph.mixin.IntegratedMixinPlugin");
        PolymorphIntegrations.loadConfig();
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        for (Map.Entry<String, String> entry : CLASS_TO_MOD.entrySet()) {
            String modId = entry.getValue();
            if (!targetClassName.startsWith(entry.getKey())) continue;
            return PolymorphIntegrations.isActive(modId) && Services.PLATFORM.isModFileLoaded(modId);
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public IMixinErrorHandler.ErrorAction onPrepareError(IMixinConfig config, Throwable th, IMixinInfo mixin, IMixinErrorHandler.ErrorAction action) {
        return null;
    }

    public IMixinErrorHandler.ErrorAction onApplyError(String targetClassName, Throwable th, IMixinInfo mixin, IMixinErrorHandler.ErrorAction action) {
        if (mixin.getConfig().getMixinPackage().startsWith("com.illusivesoulworks.polymorph.mixin.integration")) {
            String modId = "{MOD NOT FOUND - THIS SHOULD NOT HAPPEN}";
            for (Map.Entry<String, String> entry : CLASS_TO_MOD.entrySet()) {
                String id = entry.getValue();
                if (!targetClassName.startsWith(entry.getKey())) continue;
                modId = id;
                break;
            }
            PolymorphIntegrations.disable(modId);
            PolymorphConstants.LOG.error("Polymorph encountered an error while transforming: {}", (Object)targetClassName);
            PolymorphConstants.LOG.error("The integration module for {} will be disabled.", (Object)modId);
            PolymorphConstants.LOG.error("Please report this bug to Polymorph only, do not report this to {}.", (Object)modId);
            return IMixinErrorHandler.ErrorAction.WARN;
        }
        return null;
    }

    static {
        CLASS_TO_MOD.put("shadows.fastbench.", PolymorphIntegrations.Mod.FASTWORKBENCH.getId());
        CLASS_TO_MOD.put("shadows.fastsuite.", PolymorphIntegrations.Mod.FASTSUITE.getId());
    }
}

