/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.octolib.config.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.jayway.jsonpath.JsonPath;
import it.hurts.sskirillss.octolib.config.api.IOctoConfig;
import it.hurts.sskirillss.octolib.config.api.events.ConfigLoadEvent;
import it.hurts.sskirillss.octolib.config.api.events.ConfigSaveEvent;
import it.hurts.sskirillss.octolib.config.data.ConfigContext;
import it.hurts.sskirillss.octolib.config.storage.ConfigStorage;
import it.hurts.sskirillss.octolib.config.utils.ConfigUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;

public class OctoConfig {
    private final IOctoConfig constructor;
    private ConfigContext schema;
    private ConfigContext data;

    public OctoConfig(IOctoConfig constructor) {
        this.constructor = constructor;
    }

    public final OctoConfig saveToFile() {
        Path path = this.constructor.getPath();
        File file = path.toFile().getCanonicalFile().getParentFile();
        if (file.isDirectory() || file.mkdirs()) {
            ConfigSaveEvent event = new ConfigSaveEvent(this);
            ModLoader.get().postEventWrapContainerInModOrder((Event)event);
            if (!event.isCanceled()) {
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    ConfigUtils.SERIALIZER.toJson((JsonElement)ConfigUtils.SERIALIZER.fromJson(event.getConfig().getData().jsonString(), JsonObject.class), (Appendable)writer);
                    ((Writer)writer).flush();
                }
            }
        }
        return this;
    }

    public final OctoConfig loadFromFile() {
        if (!Files.exists(this.constructor.getPath(), new LinkOption[0])) {
            this.saveToFile();
        }
        ConfigLoadEvent event = new ConfigLoadEvent(this, new ConfigContext(JsonPath.parse((File)this.constructor.getPath().toFile())));
        ModLoader.get().postEventWrapContainerInModOrder((Event)event);
        if (!event.isCanceled()) {
            this.setData(event.getContext());
        }
        return this;
    }

    public final OctoConfig reload() {
        this.loadFromFile();
        ConfigStorage.set(this);
        return this;
    }

    public final OctoConfig getOrSetup() {
        OctoConfig config = ConfigStorage.get(this.constructor);
        return config == null ? (OctoConfig)this.constructor.setup() : config;
    }

    public <T> T get(String path) {
        Object value = this.data.get(path);
        Object defaultValue = this.schema.get(path);
        return value == null || value instanceof JsonNull ? (defaultValue == null || defaultValue instanceof JsonNull ? null : (T)defaultValue) : (T)value;
    }

    public <T> T get(String path, Class<T> type) {
        T value = this.data.get(path, type);
        T defaultValue = this.schema.get(path, type);
        return value == null || value instanceof JsonNull ? (defaultValue == null || defaultValue instanceof JsonNull ? null : (T)defaultValue) : (T)value;
    }

    public String getString(String path) {
        return this.get(path, String.class);
    }

    public Double getDouble(String path) {
        return this.get(path, Double.class);
    }

    public Float getFloat(String path) {
        return this.get(path, Float.class);
    }

    public int getInt(String path) {
        return this.get(path, Integer.class);
    }

    public boolean getBoolean(String path) {
        return this.get(path, Boolean.class);
    }

    public short getShort(String path) {
        return this.get(path, Short.class);
    }

    public byte getByte(String path) {
        return this.get(path, Byte.class);
    }

    public long getLong(String path) {
        return this.get(path, Long.class);
    }

    public IOctoConfig getConstructor() {
        return this.constructor;
    }

    public ConfigContext getSchema() {
        return this.schema;
    }

    public ConfigContext getData() {
        return this.data;
    }

    public void setSchema(ConfigContext schema) {
        this.schema = schema;
    }

    public void setData(ConfigContext data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OctoConfig)) {
            return false;
        }
        OctoConfig other = (OctoConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IOctoConfig this$constructor = this.getConstructor();
        IOctoConfig other$constructor = other.getConstructor();
        if (this$constructor == null ? other$constructor != null : !this$constructor.equals(other$constructor)) {
            return false;
        }
        ConfigContext this$schema = this.getSchema();
        ConfigContext other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !((Object)this$schema).equals(other$schema)) {
            return false;
        }
        ConfigContext this$data = this.getData();
        ConfigContext other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OctoConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IOctoConfig $constructor = this.getConstructor();
        result = result * 59 + ($constructor == null ? 43 : $constructor.hashCode());
        ConfigContext $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : ((Object)$schema).hashCode());
        ConfigContext $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "OctoConfig(constructor=" + this.getConstructor() + ", schema=" + this.getSchema() + ", data=" + this.getData() + ")";
    }
}

