/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.octolib.config.api;

import com.jayway.jsonpath.JsonPath;
import it.hurts.sskirillss.octolib.config.api.events.ConfigConstructEvent;
import it.hurts.sskirillss.octolib.config.data.ConfigContext;
import it.hurts.sskirillss.octolib.config.data.OctoConfig;
import it.hurts.sskirillss.octolib.config.storage.ConfigStorage;
import it.hurts.sskirillss.octolib.config.utils.ConfigUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;

public interface IOctoConfig {
    public Path getPath();

    @Nullable
    default public <T extends IOctoConfig> T setup() {
        OctoConfig config = new OctoConfig(this);
        ConfigConstructEvent event = new ConfigConstructEvent(this, new ConfigContext(JsonPath.parse((String)ConfigUtils.SERIALIZER.toJson((Object)this))));
        ModLoader.get().postEventWrapContainerInModOrder((Event)event);
        if (!event.isCanceled()) {
            ConfigContext context = event.getContext();
            config.setSchema(context);
            if (Files.exists(this.getPath(), new LinkOption[0])) {
                config.loadFromFile();
            } else {
                config.setData(context);
                config.saveToFile();
            }
            ConfigStorage.set(config);
        }
        return (T)event.getConstructor();
    }
}

