/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.carpeted;

import net.mehvahdjukaar.carpeted.Carpeted;
import net.mehvahdjukaar.carpeted.client.CarpetStairsModel;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.client.model.CustomModelLoader;
import net.mehvahdjukaar.moonlight.api.client.model.NestedModelLoader;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CarpetedClient {
    public static final ResourceLocation LABEL_MODEL = Carpeted.res("block/label");

    public static void init() {
        ClientHelper.addSpecialModelRegistration(CarpetedClient::registerSpecialModels);
        ClientHelper.addModelLoaderRegistration(CarpetedClient::registerModelLoaders);
        ClientHelper.addBlockColorsRegistration(CarpetedClient::registerBlockColors);
    }

    public static void setup() {
        ClientHelper.registerRenderType((Block)Carpeted.CARPET_STAIRS.get(), (RenderType)RenderType.m_110466_());
    }

    private static void registerSpecialModels(ClientHelper.SpecialModelEvent event) {
        event.register(LABEL_MODEL);
    }

    private static void registerModelLoaders(ClientHelper.ModelLoaderEvent event) {
        event.register(Carpeted.res("carpet_overlay"), (CustomModelLoader)new NestedModelLoader("carpet", CarpetStairsModel::new));
    }

    private static void registerBlockColors(ClientHelper.BlockColorEvent event) {
        event.register((BlockColor)new MimicBlockColor(), new Block[]{Carpeted.CARPET_STAIRS.get()});
    }

    public static class MimicBlockColor
    implements BlockColor {
        public int m_92566_(BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tint) {
            return MimicBlockColor.col(state, world, pos, tint);
        }

        public static int col(BlockState state, BlockAndTintGetter level, BlockPos pos, int tint) {
            IBlockHolder tile;
            BlockState mimic;
            BlockEntity blockEntity;
            if (level != null && pos != null && (blockEntity = level.m_7702_(pos)) instanceof IBlockHolder && (mimic = (tile = (IBlockHolder)blockEntity).getHeldBlock()) != null && !mimic.m_155947_()) {
                return Minecraft.m_91087_().m_91298_().m_92577_(mimic, level, pos, tint);
            }
            return -1;
        }
    }
}

