/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.scouter.netherdepthsupgrade.structures.NDUStructures;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.slf4j.Logger;

public class NetherFortressPiece
extends Structure {
    private static final Logger LOGGER = LogUtils.getLogger();
    static Random rand = new Random();
    public static final Codec<NetherFortressPiece> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NetherFortressPiece.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, NetherFortressPiece::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public NetherFortressPiece(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        int y = rand.nextInt(15, 30);
        BlockPos centerPos = new BlockPos(context.f_226628_().m_45604_(), y, context.f_226628_().m_45605_());
        BlockPos blockpos = context.f_226628_().m_151394_(0);
        blockpos = blockpos.m_7918_(0, y, 0);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        ChunkGenerator chunkGenerator = context.f_226622_();
        mutable = mutable.m_122190_((Vec3i)centerPos);
        NoiseColumn columnOfBlocks = chunkGenerator.m_214184_(blockpos.m_123341_(), blockpos.m_123343_(), context.f_226629_(), context.f_226624_());
        BlockState state = columnOfBlocks.m_183556_(blockpos.m_123342_());
        if (!state.m_60819_().m_192917_((Fluid)Fluids.f_76195_)) {
            return Optional.empty();
        }
        while ((state.m_60819_().m_192917_((Fluid)Fluids.f_76195_) || blockpos.m_123342_() > 0) && (state = columnOfBlocks.m_183556_((blockpos = blockpos.m_7495_()).m_123342_())).m_60819_().m_192917_((Fluid)Fluids.f_76195_)) {
        }
        Optional structurePiecesGenerator = JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockpos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
        if (structurePiecesGenerator.isPresent()) {
            // empty if block
        }
        return structurePiecesGenerator;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)NDUStructures.NETHER_FORTRESS_PIECE.get();
    }
}

