/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.ai;

import com.scouter.netherdepthsupgrade.entity.AbstractLavaFish;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class LavaFishJumpGoal
extends JumpGoal {
    private static final int[] STEPS_TO_CHECK = new int[]{0, 1, 4, 5, 6, 7, 10, 11};
    private final AbstractLavaFish lavaAnimal;
    private final int interval;
    private boolean breached;

    public LavaFishJumpGoal(AbstractLavaFish lavaAnimal, int pInterval) {
        this.lavaAnimal = lavaAnimal;
        this.interval = LavaFishJumpGoal.m_186073_((int)pInterval);
    }

    public boolean m_8036_() {
        if (this.lavaAnimal.m_217043_().m_188503_(this.interval) != 0) {
            return false;
        }
        Direction direction = this.lavaAnimal.m_6374_();
        int i = direction.m_122429_();
        int j = direction.m_122431_();
        BlockPos blockpos = this.lavaAnimal.m_20183_();
        for (int k : STEPS_TO_CHECK) {
            if (this.lavaIsClear(blockpos, i, j, k) && this.surfaceIsClear(blockpos, i, j, k)) continue;
            return false;
        }
        return true;
    }

    private boolean lavaIsClear(BlockPos pPos, int pDx, int pDz, int pScale) {
        BlockPos blockpos = pPos.m_7918_(pDx * pScale, 0, pDz * pScale);
        return this.lavaAnimal.m_9236_().m_6425_(blockpos).m_205070_(FluidTags.f_13132_) && !this.lavaAnimal.m_9236_().m_8055_(blockpos).m_280555_();
    }

    private boolean surfaceIsClear(BlockPos pPos, int pDx, int pDz, int pScale) {
        return this.lavaAnimal.m_9236_().m_8055_(pPos.m_7918_(pDx * pScale, 1, pDz * pScale)).m_60795_() && this.lavaAnimal.m_9236_().m_8055_(pPos.m_7918_(pDx * pScale, 2, pDz * pScale)).m_60795_();
    }

    public boolean m_8045_() {
        double d0 = this.lavaAnimal.m_20184_().f_82480_;
        return !(d0 * d0 < (double)0.03f && this.lavaAnimal.m_146909_() != 0.0f && Math.abs(this.lavaAnimal.m_146909_()) < 10.0f && this.lavaAnimal.m_20077_() || this.lavaAnimal.m_20096_());
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        Direction direction = this.lavaAnimal.m_6374_();
        this.lavaAnimal.m_20256_(this.lavaAnimal.m_20184_().m_82520_((double)direction.m_122429_() * 1.1, 0.7, (double)direction.m_122431_() * 1.1));
        this.lavaAnimal.m_21573_().m_26573_();
        this.lavaAnimal.setIsJumping(true);
    }

    public void m_8041_() {
        this.lavaAnimal.m_146926_(0.0f);
        this.lavaAnimal.setIsJumping(false);
        this.lavaAnimal.fishSwimGoal.m_25751_();
    }

    public void m_8037_() {
        boolean flag = this.breached;
        if (!flag) {
            FluidState fluidstate = this.lavaAnimal.m_9236_().m_6425_(this.lavaAnimal.m_20183_());
            this.breached = fluidstate.m_205070_(FluidTags.f_13132_);
        }
        if (this.breached && !flag) {
            this.lavaAnimal.m_5496_(SoundEvents.f_11805_, 1.0f, 1.0f);
        }
        Vec3 vec3 = this.lavaAnimal.m_20184_();
        if (vec3.f_82480_ * vec3.f_82480_ < (double)0.03f && this.lavaAnimal.m_146909_() != 0.0f) {
            this.lavaAnimal.m_146926_(Mth.m_14189_((float)this.lavaAnimal.m_146909_(), (float)0.0f, (float)0.2f));
        } else if (vec3.m_82553_() > (double)1.0E-5f) {
            double d0 = vec3.m_165924_();
            double d1 = Math.atan2(-vec3.f_82480_, d0) * 57.2957763671875;
            this.lavaAnimal.m_146926_((float)d1);
        }
    }
}

