/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.blocks;

import com.scouter.netherdepthsupgrade.blocks.GrowingLavaPlantHeadBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class GrowingLavaPlantBlock
extends Block {
    protected final Direction growthDirection;
    protected final boolean scheduleFluidTicks;
    protected final VoxelShape shape;

    public GrowingLavaPlantBlock(BlockBehaviour.Properties pProperties, Direction pGrowthDirection, VoxelShape pShape, boolean pScheduleFluidTicks) {
        super(pProperties);
        this.growthDirection = pGrowthDirection;
        this.shape = pShape;
        this.scheduleFluidTicks = pScheduleFluidTicks;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_().m_121945_(this.growthDirection));
        return !blockstate.m_60713_((Block)this.getHeadBlock()) && !blockstate.m_60713_(this.getBodyBlock()) ? this.getStateForPlacement((LevelAccessor)pContext.m_43725_()) : this.getBodyBlock().m_49966_();
    }

    public BlockState getStateForPlacement(LevelAccessor pLevel) {
        return this.m_49966_();
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_121945_(this.growthDirection.m_122424_());
        BlockState blockstate = pLevel.m_8055_(blockpos);
        if (!this.canAttachTo(blockstate)) {
            return false;
        }
        return blockstate.m_60713_((Block)this.getHeadBlock()) || blockstate.m_60713_(this.getBodyBlock()) || blockstate.m_60783_((BlockGetter)pLevel, blockpos, this.growthDirection);
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRand) {
        if (!pState.m_60710_((LevelReader)pLevel, pPos)) {
            pLevel.m_46961_(pPos, true);
        }
    }

    protected boolean canAttachTo(BlockState pState) {
        return true;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shape;
    }

    protected abstract GrowingLavaPlantHeadBlock getHeadBlock();

    protected abstract Block getBodyBlock();
}

