/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.misc;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2FloatFunction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class Panic<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26381_, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_217768_, (Object)MemoryStatus.REGISTERED)});
    protected BiPredicate<E, DamageSource> shouldPanicPredicate = (entity, damageSource) -> entity.m_203117_() || entity.m_6060_() || damageSource.m_7639_() instanceof LivingEntity;
    protected Object2FloatFunction<E> speedMod = entity -> 1.25f;
    protected SquareRadius radius = new SquareRadius(5.0, 4.0);
    protected BiFunction<E, DamageSource, Integer> panicFor = (entity, damageSource) -> entity.m_217043_().m_216339_(100, 120);
    protected Vec3 targetPos = null;
    protected int panicEndTime = 0;

    public Panic<E> panicIf(BiPredicate<E, DamageSource> predicate) {
        this.shouldPanicPredicate = predicate;
        return this;
    }

    public Panic<E> panicFor(BiFunction<E, DamageSource, Integer> function) {
        this.panicFor = function;
        return this;
    }

    public Panic<E> speedMod(Object2FloatFunction<E> speedModifier) {
        this.speedMod = speedModifier;
        return this;
    }

    public Panic<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public Panic<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        if (!this.shouldPanicPredicate.test(entity, (DamageSource)BrainUtils.getMemory(entity, MemoryModuleType.f_26381_))) {
            return false;
        }
        this.setPanicTarget(entity);
        return this.targetPos != null;
    }

    @Override
    protected boolean m_7773_(long gameTime) {
        return false;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return ((PathfinderMob)entity).f_19797_ < this.panicEndTime;
    }

    @Override
    protected void start(E entity) {
        BrainUtils.setMemory(entity, MemoryModuleType.f_26370_, new WalkTarget(this.targetPos, ((Float)this.speedMod.apply(entity)).floatValue(), 0));
        BrainUtils.setMemory(entity, MemoryModuleType.f_217768_, Boolean.valueOf(true));
        this.panicEndTime = ((PathfinderMob)entity).f_19797_ + this.panicFor.apply(entity, (DamageSource)BrainUtils.getMemory(entity, MemoryModuleType.f_26381_));
    }

    @Override
    protected void tick(E entity) {
        if (entity.m_21573_().m_26571_()) {
            this.targetPos = null;
            this.setPanicTarget(entity);
            if (this.targetPos != null) {
                BrainUtils.clearMemory(entity, MemoryModuleType.f_26377_);
                BrainUtils.setMemory(entity, MemoryModuleType.f_26370_, new WalkTarget(this.targetPos, ((Float)this.speedMod.apply(entity)).floatValue(), 1));
            }
        }
    }

    @Override
    protected void stop(E entity) {
        this.targetPos = null;
        this.panicEndTime = 0;
        BrainUtils.setMemory(entity, MemoryModuleType.f_217768_, Boolean.valueOf(false));
    }

    @Nullable
    protected Vec3 findNearbyWater(E entity) {
        BlockPos pos = entity.m_20183_();
        Level level = entity.m_9236_();
        return !level.m_8055_(pos).m_60812_((BlockGetter)level, pos).m_83281_() ? null : (Vec3)BlockPos.m_121930_((BlockPos)entity.m_20183_(), (int)((int)this.radius.xzRadius()), (int)((int)this.radius.yRadius()), checkPos -> level.m_6425_(checkPos).m_205070_(FluidTags.f_13131_)).map(Vec3::m_82539_).orElse(null);
    }

    protected void setPanicTarget(E entity) {
        if (entity.m_6060_()) {
            this.targetPos = this.findNearbyWater(entity);
        }
        if (this.targetPos == null) {
            Entity entity2;
            DamageSource lastDamage = (DamageSource)BrainUtils.getMemory(entity, MemoryModuleType.f_26381_);
            if (lastDamage != null && (entity2 = lastDamage.m_7639_()) instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity2;
                this.targetPos = DefaultRandomPos.m_148407_(entity, (int)((int)this.radius.xzRadius()), (int)((int)this.radius.yRadius()), (Vec3)attacker.m_20182_());
            }
            if (this.targetPos == null) {
                this.targetPos = DefaultRandomPos.m_148403_(entity, (int)((int)this.radius.xzRadius()), (int)((int)this.radius.yRadius()));
            }
        }
    }
}

