/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.tempad;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.ArrayList;
import java.util.List;
import me.codexadrian.tempad.api.options.TempadOption;
import me.codexadrian.tempad.api.options.impl.DurabilityOption;
import me.codexadrian.tempad.client.config.TempadClientConfig;
import me.codexadrian.tempad.common.Tempad;
import me.codexadrian.tempad.common.config.TempadConfig;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.data.TempadLocationHandler;
import me.codexadrian.tempad.common.entity.TimedoorEntity;
import me.codexadrian.tempad.common.network.NetworkHandler;
import me.codexadrian.tempad.common.network.messages.OpenTempadScreenPacket;
import me.codexadrian.tempad.common.registry.TempadRegistry;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TempadItem
extends Item {
    private final TempadOption option;
    private final int fuelCost;
    private final int fuelCapacity;

    public TempadItem(Item.Properties properties, TempadOption option, int fuelCost, int fuelCapacity) {
        super(option.apply(properties, fuelCost, fuelCapacity));
        this.option = option;
        this.fuelCost = fuelCost;
        this.fuelCapacity = fuelCapacity;
    }

    public TempadOption getOption() {
        return this.option;
    }

    public int getFuelCost() {
        return this.fuelCost;
    }

    public int getFuelCapacity() {
        return this.fuelCapacity;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand interactionHand) {
        ItemStack stack = player.m_21120_(interactionHand);
        if (!level.f_46443_) {
            OpenTempadScreenPacket packet = new OpenTempadScreenPacket(new ArrayList<LocationData>(TempadLocationHandler.getLocations(level, player.m_20148_()).values()), interactionHand);
            NetworkHandler.CHANNEL.sendToPlayer((Packet)packet, player);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public static void summonTimeDoor(LocationData locationData, Player player, int color) {
        TimedoorEntity timedoor = new TimedoorEntity((EntityType<TimedoorEntity>)((EntityType)TempadRegistry.TIMEDOOR_ENTITY.get()), player.m_9236_());
        Direction dir = player.m_6350_();
        timedoor.setColor(color);
        timedoor.setLocation(locationData);
        timedoor.setOwner(player.m_20148_());
        Vec3 position = player.m_20182_();
        timedoor.m_6034_(position.m_7096_() + (double)(dir.m_122429_() * TempadConfig.distanceFromPlayer), position.m_7098_(), position.m_7094_() + (double)(dir.m_122431_() * TempadConfig.distanceFromPlayer));
        timedoor.m_146922_(dir.m_122424_().m_122435_());
        player.m_9236_().m_7967_((Entity)timedoor);
        timedoor.m_216990_(Tempad.TIMEDOOR_SOUND.get());
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        this.getOption().addToolTip(stack, level, components, flag);
    }

    public int m_142159_(@NotNull ItemStack $$0) {
        return TempadClientConfig.color;
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return this.getOption().isDurabilityBarVisible(stack);
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return this.getOption().durabilityBarWidth(stack);
    }

    public boolean m_41465_() {
        return this.getOption() instanceof DurabilityOption;
    }

    @PlatformOnly(value={"forge"})
    public boolean isDamaged(@NotNull ItemStack stack) {
        return this.m_41465_() && stack.m_41773_() > 0;
    }
}

