/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.data;

import com.teamresourceful.resourcefullib.common.utils.SaveHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import me.codexadrian.tempad.api.locations.LocationsApi;
import me.codexadrian.tempad.common.data.LocationData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;

public class TempadLocationHandler
extends SaveHandler {
    private static final TempadLocationHandler CLIENT_ONLY = new TempadLocationHandler();
    private final Map<UUID, Map<UUID, LocationData>> locations = new HashMap<UUID, Map<UUID, LocationData>>();

    public void addLocation(UUID player, LocationData location) {
        if (!this.locations.containsKey(player)) {
            this.locations.put(player, new LinkedHashMap());
        }
        this.locations.get(player).put(location.getId(), location);
    }

    public static void addLocation(Level level, UUID player, LocationData location) {
        TempadLocationHandler handler = TempadLocationHandler.read(level);
        handler.addLocation(player, location);
    }

    public static void removeLocation(Level level, UUID player, UUID location) {
        TempadLocationHandler handler = TempadLocationHandler.read(level);
        if (handler.locations.containsKey(player)) {
            handler.locations.get(player).remove(location);
        }
    }

    public static Map<UUID, LocationData> getLocations(Level level, UUID player) {
        TempadLocationHandler handler = TempadLocationHandler.read(level);
        HashMap<UUID, LocationData> orDefault = new HashMap<UUID, LocationData>(handler.locations.getOrDefault(player, Collections.emptyMap()));
        LocationsApi.gatherLocations(level, player, orDefault);
        return orDefault;
    }

    public static LocationData getLocation(Level level, UUID player, UUID location) {
        return TempadLocationHandler.getLocations(level, player).get(location);
    }

    public static TempadLocationHandler read(Level level) {
        return (TempadLocationHandler)TempadLocationHandler.read((Level)level, (SaveHandler)CLIENT_ONLY, TempadLocationHandler::new, (String)"tempad_locations");
    }

    public static boolean containsLocation(Level level, UUID player, UUID location) {
        return TempadLocationHandler.getLocations(level, player).containsKey(location);
    }

    public void loadData(CompoundTag tag) {
        for (String playerId : tag.m_128431_()) {
            UUID player = UUID.fromString(playerId);
            for (Tag list : tag.m_128437_(playerId, 10)) {
                if (!(list instanceof CompoundTag)) continue;
                CompoundTag compound = (CompoundTag)list;
                this.addLocation(player, LocationData.fromTag(compound));
            }
        }
    }

    public void saveData(CompoundTag tag) {
        this.locations.forEach((player, locationMap) -> {
            ListTag playerTag = new ListTag();
            locationMap.forEach((uuid, location) -> playerTag.add((Object)location.toTag()));
            tag.m_128365_(player.toString(), (Tag)playerTag);
        });
    }

    public boolean m_77764_() {
        return true;
    }
}

