/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.common.compat.botarium.options;

import earth.terrarium.botarium.common.energy.EnergyApi;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import java.util.List;
import me.codexadrian.tempad.api.options.TempadOption;
import me.codexadrian.tempad.api.options.TempadOptionApi;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Range;

public class EnergyOption
extends TempadOption {
    @Override
    public boolean canTimedoorOpen(Player player, ItemStack stack) {
        EnergyContainer energyStorage = EnergyApi.getItemEnergyContainer((ItemStackHolder)new ItemStackHolder(stack));
        if (energyStorage == null) {
            return false;
        }
        return energyStorage.getStoredEnergy() > (long)TempadOptionApi.getFuelCost(stack);
    }

    @Override
    public void addToolTip(ItemStack stack, Level level, List<Component> components, TooltipFlag flag) {
        EnergyContainer energyStorage = EnergyApi.getItemEnergyContainer((ItemStackHolder)new ItemStackHolder(stack));
        if (energyStorage == null) {
            return;
        }
        components.add((Component)Component.m_237110_((String)"tempad_option.tempad.energy", (Object[])new Object[]{energyStorage.getStoredEnergy(), energyStorage.getMaxCapacity()}).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public void onTimedoorOpen(Player player, InteractionHand hand, ItemStack stack) {
        EnergyContainer energyStorage = EnergyApi.getItemEnergyContainer((ItemStackHolder)new ItemStackHolder(stack));
        if (energyStorage == null) {
            return;
        }
        energyStorage.extractEnergy((long)TempadOptionApi.getFuelCost(stack), false);
    }

    @Override
    public boolean isDurabilityBarVisible(ItemStack stack) {
        return true;
    }

    @Override
    public @Range(from=0L, to=13L) int durabilityBarWidth(ItemStack stack) {
        EnergyContainer energyStorage = EnergyApi.getItemEnergyContainer((ItemStackHolder)new ItemStackHolder(stack));
        if (energyStorage == null) {
            return 0;
        }
        return (int)((double)energyStorage.getStoredEnergy() / (double)energyStorage.getMaxCapacity() * 13.0);
    }
}

