/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import java.util.List;
import me.codexadrian.tempad.client.config.TempadClientConfig;
import me.codexadrian.tempad.client.gui.OptionsScreen;
import me.codexadrian.tempad.client.gui.RunProgramScreen;
import me.codexadrian.tempad.client.widgets.TextButton;
import me.codexadrian.tempad.common.data.LocationData;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import org.jetbrains.annotations.NotNull;

public class TempadScreen
extends Screen {
    public static final ResourceLocation GRID = new ResourceLocation("tempad", "textures/widget/tempad_grid.png");
    private static final ResourceLocation TVA_LOGO = new ResourceLocation("tempad", "textures/widget/tva_logo.png");
    private static final int WIDTH = 256;
    private static final int HEIGHT = 160;
    private final InteractionHand hand;
    private final List<LocationData> locations;

    public TempadScreen(InteractionHand hand, List<LocationData> locations) {
        super(CommonComponents.f_237098_);
        this.hand = hand;
        this.locations = locations;
    }

    protected void m_7856_() {
        super.m_7856_();
        int offset = 4;
        this.m_142416_((GuiEventListener)new TextButton((this.f_96543_ - 256) / 2 + 160 + offset, (this.f_96544_ - 160) / 2 + 72 + offset, (Component)Component.m_237115_((String)"gui.tempad.options"), -1, button -> this.f_96541_.m_91152_((Screen)new OptionsScreen(this))));
        this.m_142416_((GuiEventListener)new TextButton((this.f_96543_ - 256) / 2 + 160 + offset, (this.f_96544_ - 160) / 2 + 82 + offset, (Component)Component.m_237115_((String)"gui.tempad.run_program"), -1, button -> this.f_96541_.m_91152_((Screen)new RunProgramScreen(this.hand, this.locations))));
        this.m_142416_((GuiEventListener)new TextButton((this.f_96543_ - 256) / 2 + 160 + offset, (this.f_96544_ - 160) / 2 + 92 + offset, (Component)Component.m_237115_((String)"gui.tempad.wiki"), -1, button -> this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(bl -> {
            if (bl) {
                Util.m_137581_().m_137646_("https://codexadrian.tech/tempad-wiki");
            }
            this.f_96541_.m_91152_((Screen)this);
        }, "https://codexadrian.tech/tempad-wiki", true))));
    }

    private void renderOutline(GuiGraphics graphics) {
        int lineWidth = 4;
        graphics.m_280509_((this.f_96543_ - 256 - lineWidth) / 2, (this.f_96544_ - 160 - lineWidth) / 2, (this.f_96543_ + 256 + lineWidth) / 2, (this.f_96544_ + 160 + lineWidth) / 2, TempadClientConfig.color | 0xFF000000);
    }

    private void renderGridBackground(GuiGraphics graphics, float red, float green, float blue) {
        RenderSystem.setShaderColor((float)(red * 0.5f), (float)(green * 0.5f), (float)(blue * 0.5f), (float)1.0f);
        graphics.m_280411_(GRID, (this.f_96543_ - 256) / 2, (this.f_96544_ - 160) / 2, 256, 160, 0.0f, 0.0f, 256, 160, 16, 16);
    }

    private void renderTvaLogo(GuiGraphics graphics, float red, float green, float blue) {
        int tvaWidth = 144;
        int tvaHeight = 80;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
        graphics.m_280411_(TVA_LOGO, this.f_96543_ / 2 - tvaWidth + 24, (this.f_96544_ - tvaHeight) / 2, tvaWidth, tvaHeight, 0.0f, 0.0f, 32, 16, 32, 16);
    }

    private void renderHeaders(GuiGraphics graphics) {
        Font font = this.f_96541_.f_91062_;
        int cornerX = (this.f_96543_ - 256) / 2 + 3;
        int cornerY = (this.f_96544_ - 160) / 2 + 7;
        int x = cornerX + 160;
        int y = cornerY + 48;
        try (CloseablePoseStack pose = new CloseablePoseStack(graphics);){
            graphics.m_280430_(font, (Component)Component.m_237115_((String)"gui.tempad.header_line_1"), x, y, -1);
            graphics.m_280430_(font, (Component)Component.m_237115_((String)"gui.tempad.header_line_2"), x, y + 10, -1);
        }
    }

    public void m_280273_(@NotNull GuiGraphics guiGraphics) {
        super.m_280273_(guiGraphics);
        float red = (float)(TempadClientConfig.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(TempadClientConfig.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(TempadClientConfig.color & 0xFF) / 255.0f;
        this.renderOutline(guiGraphics);
        this.renderGridBackground(guiGraphics, red, green, blue);
        this.renderTvaLogo(guiGraphics, red, green, blue);
        this.renderHeaders(guiGraphics);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int i, int j, float f) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, i, j, f);
    }

    public boolean m_7043_() {
        return false;
    }
}

