/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import com.teamresourceful.resourcefullib.client.components.selection.SelectionList;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import java.util.ArrayList;
import java.util.List;
import me.codexadrian.tempad.client.config.TempadClientConfig;
import me.codexadrian.tempad.client.gui.NewLocationScreen;
import me.codexadrian.tempad.client.widgets.TextButton;
import me.codexadrian.tempad.client.widgets.TextEntry;
import me.codexadrian.tempad.client.widgets.TimedoorSprite;
import me.codexadrian.tempad.common.data.LocationData;
import me.codexadrian.tempad.common.network.NetworkHandler;
import me.codexadrian.tempad.common.network.messages.DeleteLocationPacket;
import me.codexadrian.tempad.common.network.messages.SummonTimedoorPacket;
import me.codexadrian.tempad.common.tempad.TempadItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class RunProgramScreen
extends Screen {
    private static final ResourceLocation GRID = new ResourceLocation("tempad", "textures/widget/tempad_grid.png");
    private static final int WIDTH = 256;
    private static final int HEIGHT = 160;
    private int mouseMovement;
    private int listSize;
    private final InteractionHand hand;
    private boolean interfaceNeedsReload = false;
    private final TimedoorSprite timedoorSprite;
    private final List<LocationData> locations;
    private final List<Button> displayedInterfaceButtons = new ArrayList<Button>();
    private final List<Button> upNextButtons = new ArrayList<Button>();

    public RunProgramScreen(InteractionHand hand, List<LocationData> locations) {
        super(Component.m_130674_((String)""));
        this.hand = hand;
        this.timedoorSprite = new TimedoorSprite(0, 0, TempadClientConfig.color, 96);
        this.locations = locations;
    }

    protected void m_7856_() {
        super.m_7856_();
        int offset = 3;
        this.timedoorSprite.changePosition((this.f_96543_ - 256) / 2 + 24, (this.f_96544_ - 160) / 2 + offset + 16);
        int x = (this.f_96543_ - 256) / 2 + offset + 144;
        int y = (this.f_96544_ - 160) / 2 + offset + 32;
        SelectionList list = (SelectionList)this.m_142416_((GuiEventListener)new SelectionList(x, y, 88, 90, 10, textEntry -> {
            if (textEntry != null) {
                this.locationButtonOnPress(textEntry.data);
            }
        }));
        list.updateEntries(this.locations.stream().map(TextEntry::new).toList());
        TextButton addLocation = new TextButton((this.f_96543_ - 256) / 2 + offset + 144, (this.f_96544_ - 160) / 2 + offset + 128 + 1, (Component)Component.m_237115_((String)"gui.tempad.new_location"), -1, button -> this.f_96541_.m_91152_((Screen)new NewLocationScreen(this.hand)));
        this.m_142416_((GuiEventListener)addLocation);
    }

    private void locationButtonOnPress(LocationData data) {
        MutableComponent locationName = Component.m_264568_((String)data.getLevelKey().m_135782_().m_214296_("dimension"), (String)data.getLevelKey().m_135782_().toString()).m_130946_(" [" + data.getBlockPos().m_123344_() + "]");
        TextButton displayedLocation = new TextButton((this.f_96543_ - 256) / 2 + 72 - this.f_96541_.f_91062_.m_92852_((FormattedText)locationName) / 2, (this.f_96544_ - 160) / 2 + 4 + 128 - 20, (Component)locationName, TempadClientConfig.color, button1 -> {});
        this.upNextButtons.add(displayedLocation);
        MutableComponent teleportText = Component.m_237115_((String)"gui.tempad.teleport");
        Item item = this.f_96541_.f_91074_.m_21120_(this.hand).m_41720_();
        if (item instanceof TempadItem) {
            TempadItem itemInHand = (TempadItem)item;
            teleportButton = new TextButton((this.f_96543_ - 256) / 2 + 72 - this.f_96541_.f_91062_.m_92852_((FormattedText)teleportText) / 2, (this.f_96544_ - 160) / 2 + 4 + 128 - 10, (Component)teleportText, TempadClientConfig.color, button2 -> this.teleportAction(data), () -> itemInHand.getOption().canTimedoorOpen((Player)this.f_96541_.f_91074_, this.f_96541_.f_91074_.m_21120_(this.hand)));
            this.upNextButtons.add(teleportButton);
        } else {
            teleportButton = new TextButton((this.f_96543_ - 256) / 2 + 72 - this.f_96541_.f_91062_.m_92852_((FormattedText)teleportText) / 2, (this.f_96544_ - 160) / 2 + 4 + 128 - 10, (Component)teleportText, TempadClientConfig.color, button2 -> this.teleportAction(data), () -> false);
            this.upNextButtons.add(teleportButton);
        }
        MutableComponent deleteText = Component.m_237115_((String)"gui.tempad.delete");
        TextButton deleteLocationButton = new TextButton((this.f_96543_ - 256) / 2 + 72 - this.f_96541_.f_91062_.m_92852_((FormattedText)deleteText) / 2, (this.f_96544_ - 160) / 2 + 4 + 128, (Component)deleteText, TempadClientConfig.color, button2 -> {
            Minecraft.m_91087_().m_91152_(null);
            NetworkHandler.CHANNEL.sendToServer((Packet)new DeleteLocationPacket(data.getId()));
        });
        this.upNextButtons.add(deleteLocationButton);
        this.interfaceNeedsReload = true;
    }

    private void teleportAction(LocationData data) {
        TempadItem tempadItem;
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        ItemStack itemInHand = this.f_96541_.f_91074_.m_21120_(this.hand);
        Item item = itemInHand.m_41720_();
        if (item instanceof TempadItem && (tempadItem = (TempadItem)item).getOption().canTimedoorOpen((Player)this.f_96541_.f_91074_, itemInHand)) {
            Minecraft.m_91087_().m_91152_(null);
            NetworkHandler.CHANNEL.sendToServer((Packet)new SummonTimedoorPacket(data.getId(), this.hand, TempadClientConfig.color));
        }
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.interfaceNeedsReload) {
            this.displayedInterfaceButtons.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
            this.displayedInterfaceButtons.clear();
            this.displayedInterfaceButtons.addAll(this.upNextButtons);
            this.upNextButtons.clear();
            this.displayedInterfaceButtons.forEach(x$0 -> {
                Button cfr_ignored_0 = (Button)this.m_142416_((GuiEventListener)x$0);
            });
            this.m_169411_(this.timedoorSprite);
            this.m_142416_(this.timedoorSprite);
            this.interfaceNeedsReload = false;
        }
    }

    private void renderOutline(@NotNull GuiGraphics graphics) {
        int lineWidth = 4;
        graphics.m_280509_((this.f_96543_ - 256 - lineWidth) / 2, (this.f_96544_ - 160 - lineWidth) / 2, (this.f_96543_ + 256 + lineWidth) / 2, (this.f_96544_ + 160 + lineWidth) / 2, TempadClientConfig.color | 0xFF000000);
    }

    private void renderGridBackground(@NotNull GuiGraphics graphics, float red, float green, float blue) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GRID);
        RenderSystem.setShaderColor((float)(red * 0.5f), (float)(green * 0.5f), (float)(blue * 0.5f), (float)1.0f);
        graphics.m_280411_(GRID, (this.f_96543_ - 256) / 2, (this.f_96544_ - 160) / 2, 256, 160, 0.0f, 0.0f, 256, 160, 16, 16);
    }

    public void m_280273_(@NotNull GuiGraphics graphics) {
        super.m_280273_(graphics);
        float red = (float)(TempadClientConfig.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(TempadClientConfig.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(TempadClientConfig.color & 0xFF) / 255.0f;
        this.renderOutline(graphics);
        this.renderGridBackground(graphics, red, green, blue);
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
        graphics.m_280509_((this.f_96543_ - 256) / 2 + 144, (this.f_96544_ - 160) / 2 + 32, (this.f_96543_ - 256) / 2 + 240, (this.f_96544_ - 160) / 2 + 128, -1);
        graphics.m_280509_((this.f_96543_ - 256) / 2 + 144 + 2, (this.f_96544_ - 160) / 2 + 32 + 2, (this.f_96543_ - 256) / 2 + 240 - 2, (this.f_96544_ - 160) / 2 + 128 - 2, -15527149);
        this.renderHeaders(graphics);
    }

    private void renderHeaders(@NotNull GuiGraphics graphics) {
        Font font = this.f_96541_.f_91062_;
        int cornerX = (this.f_96543_ - 256) / 2 + 3;
        int cornerY = (this.f_96544_ - 160) / 2 + 5;
        int x = cornerX + 144;
        int y = cornerY + 16;
        try (CloseablePoseStack pose = new CloseablePoseStack(graphics);){
            graphics.m_280430_(font, (Component)Component.m_237115_((String)"gui.tempad.select_location"), x, y, -1);
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_7043_() {
        return false;
    }
}

