/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import me.codexadrian.tempad.client.config.TempadClientConfig;
import me.codexadrian.tempad.common.Tempad;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class OptionsScreen
extends Screen {
    private static final ResourceLocation GRID = new ResourceLocation("tempad", "textures/widget/tempad_grid.png");
    private final Screen parent;
    private static final int WIDTH = 256;
    private static final int HEIGHT = 160;

    public OptionsScreen(Screen parent) {
        super(CommonComponents.f_237098_);
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        int colorPerRow = 10;
        int margin = 6;
        int scale = 16;
        int startX = (this.f_96543_ - 256) / 2 + 16 + 5;
        int startY = (this.f_96544_ - 160) / 2 + 48 + 2;
        int x = 0;
        int y = 0;
        int[] colors = TempadClientConfig.colorOptions;
        for (int i = 0; i < colors.length; ++i) {
            int finalI = i;
            ColorButton button = new ColorButton(x + startX, y + startY, scale, colors[i] | 0xFF000000, button1 -> {
                TempadClientConfig.color = colors[finalI];
                Tempad.CONFIGURATOR.saveConfig(TempadClientConfig.class);
            });
            this.m_142416_((GuiEventListener)button);
            x += scale + margin;
            if ((i + 1) % colorPerRow != 0) continue;
            x = 0;
            y += scale + margin;
        }
    }

    private void renderOutline(GuiGraphics graphics) {
        int lineWidth = 4;
        graphics.m_280509_((this.f_96543_ - 256 - lineWidth) / 2, (this.f_96544_ - 160 - lineWidth) / 2, (this.f_96543_ + 256 + lineWidth) / 2, (this.f_96544_ + 160 + lineWidth) / 2, TempadClientConfig.color | 0xFF000000);
    }

    private void renderGridBackground(@NotNull GuiGraphics graphics, float red, float green, float blue) {
        RenderSystem.setShaderColor((float)(red * 0.5f), (float)(green * 0.5f), (float)(blue * 0.5f), (float)1.0f);
        graphics.m_280411_(GRID, (this.f_96543_ - 256) / 2, (this.f_96544_ - 160) / 2, 256, 160, 0.0f, 0.0f, 256, 160, 16, 16);
    }

    public void m_280273_(@NotNull GuiGraphics graphics) {
        super.m_280273_(graphics);
        float red = (float)(TempadClientConfig.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(TempadClientConfig.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(TempadClientConfig.color & 0xFF) / 255.0f;
        this.renderOutline(graphics);
        this.renderGridBackground(graphics, red, green, blue);
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
        this.renderHeaders(graphics);
    }

    private void renderHeaders(GuiGraphics graphics) {
        Font font = this.f_96541_.f_91062_;
        int cornerX = (this.f_96543_ - 256) / 2 + 5;
        int cornerY = (this.f_96544_ - 160) / 2;
        int x = cornerX + 16;
        int y = cornerY + 32;
        try (CloseablePoseStack pose = new CloseablePoseStack(graphics);){
            graphics.m_280430_(font, (Component)Component.m_237115_((String)"gui.tempad.options_header"), x, y, -1);
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public static class ColorButton
    extends Button {
        private final int buttonColor;

        public ColorButton(int x, int y, int size, int buttonColor, Button.OnPress onPress) {
            super(x, y, size, size, Component.m_130674_((String)""), onPress, Button.f_252438_);
            this.buttonColor = buttonColor;
        }

        protected void m_87963_(GuiGraphics graphics, int i, int j, float f) {
            try (CloseablePoseStack pose = new CloseablePoseStack(graphics);){
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                graphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + 1 + this.f_93618_, this.m_252907_() + 1 + this.f_93619_, -1);
                graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, this.buttonColor);
            }
        }
    }
}

