/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.dragon.breed;

import com.github.kay9.dragonmounts.abilities.Ability;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.github.kay9.dragonmounts.dragon.breed.BreedRegistry;
import com.github.kay9.dragonmounts.habitats.Habitat;
import com.github.kay9.dragonmounts.util.DMLUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public record DragonBreed(int primaryColor, int secondaryColor, Optional<ParticleOptions> hatchParticles, ModelProperties modelProperties, Map<Attribute, Double> attributes, List<Ability> abilities, List<Habitat> habitats, ImmutableSet<String> immunities, Optional<Holder<SoundEvent>> ambientSound, ResourceLocation deathLoot, int growthTime, float hatchChance, float sizeModifier, HolderSet<Item> tamingItems, HolderSet<Item> breedingItems) {
    public static final Codec<DragonBreed> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DMLUtil.HEX_CODEC.fieldOf("primary_color").forGetter(DragonBreed::primaryColor), (App)DMLUtil.HEX_CODEC.fieldOf("secondary_color").forGetter(DragonBreed::secondaryColor), (App)ParticleTypes.f_123791_.optionalFieldOf("hatch_particles").forGetter(DragonBreed::hatchParticles), (App)ModelProperties.CODEC.optionalFieldOf("model_properties", (Object)ModelProperties.STANDARD).forGetter(DragonBreed::modelProperties), (App)Codec.unboundedMap((Codec)BuiltInRegistries.f_256951_.m_194605_(), (Codec)Codec.DOUBLE).optionalFieldOf("attributes", (Object)ImmutableMap.of()).forGetter(DragonBreed::attributes), (App)Ability.CODEC.listOf().optionalFieldOf("abilities", (Object)ImmutableList.of()).forGetter(DragonBreed::abilities), (App)Habitat.CODEC.listOf().optionalFieldOf("habitats", (Object)ImmutableList.of()).forGetter(DragonBreed::habitats), (App)Codec.STRING.listOf().xmap(ImmutableSet::copyOf, ImmutableList::copyOf).optionalFieldOf("immunities", (Object)ImmutableSet.of()).forGetter(DragonBreed::immunities), (App)SoundEvent.f_263130_.optionalFieldOf("ambient_sound").forGetter(DragonBreed::ambientSound), (App)ResourceLocation.f_135803_.optionalFieldOf("death_loot", (Object)BuiltInLootTables.f_78712_).forGetter(DragonBreed::deathLoot), (App)Codec.INT.optionalFieldOf("growth_time", (Object)72000).forGetter(DragonBreed::growthTime), (App)Codec.FLOAT.optionalFieldOf("hatch_chance", (Object)Float.valueOf(0.1f)).forGetter(DragonBreed::hatchChance), (App)Codec.FLOAT.optionalFieldOf("size_modifier", (Object)Float.valueOf(1.0f)).forGetter(DragonBreed::sizeModifier), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256913_).optionalFieldOf("taming_items", (Object)BuiltInRegistries.f_257033_.m_203561_(ItemTags.f_13156_)).forGetter(DragonBreed::tamingItems), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256913_).optionalFieldOf("breeding_items", (Object)BuiltInRegistries.f_257033_.m_203561_(ItemTags.f_13156_)).forGetter(DragonBreed::breedingItems)).apply((Applicative)instance, DragonBreed::new));
    public static final Codec<DragonBreed> NETWORK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("primary_color").forGetter(DragonBreed::primaryColor), (App)Codec.INT.fieldOf("secondary_color").forGetter(DragonBreed::secondaryColor), (App)ParticleTypes.f_123791_.optionalFieldOf("hatch_particles").forGetter(DragonBreed::hatchParticles), (App)ModelProperties.CODEC.fieldOf("model_properties").forGetter(DragonBreed::modelProperties), (App)SoundEvent.f_263130_.optionalFieldOf("ambient_sound").forGetter(DragonBreed::ambientSound), (App)Codec.INT.fieldOf("growth_time").forGetter(DragonBreed::growthTime), (App)Codec.FLOAT.optionalFieldOf("size_modifier", (Object)Float.valueOf(1.0f)).forGetter(DragonBreed::sizeModifier)).apply((Applicative)instance, DragonBreed::fromNetwork));

    public static DragonBreed fromNetwork(int primaryColor, int secondaryColor, Optional<ParticleOptions> hatchParticles, ModelProperties modelProperties, Optional<Holder<SoundEvent>> ambientSound, int growthTime, float sizeModifier) {
        return new DragonBreed(primaryColor, secondaryColor, hatchParticles, modelProperties, Map.of(), List.of(), List.of(), (ImmutableSet<String>)ImmutableSet.of(), ambientSound, BuiltInLootTables.f_78712_, growthTime, 0.0f, sizeModifier, DMLUtil.EMPTY_ITEM_HOLDER_SET, DMLUtil.EMPTY_ITEM_HOLDER_SET);
    }

    public void initialize(TameableDragon dragon) {
        this.applyAttributes(dragon);
        for (Ability a : this.abilities()) {
            a.initialize(dragon);
        }
    }

    public void close(TameableDragon dragon) {
        dragon.m_21204_().m_22159_(new AttributeMap(TameableDragon.createAttributes().m_22265_()));
        for (Ability a : this.abilities()) {
            a.close(dragon);
        }
    }

    private void applyAttributes(TameableDragon dragon) {
        float healthPercentile = dragon.m_21223_() / dragon.m_21233_();
        this.attributes().forEach((att, value) -> {
            AttributeInstance inst = dragon.m_21051_((Attribute)att);
            if (inst != null) {
                inst.m_22100_(value.doubleValue());
            }
        });
        dragon.m_21153_(dragon.m_21233_() * healthPercentile);
    }

    public ResourceLocation id(RegistryAccess reg) {
        return BreedRegistry.registry(reg).m_7981_((Object)this);
    }

    public static String getTranslationKey(String resourceLocation) {
        return "dragon_breed." + resourceLocation.replace(':', '.');
    }

    public record ModelProperties(boolean middleTailScales, boolean tailHorns, boolean thinLegs) {
        public static final ModelProperties STANDARD = new ModelProperties(true, false, false);
        public static final Codec<ModelProperties> CODEC = RecordCodecBuilder.create(func -> func.group((App)Codec.BOOL.optionalFieldOf("middle_tail_scales", (Object)true).forGetter(ModelProperties::middleTailScales), (App)Codec.BOOL.optionalFieldOf("tail_horns", (Object)false).forGetter(ModelProperties::tailHorns), (App)Codec.BOOL.optionalFieldOf("thin_legs", (Object)false).forGetter(ModelProperties::thinLegs)).apply((Applicative)func, ModelProperties::new));
    }
}

