/*
 * Decompiled with CFR 0.152.
 */
package com.github.kay9.dragonmounts.client;

import com.github.kay9.dragonmounts.DragonMountsLegacy;
import com.github.kay9.dragonmounts.client.DragonAnimator;
import com.github.kay9.dragonmounts.client.DragonModel;
import com.github.kay9.dragonmounts.dragon.TameableDragon;
import com.github.kay9.dragonmounts.dragon.breed.DragonBreed;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class DragonRenderer
extends MobRenderer<TameableDragon, DragonModel> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(DragonMountsLegacy.id("dragon"), "main");
    private static final ResourceLocation DISSOLVE_TEXTURE = DragonMountsLegacy.id("textures/entity/dragon/dissolve.png");
    private static final Map<ResourceLocation, ResourceLocation[]> TEXTURE_CACHE = new HashMap<ResourceLocation, ResourceLocation[]>(8);
    public final RenderLayer<TameableDragon, DragonModel> GLOW_LAYER = new RenderLayer<TameableDragon, DragonModel>((RenderLayerParent)this){

        public void render(PoseStack pMatrixStack, MultiBufferSource buffer, int pPackedLight, TameableDragon dragon, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (dragon.f_20919_ == 0) {
                RenderType type = CustomRenderTypes.glow(DragonRenderer.getTextureForLayer(dragon.getBreed(), 1));
                ((DragonModel)DragonRenderer.this.f_115290_).m_7695_(pMatrixStack, buffer.m_6299_(type), pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    };
    public final RenderLayer<TameableDragon, DragonModel> SADDLE_LAYER = new RenderLayer<TameableDragon, DragonModel>((RenderLayerParent)this){

        public void render(PoseStack ps, MultiBufferSource buffer, int light, TameableDragon dragon, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (dragon.m_6254_()) {
                2.m_117376_((EntityModel)DragonRenderer.this.f_115290_, (ResourceLocation)DragonRenderer.getTextureForLayer(dragon.getBreed(), 2), (PoseStack)ps, (MultiBufferSource)buffer, (int)light, (LivingEntity)dragon, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    };
    public final RenderLayer<TameableDragon, DragonModel> DEATH_LAYER = new RenderLayer<TameableDragon, DragonModel>((RenderLayerParent)this){

        public void render(PoseStack ps, MultiBufferSource buffer, int light, TameableDragon dragon, float limbSwing, float limbSwingAmount, float partials, float age, float yaw, float pitch) {
            if (dragon.f_20919_ > 0) {
                float delta = (float)dragon.f_20919_ / (float)dragon.getMaxDeathTime();
                ((DragonModel)DragonRenderer.this.f_115290_).m_7695_(ps, buffer.m_6299_(CustomRenderTypes.DISSOLVE), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, delta);
                ((DragonModel)DragonRenderer.this.f_115290_).m_7695_(ps, buffer.m_6299_(RenderType.m_110479_((ResourceLocation)this.m_117347_((Entity)dragon))), light, OverlayTexture.m_118090_((float)0.0f, (boolean)true), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    };

    public DragonRenderer(EntityRendererProvider.Context modelBakery) {
        super(modelBakery, (EntityModel)new DragonModel(modelBakery.m_174023_(LAYER_LOCATION)), 2.0f);
        this.m_115326_(this.GLOW_LAYER);
        this.m_115326_(this.SADDLE_LAYER);
        this.m_115326_(this.DEATH_LAYER);
    }

    @Nullable
    protected RenderType getRenderType(TameableDragon entity, boolean visible, boolean invisToClient, boolean glowing) {
        return entity.f_20919_ > 0 ? null : super.m_7225_((LivingEntity)entity, visible, invisToClient, glowing);
    }

    protected void setupRotations(TameableDragon dragon, PoseStack ps, float age, float yaw, float partials) {
        super.m_7523_((LivingEntity)dragon, ps, age, yaw, partials);
        DragonAnimator animator = dragon.getAnimator();
        float scale = dragon.m_6134_();
        ps.m_85841_(scale, scale, scale);
        ps.m_252880_(animator.getModelOffsetX(), animator.getModelOffsetY(), animator.getModelOffsetZ());
        ps.m_85837_(0.0, 1.5, 0.5);
        ps.m_252781_(Axis.f_252529_.m_252977_(animator.getModelPitch(partials)));
        ps.m_85837_(0.0, -1.5, -0.5);
    }

    protected float getFlipDegrees(TameableDragon pLivingEntity) {
        return 0.0f;
    }

    public ResourceLocation getTextureLocation(TameableDragon dragon) {
        return DragonRenderer.getTextureForLayer(dragon.getBreed(), 0);
    }

    public static ResourceLocation getTextureForLayer(DragonBreed breed, int layer) {
        return TEXTURE_CACHE.computeIfAbsent(breed.id(Minecraft.m_91087_().f_91073_.m_9598_()), DragonRenderer::cacheTextures)[layer];
    }

    private static ResourceLocation[] cacheTextures(ResourceLocation id) {
        String[] TEXTURES = new String[]{"body", "glow", "saddle"};
        ResourceLocation[] cache = new ResourceLocation[3];
        for (int i = 0; i < TEXTURES.length; ++i) {
            cache[i] = new ResourceLocation(id.m_135827_(), "textures/entity/dragon/" + id.m_135815_() + "/" + TEXTURES[i] + ".png");
        }
        return cache;
    }

    private static class CustomRenderTypes
    extends RenderType {
        private static final RenderType DISSOLVE = RenderType.m_173235_((ResourceLocation)DISSOLVE_TEXTURE);
        private static final Function<ResourceLocation, RenderType> GLOW_FUNC = Util.m_143827_(texture -> CustomRenderTypes.m_173215_((String)"eyes", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173073_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(f_110139_).m_110687_(f_110115_).m_110691_(false)));

        private static RenderType glow(ResourceLocation texture) {
            return GLOW_FUNC.apply(texture);
        }

        private CustomRenderTypes() {
            super(null, null, null, 0, false, true, null, null);
        }
    }
}

